/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.parser.NodeLocation;
import java.util.Optional;

public class ParsingException
extends RuntimeException {
    private final int line;
    private final int charPositionInLine;
    private final String unloggedDetails;

    public ParsingException(String message, Optional<NodeLocation> nodeLocation) {
        this(message, nodeLocation.map(NodeLocation::getStartLineNumber).orElse(1), nodeLocation.map(NodeLocation::getStartColumnNumber).orElse(0));
    }

    public ParsingException(String message, int line, int charPositionInLine) {
        super("Syntax error at line " + line + ":" + (charPositionInLine + 1));
        this.unloggedDetails = message;
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return String.format("line %s:%s: %s", this.getLineNumber(), this.getColumnNumber(), this.getErrorMessage());
    }

    public String getUnloggedDetails() {
        return String.format("line %s:%s: %s", this.getLineNumber(), this.getColumnNumber(), this.unloggedDetails);
    }
}

