/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.schema.ksql.SqlTypeParser;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.ParserUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class SchemaParser {
    private final TypeRegistry typeRegistry;

    public SchemaParser(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry");
    }

    public static TableElements parse(String schema, TypeRegistry typeRegistry) {
        return new SchemaParser(typeRegistry).parse(schema);
    }

    public TableElements parse(final String schema) {
        if (schema.trim().isEmpty()) {
            return TableElements.of(new TableElement[0]);
        }
        SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)("(" + schema + ")"))));
        CommonTokenStream tokStream = new CommonTokenStream((TokenSource)lexer);
        SqlBaseParser parser = new SqlBaseParser((TokenStream)tokStream);
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new KsqlException(String.format("Error parsing schema \"%s\" at %d:%d: %s", schema, line, charPositionInLine, msg), (Throwable)e);
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        SqlTypeParser typeParser = SqlTypeParser.create(this.typeRegistry);
        List<TableElement> elements = parser.tableElements().tableElement().stream().map(ctx -> new TableElement(ParserUtil.getLocation(ctx), ColumnName.of((String)ParserUtil.getIdentifierText(ctx.identifier())), typeParser.getType(ctx.type()), ParserUtil.getColumnConstraints(ctx.columnConstraints()))).collect(Collectors.toList());
        return TableElements.of(elements);
    }
}

