/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.util.ParserKeywordValidatorUtil;
import io.confluent.ksql.util.ParserUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.apache.commons.text.similarity.LevenshteinDetailedDistance;

public class SyntaxErrorValidator
extends BaseErrorListener {
    private static final Pattern EXTRANEOUS_INPUT_PATTERN = Pattern.compile("extraneous input.*expecting.*");
    private static final Pattern MISMATCHED_INPUT_PATTERN = Pattern.compile("mismatched input.*expecting.*");
    private final List<String> commands = Arrays.asList("SELECT", "CREATE", "INSERT", "DESCRIBE", "PRINT", "EXPLAIN", "SHOW", "LIST", "TERMINATE", "PAUSE", "RESUME", "DROP", "SET", "DEFINE", "UNDEFINE", "UNSET", "ASSERT", "ALTER");
    private static final Map<Class<?>, BiFunction<String, RecognitionException, Boolean>> ERROR_VALIDATORS = ImmutableMap.of(SqlBaseParser.VariableNameContext.class, SyntaxErrorValidator::isValidVariableName);

    private static boolean isValidVariableName(String errorMessage, RecognitionException exception) {
        if (MISMATCHED_INPUT_PATTERN.matcher(errorMessage).matches() && exception.getOffendingToken() != null) {
            return ParserKeywordValidatorUtil.getKsqlReservedWords().contains(exception.getOffendingToken().getText());
        }
        return false;
    }

    private static boolean validateErrorContext(RuleContext context, String errorMessage, RecognitionException exception) {
        BiFunction<String, RecognitionException, Boolean> validator = ERROR_VALIDATORS.get(context.getClass());
        if (validator == null) {
            return false;
        }
        return validator.apply(errorMessage, exception);
    }

    private static boolean shouldIgnoreSyntaxError(String errorMessage, RecognitionException exception) {
        if (exception.getCtx() != null) {
            return SyntaxErrorValidator.validateErrorContext(exception.getCtx(), errorMessage, exception);
        }
        return false;
    }

    private static boolean isKeywordError(String message, String offendingSymbol) {
        Matcher m = EXTRANEOUS_INPUT_PATTERN.matcher(message);
        return m.find() && ParserUtil.isReserved(offendingSymbol);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        if (e != null && SyntaxErrorValidator.shouldIgnoreSyntaxError(message, e)) {
            return;
        }
        if (offendingSymbol instanceof Token) {
            StringBuilder sb = new StringBuilder();
            sb.append("Syntax Error\n");
            if (SyntaxErrorValidator.isKeywordError(message, ((Token)offendingSymbol).getText())) {
                String tokenName = ((Token)offendingSymbol).getText();
                sb.append(String.format("\"%s\" is a reserved keyword and it can't be used as an identifier. You can use it as an identifier by escaping it as '%s' ", tokenName, tokenName));
            } else if (message.contains("expecting")) {
                sb.append(this.getExpectations(message, ((Token)offendingSymbol).getText()));
            } else if (e instanceof NoViableAltException) {
                sb.append(String.format("Syntax error at or near '%s' at line %d:%d", ((Token)offendingSymbol).getText(), line, charPositionInLine + 1));
            } else {
                sb.append(message);
            }
            throw new ParsingException(sb.toString(), line, charPositionInLine);
        }
        throw new ParsingException(message, line, charPositionInLine);
    }

    private String getExpectations(String message, String offendingToken) {
        StringBuilder output = new StringBuilder();
        String expectingStr = message.split("expecting ")[1];
        if (this.isCommand(expectingStr)) {
            output.append(String.format("Unknown statement '%s'%n", offendingToken));
            output.append(String.format("Did you mean '%s'?", this.getMostSimilar(offendingToken)));
        } else if (message.contains("EOF")) {
            output.append("Syntax error at or near \";\"\n");
            output.append("'}', ']', or ')' is missing");
        } else if (expectingStr.split(",").length <= 3) {
            output.append(String.format("Expecting %s", expectingStr));
        }
        return output.toString();
    }

    private boolean isCommand(String expectingStr) {
        List<String> expectedList = Arrays.asList(expectingStr.replace("{", "").replace("}", "").replace("<EOF>,", "").replace(" '", "").replace("'", "").split(","));
        return expectedList.equals(this.commands);
    }

    private String getMostSimilar(String target) {
        LevenshteinDetailedDistance computer = LevenshteinDetailedDistance.getDefaultInstance();
        int min = Integer.MAX_VALUE;
        String output = "";
        for (String command : this.commands) {
            int distance = computer.apply((CharSequence)command, (CharSequence)target.toUpperCase()).getDistance();
            if (distance >= min) continue;
            min = distance;
            output = command;
        }
        return output;
    }
}

