/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.Relation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final SourceName alias;

    public AliasedRelation(Relation relation, SourceName alias) {
        this(Optional.empty(), relation, alias);
    }

    public AliasedRelation(Optional<NodeLocation> location, Relation relation, SourceName alias) {
        super(location);
        this.relation = Objects.requireNonNull(relation, "relation");
        this.alias = Objects.requireNonNull(alias, "alias");
    }

    public Relation getRelation() {
        return this.relation;
    }

    public SourceName getAlias() {
        return this.alias;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("relation", (Object)this.relation).add("alias", (Object)this.alias).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)((Object)o);
        return Objects.equals((Object)this.relation, (Object)that.relation) && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.alias});
    }
}

