/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.windows.WindowTimeClause;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AssertResource;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class AssertTopic
extends AssertResource {
    private final String topic;
    private final ImmutableMap<String, Literal> config;

    public AssertTopic(Optional<NodeLocation> location, String topic, Map<String, Literal> config, Optional<WindowTimeClause> timeout, boolean exists) {
        super(location, timeout, exists);
        this.topic = Objects.requireNonNull(topic, "topic");
        this.config = ImmutableMap.copyOf(Objects.requireNonNull(config, "config"));
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, Literal> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AssertTopic that = (AssertTopic)((Object)o);
        return this.topic.equals(that.topic) && Objects.equals(this.config, that.config) && this.timeout.equals(that.timeout) && this.exists == that.exists;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.config, this.timeout, this.exists);
    }

    public String toString() {
        return "AssertTopic{topic=" + this.topic + ",config=" + String.valueOf(this.config) + ",timeout=" + String.valueOf(this.timeout) + ",exists=" + this.exists + "}";
    }
}

