/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.parser.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.tree.AstNode;
import io.confluent.ksql.parser.tree.AstVisitor;
import io.confluent.ksql.parser.tree.SelectItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class Select
extends AstNode {
    private final ImmutableList<SelectItem> selectItems;

    public Select(List<SelectItem> selectItems) {
        this(Optional.empty(), selectItems);
    }

    public Select(Optional<NodeLocation> location, List<SelectItem> selectItems) {
        super(location);
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectItems is ImmutableList")
    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("selectItems", this.selectItems).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)((Object)o);
        return Objects.equals(this.selectItems, select.selectItems);
    }

    public int hashCode() {
        return Objects.hash(this.selectItems);
    }
}

