/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.confluent.ksql.parser.SqlBaseLexer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class GrammarTokenExporter {
    private static final Pattern pattern = Pattern.compile("(T__[0-9]|\\w+_\\w+|UNRECOGNIZED)");

    private GrammarTokenExporter() {
    }

    public static void main(String[] args) throws IOException {
        List<String> tokens = GrammarTokenExporter.getTokens();
        ArrayList<CallSite> tokensWithQuotes = new ArrayList<CallSite>();
        for (String token : tokens) {
            tokensWithQuotes.add((CallSite)((Object)("'" + token + "'")));
        }
        System.out.println(tokensWithQuotes);
    }

    public static List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(SqlBaseLexer.ruleNames));
        return tokens.stream().filter(pattern.asPredicate().negate()).collect(Collectors.toList());
    }
}

