/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.parser.SqlBaseParser;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.concurrent.ThreadSafe;
import org.antlr.v4.runtime.Vocabulary;

@ThreadSafe
public class ParserKeywordValidatorUtil
implements Predicate<String> {
    private static final ImmutableSet<String> JAVA_RESERVED_WORDS = ImmutableSet.builder().add((Object)"abstract").add((Object)"assert").add((Object)"boolean").add((Object)"break").add((Object)"byte").add((Object)"case").add((Object)"catch").add((Object)"char").add((Object)"class").add((Object)"const").add((Object)"continue").add((Object)"default").add((Object)"double").add((Object)"else").add((Object)"enum").add((Object)"extends").add((Object)"do").add((Object)"final").add((Object)"finally").add((Object)"float").add((Object)"for").add((Object)"goto").add((Object)"if").add((Object)"int").add((Object)"implements").add((Object)"import").add((Object)"instanceof").add((Object)"interface").add((Object)"long").add((Object)"native").add((Object)"new").add((Object)"package").add((Object)"private").add((Object)"public").add((Object)"protected").add((Object)"return").add((Object)"this").add((Object)"throw").add((Object)"throws").add((Object)"transient").add((Object)"try").add((Object)"short").add((Object)"static").add((Object)"strictfp").add((Object)"super").add((Object)"switch").add((Object)"synchronized").add((Object)"void").add((Object)"volatile").add((Object)"while").build();
    private static final ImmutableSet<String> ALLOWED_KSQL_WORDS = ImmutableSet.copyOf(Arrays.asList("concat", "substring", "replace"));
    private static final ImmutableSet<String> KSQL_RESERVED_WORDS = ParserKeywordValidatorUtil.createFromVocabulary();

    @Override
    public boolean test(String functionName) {
        if (functionName == null || functionName.trim().isEmpty() || JAVA_RESERVED_WORDS.contains((Object)functionName.toLowerCase()) || KSQL_RESERVED_WORDS.contains((Object)functionName.toLowerCase())) {
            return false;
        }
        return ParserKeywordValidatorUtil.isValidJavaIdentifier(functionName);
    }

    private static boolean isValidJavaIdentifier(String functionName) {
        char[] characters = functionName.toCharArray();
        if (!Character.isJavaIdentifierStart((int)characters[0])) {
            return false;
        }
        for (int i = 1; i < characters.length; ++i) {
            if (Character.isJavaIdentifierPart((int)characters[i])) continue;
            return false;
        }
        return true;
    }

    private static ImmutableSet<String> createFromVocabulary() {
        Vocabulary vocabulary = SqlBaseParser.VOCABULARY;
        int tokens = vocabulary.getMaxTokenType();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < tokens; ++i) {
            String keyWord;
            String symbolicName = vocabulary.getSymbolicName(i);
            if (symbolicName == null || ALLOWED_KSQL_WORDS.contains((Object)(keyWord = symbolicName.toLowerCase()))) continue;
            builder.add((Object)keyWord);
        }
        return builder.build();
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="KSQL_RESERVED_WORDS is ImmutableSet")
    public static Set<String> getKsqlReservedWords() {
        return KSQL_RESERVED_WORDS;
    }
}

