/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class QueryGuid {
    private final String namespace;
    private final String queryGuid;
    private final String structuralGuid;

    public QueryGuid(String namespace, String nonAnonQuery, String anonQuery) {
        this.namespace = namespace;
        this.queryGuid = QueryGuid.computeQueryGuid(nonAnonQuery, namespace);
        this.structuralGuid = QueryGuid.computeQueryGuid(anonQuery, "");
    }

    private static String computeQueryGuid(String query, String namespace) {
        String genericQuery = QueryGuid.getGenericQueryForm(query);
        String namespacePlusQuery = namespace + genericQuery;
        return UUID.nameUUIDFromBytes(namespacePlusQuery.getBytes(StandardCharsets.UTF_8)).toString();
    }

    private static String getGenericQueryForm(String query) {
        return query.replaceAll("[\\n\\t ]", "");
    }

    public String getQueryGuid() {
        return this.queryGuid;
    }

    public String getStructuralGuid() {
        return this.structuralGuid;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

