/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.SqlBaseBaseVisitor;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.util.ParserUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;

public final class QueryMask {
    private static final ImmutableSet<String> ALLOWED_KEYS = ImmutableSet.of((Object)"connector.class");
    private static final String MASKED_STRING = "'[string]'";
    private static final String MASKED_VALUE = "'[value]'";

    private QueryMask() {
    }

    public static String getMaskedStatement(String query) {
        try {
            SqlBaseParser.StatementsContext tree = DefaultKsqlParser.getParseTree(query);
            return (String)new Visitor().visit((ParseTree)tree);
        }
        catch (Exception | StackOverflowError e) {
            return QueryMask.fallbackMasking(query);
        }
    }

    public static Map<String, String> getMaskedConnectConfig(Map<String, String> config) {
        return config.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (ALLOWED_KEYS.contains(e.getKey())) {
                return (String)e.getValue();
            }
            return MASKED_STRING;
        }));
    }

    private static String fallbackMasking(String query) {
        return QueryMask.fallbackMaskConnectProperties(QueryMask.fallbackMaskValues(query));
    }

    private static String fallbackMaskValues(String query) {
        if (StringUtils.indexOfIgnoreCase((CharSequence)query.replaceAll("\\s+", ""), (CharSequence)")VALUES(") < 0) {
            return query;
        }
        int valueIdx = StringUtils.indexOfIgnoreCase((CharSequence)query, (CharSequence)"VALUES");
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("([^(,;)]+)(?!.*\\()", 42);
        Matcher matcher = pattern.matcher(query);
        while (matcher.find()) {
            if (matcher.start() <= valueIdx) continue;
            matcher.appendReplacement(sb, MASKED_VALUE);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String fallbackMaskConnectProperties(String query) {
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("('[^']+'|\"[^\"]+\"|`[^`]+`)\\s*=\\s*('[^']*')", 42);
        Matcher matcher = pattern.matcher(query);
        while (matcher.find()) {
            String matchedString = matcher.group(0);
            char quote = matcher.group(1).charAt(0);
            String key = matcher.group(1).substring(1, matcher.group(1).length() - 1);
            if (!ALLOWED_KEYS.contains((Object)key)) {
                String replacement = quote + key + quote + "='[string]'";
                matcher.appendReplacement(sb, replacement);
                continue;
            }
            matcher.appendReplacement(sb, matchedString);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static final class Visitor
    extends SqlBaseBaseVisitor<String> {
        private boolean masked;

        private Visitor() {
        }

        @Override
        public String visitStatements(SqlBaseParser.StatementsContext context) {
            ArrayList<String> statementList = new ArrayList<String>();
            for (SqlBaseParser.SingleStatementContext stmtContext : context.singleStatement()) {
                this.masked = false;
                String statement = this.visitSingleStatement(stmtContext);
                if (this.masked) {
                    statementList.add(statement);
                    continue;
                }
                int start = stmtContext.start.getStartIndex();
                int end = stmtContext.stop.getStopIndex();
                Interval interval = new Interval(start, end);
                String original = stmtContext.start.getInputStream().getText(interval);
                statementList.add(original);
            }
            return StringUtils.join(statementList, (String)"\n");
        }

        @Override
        public String visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
            return String.format("%s;", this.visit((ParseTree)context.statement()));
        }

        @Override
        public String visitInsertValues(SqlBaseParser.InsertValuesContext context) {
            StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
            if (context.sourceName() != null) {
                stringBuilder.append(ParserUtil.getSourceName(context.sourceName()));
            }
            if (context.columns() != null) {
                stringBuilder.append(String.format(" (%s)", StringUtils.join((Iterable)context.columns().identifier().stream().map(ParserUtil::getIdentifierText).map(ColumnName::of).map(Name::toString).collect(Collectors.toList()), (String)", ")));
            }
            String values = String.join((CharSequence)", ", Collections.nCopies(context.values().valueExpression().size(), QueryMask.MASKED_VALUE));
            stringBuilder.append(String.format(" VALUES (%s)", values));
            this.masked = true;
            return stringBuilder.toString();
        }

        @Override
        public String visitCreateConnector(SqlBaseParser.CreateConnectorContext context) {
            StringBuilder stringBuilder = new StringBuilder("CREATE");
            if (context.SOURCE() != null) {
                stringBuilder.append(" SOURCE");
            } else if (context.SINK() != null) {
                stringBuilder.append(" SINK");
            }
            stringBuilder.append(" CONNECTOR");
            if (context.EXISTS() != null) {
                stringBuilder.append(" IF NOT EXISTS");
            }
            stringBuilder.append(" ").append(context.identifier().getText());
            if (context.tableProperties() != null) {
                stringBuilder.append((String)this.visit((ParseTree)context.tableProperties()));
            }
            return stringBuilder.toString();
        }

        @Override
        public String visitTableProperties(SqlBaseParser.TablePropertiesContext context) {
            if (!(context.parent instanceof SqlBaseParser.CreateConnectorContext)) {
                return null;
            }
            ArrayList<String> tableProperties = new ArrayList<String>();
            for (SqlBaseParser.TablePropertyContext prop : context.tableProperty()) {
                String unquotedLowerKey;
                String key;
                StringBuilder formattedProp = new StringBuilder();
                if (prop.identifier() != null) {
                    key = prop.identifier().getText();
                    unquotedLowerKey = ParserUtil.getIdentifierText(prop.identifier()).toLowerCase();
                } else {
                    key = prop.STRING().getText();
                    unquotedLowerKey = ParserUtil.unquote(key, "'");
                }
                formattedProp.append(key);
                String value = ALLOWED_KEYS.contains((Object)unquotedLowerKey) ? prop.literal().getText() : QueryMask.MASKED_STRING;
                formattedProp.append("=").append(value);
                tableProperties.add(formattedProp.toString());
            }
            this.masked = true;
            return String.format(" WITH (%s)", StringUtils.join(tableProperties, (String)", "));
        }
    }
}

