/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum.algorithms;

import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Crc32C;

public class Crc32cAlgorithms {
    public static final int POLY = -2097792136;
    public static final int INVERSE_POLY = 99383025;
    public static final int GF2_DIM = 32;

    public static Checksum removeZeros(long crc, int zerosToRemove) {
        long[] even = new long[32];
        long[] odd = new long[32];
        long row = 0x80000000L;
        if (zerosToRemove <= 0) {
            return Crc32C.create((int)((int)crc));
        }
        odd[0] = 99383025L;
        for (int n = 1; n < 32; ++n) {
            odd[n] = row;
            row >>= 1;
        }
        Crc32cAlgorithms.gf2MatrixSquareForTruncate(even, odd);
        Crc32cAlgorithms.gf2MatrixSquareForTruncate(odd, even);
        do {
            Crc32cAlgorithms.gf2MatrixSquareForTruncate(even, odd);
            if ((zerosToRemove & 1) != 0) {
                crc = Crc32cAlgorithms.gf2MatrixTimesForTruncate(even, crc);
            }
            if ((zerosToRemove >>= 1) == 0) break;
            Crc32cAlgorithms.gf2MatrixSquareForTruncate(odd, even);
            if ((zerosToRemove & 1) == 0) continue;
            crc = Crc32cAlgorithms.gf2MatrixTimesForTruncate(odd, crc);
        } while ((zerosToRemove >>= 1) != 0);
        return Crc32C.create((int)((int)crc));
    }

    private static long gf2MatrixTimesForTruncate(long[] matrix, long vector) {
        long sum = 0L;
        int i = 0;
        while (vector != 0L) {
            if ((vector & 0x80000000L) != 0L) {
                sum ^= matrix[i];
            }
            vector = vector << 1 & 0xFFFFFFFFL;
            ++i;
        }
        return sum;
    }

    private static void gf2MatrixSquareForTruncate(long[] square, long[] matrix) {
        for (int n = 0; n < 32; ++n) {
            square[n] = Crc32cAlgorithms.gf2MatrixTimesForTruncate(matrix, matrix[n]);
        }
    }

    public static long combineCRC32C(long crc1, long crc2, long len2) {
        long[] even = new long[32];
        long[] odd = new long[32];
        if (len2 <= 0L) {
            return crc1;
        }
        odd[0] = 2197175160L;
        long row = 1L;
        for (int n = 1; n < 32; ++n) {
            odd[n] = row;
            row <<= 1;
        }
        Crc32cAlgorithms.gfTwoMatrixSquareForCombine(even, odd);
        Crc32cAlgorithms.gfTwoMatrixSquareForCombine(odd, even);
        do {
            Crc32cAlgorithms.gfTwoMatrixSquareForCombine(even, odd);
            if ((len2 & 1L) != 0L) {
                crc1 = Crc32cAlgorithms.gfTwoMatrixTimesForCombine(even, crc1);
            }
            if ((len2 >>= 1) == 0L) break;
            Crc32cAlgorithms.gfTwoMatrixSquareForCombine(odd, even);
            if ((len2 & 1L) == 0L) continue;
            crc1 = Crc32cAlgorithms.gfTwoMatrixTimesForCombine(odd, crc1);
        } while ((len2 >>= 1) != 0L);
        return crc1 ^= crc2;
    }

    private static long gfTwoMatrixTimesForCombine(long[] mat, long vec) {
        long sum = 0L;
        int index = 0;
        while (vec != 0L) {
            if ((vec & 1L) != 0L) {
                sum ^= mat[index];
            }
            vec >>= 1;
            ++index;
        }
        return sum;
    }

    private static void gfTwoMatrixSquareForCombine(long[] square, long[] mat) {
        for (int n = 0; n < 32; ++n) {
            square[n] = Crc32cAlgorithms.gfTwoMatrixTimesForCombine(mat, mat[n]);
        }
    }
}

