/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier;

import java.util.HashMap;
import java.util.Map;

public enum TierBackend {
    S3("S3"),
    GCS("GCS"),
    ABS("AzureBlockBlob"),
    MOCK("mock"),
    NONE("");

    private static final Map<String, TierBackend> VALUE_TO_ENUM;
    private final String value;

    private TierBackend(String value) {
        this.value = value;
    }

    public static TierBackend toEnum(String value) {
        if (value == null || !VALUE_TO_ENUM.containsKey(value)) {
            throw new IllegalArgumentException(String.format("Unknown value: %s for TierBackend enum", value));
        }
        return VALUE_TO_ENUM.get(value);
    }

    public String value() {
        return this.value;
    }

    static {
        VALUE_TO_ENUM = new HashMap<String, TierBackend>();
        for (TierBackend backend : TierBackend.values()) {
            VALUE_TO_ENUM.put(backend.value(), backend);
        }
    }
}

