/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.serdes.PartitionUnfreezeLogStartOffset;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.UUID;

public class TierPartitionUnfreezeLogStartOffset
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 40;
    private final TopicIdPartition topicIdPartition;
    private final PartitionUnfreezeLogStartOffset metadata;

    public TierPartitionUnfreezeLogStartOffset(TopicIdPartition topicIdPartition, UUID messageId) {
        FlatBufferBuilder builder = new FlatBufferBuilder(40).forceDefaults(true);
        PartitionUnfreezeLogStartOffset.startPartitionUnfreezeLogStartOffset(builder);
        PartitionUnfreezeLogStartOffset.addVersion(builder, (byte)0);
        int messageIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        PartitionUnfreezeLogStartOffset.addMessageId(builder, messageIdOffset);
        int entryId = PartitionUnfreezeLogStartOffset.endPartitionUnfreezeLogStartOffset(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = PartitionUnfreezeLogStartOffset.getRootAsPartitionUnfreezeLogStartOffset(builder.dataBuffer());
    }

    public TierPartitionUnfreezeLogStartOffset(TopicIdPartition topicIdPartition, PartitionUnfreezeLogStartOffset metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 40;
    }

    public byte version() {
        return this.metadata.version();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.PartitionUnfreezeLogStartOffset;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public int tierEpoch() {
        return -1;
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    public String toString() {
        return "TierPartitionUnfreezeLogStartOffset(version=" + this.version() + ", topicIdPartition=" + String.valueOf(this.topicIdPartition()) + ", messageIdAsBase64=" + this.messageIdAsBase64() + ")";
    }
}

