/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.store;

import io.confluent.kafka.storage.tier.store.ThrottledFileInputStream;
import io.confluent.kafka.storage.tier.store.objects.TierSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedObjectStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(CombinedObjectStream.class);
    private final Collection<Object> fragments;
    private final Throttler throttler;
    private final ObjectStoreMetadata objectMetadata;
    private final long length;
    private long markedPosition = 0L;
    private long position = 0L;

    public CombinedObjectStream(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        super(CombinedObjectStream.makeSequence(tierSegmentUpload.orderedFragmentsForCombinedObject().values(), tierSegmentUpload.throttlerOpt().orElse(null)));
        this.fragments = tierSegmentUpload.orderedFragmentsForCombinedObject().values();
        this.throttler = tierSegmentUpload.throttlerOpt().orElse(null);
        this.length = tierSegmentUpload.length();
        this.objectMetadata = tierSegmentUpload.objectMetadata();
    }

    public CombinedObjectStream(List<Object> fragments, long length, ObjectStoreMetadata objectMetadata) throws IOException {
        super(CombinedObjectStream.makeSequence(fragments, null));
        this.fragments = fragments;
        this.throttler = null;
        this.length = length;
        this.objectMetadata = objectMetadata;
    }

    public long length() {
        return this.length;
    }

    private static void tryCloseAll(List<InputStream> streams) {
        for (InputStream is : streams) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("error closing inner stream", (Throwable)e);
            }
        }
    }

    public static SequenceInputStream makeSequence(Collection<Object> fragments, Throttler throttler) throws IOException {
        ArrayList<InputStream> inOrderFragmentStreams = new ArrayList<InputStream>();
        File file = null;
        try {
            for (Object fragment : fragments) {
                if (fragment == null) {
                    log.debug("Skipping null value in ordered fragments for CombinedObject");
                    continue;
                }
                if (fragment instanceof File) {
                    file = (File)fragment;
                    FileInputStream fis = throttler != null ? new ThrottledFileInputStream(file, throttler) : new FileInputStream(file);
                    inOrderFragmentStreams.add(fis);
                    file = null;
                    continue;
                }
                if (fragment instanceof ByteBuffer) {
                    ByteBuffer buf = (ByteBuffer)fragment;
                    inOrderFragmentStreams.add((InputStream)new ByteBufferInputStream(buf.duplicate()));
                    continue;
                }
                throw new IllegalArgumentException("unexpected fragment type: " + fragment.getClass().getName());
            }
        }
        catch (Exception e) {
            CombinedObjectStream.tryCloseAll(inOrderFragmentStreams);
            throw e;
        }
        log.trace("creating SequenceInputStream containing {} fragments", (Object)inOrderFragmentStreams.size());
        return new SequenceInputStream(Collections.enumeration(inOrderFragmentStreams));
    }

    @Override
    public int read() throws IOException {
        int byteRead = super.read();
        if (byteRead != -1) {
            ++this.position;
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = super.read(b);
        if (bytesRead != -1) {
            this.position += (long)bytesRead;
        }
        log.trace("read {} bytes in CombinedObjectStream for object {}", (Object)bytesRead, (Object)this.objectMetadata);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead != -1) {
            this.position += (long)bytesRead;
        }
        log.trace("read {} bytes in CombinedObjectStream for object {}", (Object)bytesRead, (Object)this.objectMetadata);
        return bytesRead;
    }

    public int readBytes(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len && (count = this.read(b, off + n, len - n)) >= 0; n += count) {
        }
        log.trace("read {} bytes in CombinedObjectStream for object {}", (Object)n, (Object)this.objectMetadata);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = super.skip(n);
        this.position += bytesSkipped;
        log.trace("skipped {} bytes in CombinedObjectStream for object {}", (Object)bytesSkipped, (Object)this.objectMetadata);
        return bytesSkipped;
    }

    public void skipTo(long n) throws IOException {
        while (n > 0L) {
            long ns = this.skip(n);
            if (ns > 0L && ns <= n) {
                n -= ns;
                continue;
            }
            if (ns == 0L) {
                if (this.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            throw new IOException("Unable to skip exactly " + n + " bytes");
        }
    }

    @Override
    public int available() throws IOException {
        return (int)(this.length - this.position);
    }

    @Override
    public void close() throws IOException {
        log.trace("closing CombinedObjectStream for object {}", (Object)this.objectMetadata);
        super.close();
    }

    @Override
    public void mark(int readlimit) {
        log.debug("marking CombinedObjectStream at position {} and ignoring provided readlimit of {} for object {}", new Object[]{this.position, readlimit, this.objectMetadata});
        this.markedPosition = this.position;
    }

    @Override
    public void reset() throws IOException {
        if (this.position == this.markedPosition) {
            log.trace("ignoring spurious reset request from {} to {} for object {}", new Object[]{this.position, this.markedPosition, this.objectMetadata});
            return;
        }
        log.info("resetting CombinedObjectStream from position {} to position {} in object {}", new Object[]{this.position, this.markedPosition, this.objectMetadata});
        try {
            this.in.close();
        }
        catch (IOException e) {
            log.error("failed to close internal stream during reset", (Throwable)e);
        }
        this.in = CombinedObjectStream.makeSequence(this.fragments, this.throttler);
        this.position = 0L;
        this.skipTo(this.markedPosition);
    }

    @Override
    public boolean markSupported() {
        log.trace("CombinedObjectStream is markSupported for object {}", (Object)this.objectMetadata);
        return true;
    }
}

