/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.storage.internals.checkpoint.CheckpointFileWithFailureHandler;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;

public class LeaderEpochCheckpointFile {
    public static final String LEADER_EPOCH_CHECKPOINT_FILENAME = "leader-epoch-checkpoint";
    public static final Formatter FORMATTER = new Formatter();
    private static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+");
    static final int CURRENT_VERSION = 0;
    private final CheckpointFileWithFailureHandler<EpochEntry> checkpoint;

    public LeaderEpochCheckpointFile(File file, CheckpointFileConfig checkpointFileConfig, LogDirFailureChannel logDirFailureChannel) throws IOException {
        this.checkpoint = new CheckpointFileWithFailureHandler<EpochEntry>(file, 0, checkpointFileConfig, FORMATTER, logDirFailureChannel, file.getParentFile().getParent());
    }

    public void updateChecksumProtection(boolean enable) {
        this.checkpoint.updateChecksumProtection(enable);
    }

    public void write(Collection<EpochEntry> epochs) {
        this.checkpoint.write(epochs);
    }

    public void writeIfDirExists(Collection<EpochEntry> epochs) {
        this.checkpoint.writeIfDirExists(epochs);
    }

    public byte[] toByteArray(List<EpochEntry> epochs) {
        return this.checkpoint.writeToByteArray(epochs);
    }

    public List<EpochEntry> read() {
        return this.checkpoint.read();
    }

    public static List<EpochEntry> read(String location, BufferedReader reader) throws IOException {
        CheckpointFile.CheckpointReadBuffer checkpoint = new CheckpointFile.CheckpointReadBuffer(location, reader, 0, (CheckpointFile.EntryFormatter)FORMATTER);
        return checkpoint.read();
    }

    public File file() {
        return this.checkpoint.file;
    }

    public static File newFile(File dir) {
        return new File(dir, LEADER_EPOCH_CHECKPOINT_FILENAME);
    }

    private static class Formatter
    implements CheckpointFile.EntryFormatter<EpochEntry> {
        private Formatter() {
        }

        public String toString(EpochEntry entry) {
            return entry.epoch + " " + entry.startOffset;
        }

        public Optional<EpochEntry> fromString(String line) {
            String[] strings = WHITE_SPACES_PATTERN.split(line);
            return strings.length == 2 ? Optional.of(new EpochEntry(Integer.parseInt(strings[0]), Long.parseLong(strings[1]))) : Optional.empty();
        }
    }
}

