/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.TransactionIndex;

public class CleanedTransactionMetadata {
    private final Set<Long> ongoingCommittedTxns = ConcurrentHashMap.newKeySet();
    private final Map<Long, AbortedTransactionMetadata> ongoingAbortedTxns = new ConcurrentHashMap<Long, AbortedTransactionMetadata>();
    private final PriorityQueue<AbortedTxn> abortedTransactions = new PriorityQueue<AbortedTxn>(Comparator.comparingLong(AbortedTxn::firstOffset));
    private Optional<TransactionIndex> cleanedIndex = Optional.empty();

    public Map<Long, AbortedTransactionMetadata> ongoingAbortedTxns() {
        return this.ongoingAbortedTxns;
    }

    public void setCleanedIndex(Optional<TransactionIndex> cleanedIndex) {
        this.cleanedIndex = cleanedIndex;
    }

    public void addAbortedTransactions(List<AbortedTxn> abortedTransactions) {
        this.abortedTransactions.addAll(abortedTransactions);
    }

    public boolean onControlBatchRead(RecordBatch controlBatch) {
        this.consumeAbortedTxnsUpTo(controlBatch.lastOffset());
        Iterator controlRecordIterator = controlBatch.iterator();
        if (controlRecordIterator.hasNext()) {
            Record controlRecord = (Record)controlRecordIterator.next();
            ControlRecordType controlType = ControlRecordType.parse((ByteBuffer)controlRecord.key());
            long producerId = controlBatch.producerId();
            switch (controlType) {
                case ABORT: {
                    AbortedTransactionMetadata abortedTxnMetadata = this.ongoingAbortedTxns.remove(producerId);
                    if (abortedTxnMetadata != null && abortedTxnMetadata.lastRetainedBatchOffset.isPresent()) {
                        this.cleanedIndex.ifPresent(index -> {
                            try {
                                index.append(abortedTxnMetadata.abortedTxn);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        return false;
                    }
                    return true;
                }
                case COMMIT: {
                    return !this.ongoingCommittedTxns.remove(producerId);
                }
            }
            return false;
        }
        return true;
    }

    private void consumeAbortedTxnsUpTo(long offset) {
        while (!this.abortedTransactions.isEmpty() && this.abortedTransactions.peek().firstOffset() <= offset) {
            AbortedTxn abortedTxn = this.abortedTransactions.poll();
            this.ongoingAbortedTxns.computeIfAbsent(abortedTxn.producerId(), id -> new AbortedTransactionMetadata(abortedTxn));
        }
    }

    public boolean onBatchRead(RecordBatch batch) {
        this.consumeAbortedTxnsUpTo(batch.lastOffset());
        if (batch.isTransactional()) {
            return this.ongoingAbortedTxns.containsKey(batch.producerId());
        }
        return false;
    }

    public void onBatchRetained(RecordBatch batch) {
        if (batch.isTransactional() && !batch.isControlBatch()) {
            long producerId = batch.producerId();
            AbortedTransactionMetadata abortedTransactionMetadata = this.ongoingAbortedTxns.get(producerId);
            if (abortedTransactionMetadata != null) {
                abortedTransactionMetadata.lastRetainedBatchOffset = Optional.of(batch.lastOffset());
            } else {
                this.ongoingCommittedTxns.add(producerId);
            }
        }
    }

    public static class AbortedTransactionMetadata {
        public Optional<Long> lastRetainedBatchOffset = Optional.empty();
        public final AbortedTxn abortedTxn;

        public AbortedTransactionMetadata(AbortedTxn abortedTxn) {
            this.abortedTxn = abortedTxn;
        }

        public String toString() {
            return "(txn: " + String.valueOf(this.abortedTxn) + ", lastRetainedBatchOffset: " + String.valueOf(this.lastRetainedBatchOffset) + ")";
        }
    }
}

