/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.storage.internals.log.LogConfig;

public class ConfluentLogConfig {
    public final long tierLocalHotsetBytes;
    public final long tierLocalHotsetMs;
    public final int tierSegmentHotsetRollMinBytes;
    public final long preferTierFetchMs;
    public final boolean segmentSpeculativePrefetchEnable;
    public final boolean tierCleanerEnable;
    public final int tierCleanerCompactSegmentMinBytes;
    public final boolean tierCleanerDualCompaction;
    public final Optional<TopicPlacement> topicPlacementConstraints;
    public final long minSegmentMs;
    public final long maxSegmentMs;
    public final long strayLogDeleteDelayMs;
    public final int strayLogMaxDeletionsPerRun;
    public final boolean systemTimeBasedRollEnable;
    public final boolean logCleanerTimestampValidationEnable;
    private final boolean tierEnable;
    private final double tierCleanerMinCleanableRatio;
    private final double tierCleanerCompactMinEfficiencyRatio;

    ConfluentLogConfig(LogConfig config, boolean compact) {
        Map values = config.values();
        this.tierEnable = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.tier.enable", false);
        this.tierLocalHotsetBytes = config.getLongValueOrDefaultWhenFreight(values, "confluent.tier.local.hotset.bytes", -1L);
        this.tierLocalHotsetMs = config.getLongValueOrDefaultWhenFreight(values, "confluent.tier.local.hotset.ms", 86400000L);
        this.tierSegmentHotsetRollMinBytes = config.getIntValueOrDefaultWhenFreight(values, "confluent.tier.segment.hotset.roll.min.bytes", 0x6400000);
        this.preferTierFetchMs = compact ? config.getLongValueOrDefaultWhenFreight(values, "confluent.compacted.topic.prefer.tier.fetch.ms", -1L) : config.getLongValueOrDefaultWhenFreight(values, "confluent.prefer.tier.fetch.ms", -1L);
        this.segmentSpeculativePrefetchEnable = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.segment.speculative.prefetch.enable", false);
        this.tierCleanerEnable = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.tier.cleaner.enable", false);
        this.tierCleanerMinCleanableRatio = config.getDoubleValueOrDefaultWhenFreight(values, "confluent.tier.cleaner.min.cleanable.ratio", 0.75);
        this.tierCleanerCompactMinEfficiencyRatio = config.getDoubleValueOrDefaultWhenFreight(values, "confluent.tier.cleaner.compact.min.efficiency", 0.5);
        this.tierCleanerCompactSegmentMinBytes = config.getIntValueOrDefaultWhenFreight(values, "confluent.tier.cleaner.compact.segment.min.bytes", 0x1400000);
        this.tierCleanerDualCompaction = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.tier.cleaner.dual.compaction", false);
        this.topicPlacementConstraints = TopicPlacement.parse((String)config.getStringValueOrDefaultWhenFreight(values, "confluent.placement.constraints", ""));
        this.strayLogDeleteDelayMs = config.getLongValueOrDefaultWhenFreight(values, "confluent.stray.log.delete.delay.ms", 604800000L);
        this.strayLogMaxDeletionsPerRun = config.getIntValueOrDefaultWhenFreight(values, "confluent.stray.log.max.deletions.per.run", 72);
        this.minSegmentMs = config.getLongValueOrDefaultWhenFreight(values, "confluent.min.segment.ms", 1L);
        this.maxSegmentMs = config.getLongValueOrDefaultWhenFreight(values, "confluent.max.segment.ms", Long.MAX_VALUE);
        this.systemTimeBasedRollEnable = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.system.time.roll.enable", false);
        this.logCleanerTimestampValidationEnable = config.getBooleanValueOrDefaultWhenFreight(values, "confluent.log.cleaner.timestamp.validation.enable", true);
    }

    public boolean tierEnable() {
        return this.tierEnable;
    }

    public double tierCleanerMinCleanableRatio() {
        return this.tierCleanerMinCleanableRatio;
    }

    public double tierCleanerCompactMinEfficiencyRatio() {
        return this.tierCleanerCompactMinEfficiencyRatio;
    }
}

