/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.storage.log.AbstractLog;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentReadAdapter;

public class LocalLogSegmentReadAdapter
implements LogSegmentReadAdapter {
    private final AbstractLog log;
    private final LogSegment segment;

    public LocalLogSegmentReadAdapter(AbstractLog log, LogSegment segment) {
        this.log = log;
        this.segment = segment;
    }

    @Override
    public long baseOffset() {
        return this.segment.baseOffset();
    }

    @Override
    public long endOffset() {
        try {
            return this.segment.readNextOffset() - 1L;
        }
        catch (IOException e) {
            throw new KafkaException("Failed to read next offset from segment " + String.valueOf(this.segment), (Throwable)e);
        }
    }

    @Override
    public int startPosition() {
        return 0;
    }

    @Override
    public int endPosition() {
        try {
            return (int)this.segment.log().channel().size();
        }
        catch (IOException e) {
            throw new KafkaException("Failed to get channel size from segment " + String.valueOf(this.segment), (Throwable)e);
        }
    }

    @Override
    public void readBytes(ByteBuffer buffer, int position) {
        if (position < this.startPosition() || position > this.endPosition()) {
            throw new IllegalArgumentException("Invalid position: " + position + ". Valid position range is [" + this.startPosition() + ", " + this.endPosition() + "]");
        }
        try {
            this.segment.log().readInto(buffer, position);
        }
        catch (IOException e) {
            throw new KafkaException("Failed to read from segment " + String.valueOf(this.segment) + " of partition " + String.valueOf(this.log.topicPartition()), (Throwable)e);
        }
    }

    public String toString() {
        return "LocalLogSegmentReadAdapter(log segment: " + String.valueOf(this.segment.log().file()) + ", startPosition: " + this.startPosition() + ", endPosition: " + this.endPosition() + ", baseOffset: " + this.baseOffset() + ", endOffset:" + this.endOffset() + ")";
    }
}

