/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.storage.log.AbstractLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogManager.class);
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String RECOVERY_POINT_CHECKPOINT_FILE = "recovery-point-offset-checkpoint";
    public static final String LOG_START_OFFSET_CHECKPOINT_FILE = "log-start-offset-checkpoint";

    public static boolean waitForAllToComplete(List<Future<?>> jobs, Consumer<Throwable> callback) {
        ArrayList failed = new ArrayList();
        for (Future<?> job : jobs) {
            try {
                job.get();
            }
            catch (Exception e) {
                callback.accept(e);
                failed.add(job);
            }
        }
        return failed.isEmpty();
    }

    public static void createProducerStateSensors(Metrics metrics) {
        Sensor expiredProducersRestoredSensor = metrics.sensor("ExpiredProducersRestored");
        expiredProducersRestoredSensor.add((CompoundStat)new Meter(metrics.metricName("expired-producers-restored-rate", "log-manager-metrics", "The number of non zero sequences (restoring an expired producer) per second found on new producer state."), metrics.metricName("expired-producers-restored-total", "log-manager-metrics", "The total number of non zero sequences (restoring an expired producer) found on new producer state")));
        Sensor duplicateSequenceTimeSensor = metrics.sensor("DuplicateSequenceTime");
        duplicateSequenceTimeSensor.add(metrics.metricName("duplicate-sequence-time-max", "log-manager-metrics", "The max time between duplicate batches"), (MeasurableStat)new Max());
        duplicateSequenceTimeSensor.add(metrics.metricName("duplicate-sequence-time-avg", "log-manager-metrics", "The avg time between duplicate batches"), (MeasurableStat)new Avg());
    }

    public static boolean isStrayKraftReplica(int brokerId, TopicsImage newTopicsImage, AbstractLog log) {
        int partitionId;
        if (log.topicId().isEmpty()) {
            LOG.info("The topicId does not exist in {}, treat it as a stray log.", (Object)log);
            return true;
        }
        Uuid topicId = log.topicId().get();
        PartitionRegistration partition = newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition());
        if (partition == null) {
            LOG.info("Found stray log dir {}: the topicId {} does not exist in the metadata image.", (Object)log, (Object)topicId);
            return true;
        }
        List<Integer> replicas = Arrays.stream(partition.replicas).boxed().toList();
        if (!replicas.contains(brokerId)) {
            LOG.info("Found stray log dir {}: the current replica assignment {} does not contain the local brokerId {}.", new Object[]{log, replicas.stream().map(String::valueOf).collect(Collectors.joining(", ", "[", "]")), brokerId});
            return true;
        }
        return false;
    }
}

