/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.provider.SpiffeIdVerifier;
import io.spiffe.provider.SpiffeVerificationException;
import io.spiffe.spiffeid.SpiffeId;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;

public class AllowedIdSupplierSpiffeIdVerifier
implements SpiffeIdVerifier {
    private final Supplier<Set<SpiffeId>> allowedSpiffeIdsSupplier;

    public AllowedIdSupplierSpiffeIdVerifier(@NonNull Supplier<Set<SpiffeId>> allowedSpiffeIdsSupplier) {
        if (allowedSpiffeIdsSupplier == null) {
            throw new NullPointerException("allowedSpiffeIdsSupplier is marked non-null but is null");
        }
        this.allowedSpiffeIdsSupplier = allowedSpiffeIdsSupplier;
    }

    @Override
    public void verify(SpiffeId spiffeId, X509Certificate[] verifiedChain) throws SpiffeVerificationException {
        Set<SpiffeId> allowedSpiffeIds = this.allowedSpiffeIdsSupplier.get();
        if (!allowedSpiffeIds.contains(spiffeId)) {
            throw new SpiffeVerificationException(String.format("SPIFFE ID %s in X.509 certificate is not accepted", spiffeId));
        }
    }
}

