/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import io.confluent.rest.RestConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.security.Constraint;

public final class AuthUtil {
    private AuthUtil() {
    }

    public static boolean isCorsEnabled(RestConfig restConfig) {
        String allowedOrigins = restConfig.getString("access.control.allow.origin");
        return !allowedOrigins.trim().isEmpty();
    }

    public static boolean isSkipOptionsAuth(RestConfig restConfig) {
        boolean skipOption = restConfig.getBoolean("access.control.skip.options");
        return skipOption;
    }

    public static boolean isRejectOptions(RestConfig restConfig) {
        boolean rejectOption = restConfig.getBoolean("reject.options.request");
        return rejectOption;
    }

    public static ConstraintMapping createGlobalAuthConstraint(RestConfig restConfig) {
        return AuthUtil.createConstraint(restConfig, true, "/*");
    }

    public static ConstraintMapping createSecuredConstraint(RestConfig restConfig, String pathSpec) {
        return AuthUtil.createConstraint(restConfig, true, pathSpec);
    }

    public static ConstraintMapping createUnsecuredConstraint(RestConfig restConfig, String pathSpec) {
        return AuthUtil.createConstraint(restConfig, false, pathSpec);
    }

    public static List<ConstraintMapping> createUnsecuredConstraints(RestConfig restConfig) {
        List unsecuredPaths = restConfig.getList("authentication.skip.paths");
        return unsecuredPaths.stream().map(p -> AuthUtil.createConstraint(restConfig, false, p)).collect(Collectors.toList());
    }

    private static ConstraintMapping createConstraint(RestConfig restConfig, boolean authenticate, String pathSpec) {
        Constraint.Builder constraint = new Constraint.Builder();
        if (authenticate) {
            AuthUtil.configureAuthentication(constraint, restConfig);
        }
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setMethod("*");
        mapping.setConstraint(constraint.build());
        if (AuthUtil.isRejectOptions(restConfig)) {
            mapping.setMethodOmissions(new String[]{"OPTIONS"});
        }
        if (authenticate && AuthUtil.isCorsEnabled(restConfig) && AuthUtil.isSkipOptionsAuth(restConfig)) {
            mapping.setMethodOmissions(new String[]{"OPTIONS"});
        }
        mapping.setPathSpec(pathSpec);
        return mapping;
    }

    private static void configureAuthentication(Constraint.Builder constraint, RestConfig restConfig) {
        List roles = restConfig.getList("authentication.roles");
        if (roles.isEmpty()) {
            constraint.authorization(Constraint.FORBIDDEN.getAuthorization());
        } else if (roles.size() == 1 && ((String)roles.get(0)).equals("*")) {
            constraint.authorization(Constraint.KNOWN_ROLE.getAuthorization());
        } else if (roles.size() == 1 && ((String)roles.get(0)).equals("**")) {
            constraint.authorization(Constraint.ANY_USER.getAuthorization());
        } else {
            constraint.roles(roles.toArray(new String[0]));
        }
    }

    public static Optional<ConstraintMapping> createDisableOptionsConstraint(RestConfig config) {
        if (AuthUtil.isRejectOptions(config)) {
            Constraint.Builder forbidConstraint = new Constraint.Builder();
            forbidConstraint.name("Disable OPTIONS");
            forbidConstraint.authorization(Constraint.FORBIDDEN.getAuthorization());
            ConstraintMapping forbidMapping = new ConstraintMapping();
            forbidMapping.setMethod("OPTIONS");
            forbidMapping.setPathSpec("/*");
            forbidMapping.setConstraint(forbidConstraint.build());
            return Optional.of(forbidMapping);
        }
        return Optional.empty();
    }
}

