/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import io.confluent.rest.handlers.SniUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixSniHandler
extends Handler.Wrapper {
    private static final Logger log = LoggerFactory.getLogger(PrefixSniHandler.class);
    private static final String DOT_SEPARATOR = ".";
    private static final String DASH_SEPARATOR = "-";
    private final String sniPrefix;

    public PrefixSniHandler(String prefix) {
        this.sniPrefix = prefix;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String hostHeader = Request.getServerName((Request)request);
        String sniServerName = SniUtils.getSniServerName(request);
        log.debug("host header: {}, full sni: {}", (Object)hostHeader, (Object)sniServerName);
        if (sniServerName != null && sniServerName.startsWith(this.sniPrefix)) {
            String prefix = PrefixSniHandler.getFirstPart(sniServerName);
            if (prefix == null || !hostHeader.startsWith(prefix + DOT_SEPARATOR) && !hostHeader.startsWith(prefix + DASH_SEPARATOR)) {
                log.warn("SNI prefix check failed, host header: {}, sni tenantId: {}, full sni: {}", new Object[]{hostHeader, prefix, sniServerName});
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), (String)HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
            }
        } else if (sniServerName != null && !sniServerName.equals(hostHeader)) {
            log.warn("SNI check failed, host header: {}, full sni: {}", (Object)hostHeader, (Object)sniServerName);
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), (String)HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
        }
        return super.handle(request, response, callback);
    }

    private static String getFirstPart(String hostname) {
        if (hostname == null) {
            return null;
        }
        int dotIndex = hostname.indexOf(DOT_SEPARATOR);
        return dotIndex == -1 ? null : hostname.substring(0, dotIndex);
    }
}

