/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.HashSet;
import java.util.Set;

public class ConstraintViolations {
    private ConstraintViolations() {
    }

    public static <T> String format(ConstraintViolation<T> v) {
        return String.format("%s %s (was %s)", v.getPropertyPath(), v.getMessage(), v.getInvalidValue());
    }

    public static String formatUntyped(Set<ConstraintViolation<?>> violations) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (ConstraintViolation<?> v : violations) {
            if (!first) {
                builder.append("; ");
            }
            builder.append(ConstraintViolations.format(v));
            first = false;
        }
        return builder.toString();
    }

    public static ConstraintViolationException simpleException(String msg) {
        return new ConstraintViolationException(msg, new HashSet());
    }
}

