/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.help.common.AbstractCommandGroupUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;

public abstract class AbstractPrintedCommandGroupUsageGenerator<T>
extends AbstractCommandGroupUsageGenerator<T> {
    private final int columnSize;

    public AbstractPrintedCommandGroupUsageGenerator(int columnSize, Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, boolean includeHidden) {
        super(hintComparator, optionComparator, commandComparator, includeHidden);
        if (columnSize <= 0) {
            throw new IllegalArgumentException("columnSize must be greater than 0");
        }
        this.columnSize = columnSize;
    }

    protected abstract void usage(GlobalMetadata<T> var1, CommandGroupMetadata[] var2, UsagePrinter var3) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
        return new UsagePrinter(new PrintWriter(out), this.columnSize);
    }

    @Override
    public void usage(GlobalMetadata<T> global, CommandGroupMetadata[] groups, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        this.usage(global, groups, printer);
        printer.flush();
    }
}

