/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.K2V1BrokerPool;
import io.confluent.flink.apiserver.client.model.K2V1BrokerPoolGroup;
import io.confluent.flink.apiserver.client.model.K2V1BrokerPoolGroupList;
import io.confluent.flink.apiserver.client.model.K2V1BrokerPoolList;
import io.confluent.flink.apiserver.client.model.K2V1ConfluxDeployment;
import io.confluent.flink.apiserver.client.model.K2V1ConfluxDeploymentList;
import io.confluent.flink.apiserver.client.model.K2V1K2HealthCheck;
import io.confluent.flink.apiserver.client.model.K2V1K2HealthCheckGroup;
import io.confluent.flink.apiserver.client.model.K2V1K2HealthCheckGroupList;
import io.confluent.flink.apiserver.client.model.K2V1K2HealthCheckList;
import io.confluent.flink.apiserver.client.model.K2V1PartitionService;
import io.confluent.flink.apiserver.client.model.K2V1PartitionServiceList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class K2V1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public K2V1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public K2V1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createK2V1BrokerPoolCall(String environment, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1BrokerPoolValidateBeforeCall(String environment, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1BrokerPool(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling createK2V1BrokerPool(Async)");
        }
        return this.createK2V1BrokerPoolCall(environment, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool createK2V1BrokerPool(String environment, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.createK2V1BrokerPoolWithHttpInfo(environment, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> createK2V1BrokerPoolWithHttpInfo(String environment, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.createK2V1BrokerPoolValidateBeforeCall(environment, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1BrokerPoolAsync(String environment, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.createK2V1BrokerPoolValidateBeforeCall(environment, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createK2V1BrokerPoolGroupCall(String environment, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1BrokerPoolGroupValidateBeforeCall(String environment, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1BrokerPoolGroup(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling createK2V1BrokerPoolGroup(Async)");
        }
        return this.createK2V1BrokerPoolGroupCall(environment, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup createK2V1BrokerPoolGroup(String environment, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.createK2V1BrokerPoolGroupWithHttpInfo(environment, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> createK2V1BrokerPoolGroupWithHttpInfo(String environment, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.createK2V1BrokerPoolGroupValidateBeforeCall(environment, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1BrokerPoolGroupAsync(String environment, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.createK2V1BrokerPoolGroupValidateBeforeCall(environment, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createK2V1ConfluxDeploymentCall(String environment, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1ConfluxDeploymentValidateBeforeCall(String environment, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1ConfluxDeployment(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling createK2V1ConfluxDeployment(Async)");
        }
        return this.createK2V1ConfluxDeploymentCall(environment, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment createK2V1ConfluxDeployment(String environment, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.createK2V1ConfluxDeploymentWithHttpInfo(environment, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> createK2V1ConfluxDeploymentWithHttpInfo(String environment, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.createK2V1ConfluxDeploymentValidateBeforeCall(environment, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1ConfluxDeploymentAsync(String environment, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.createK2V1ConfluxDeploymentValidateBeforeCall(environment, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createK2V1K2HealthCheckCall(String environment, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1K2HealthCheckValidateBeforeCall(String environment, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1K2HealthCheck(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling createK2V1K2HealthCheck(Async)");
        }
        return this.createK2V1K2HealthCheckCall(environment, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck createK2V1K2HealthCheck(String environment, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.createK2V1K2HealthCheckWithHttpInfo(environment, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> createK2V1K2HealthCheckWithHttpInfo(String environment, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.createK2V1K2HealthCheckValidateBeforeCall(environment, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1K2HealthCheckAsync(String environment, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.createK2V1K2HealthCheckValidateBeforeCall(environment, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createK2V1K2HealthCheckGroupCall(String environment, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1K2HealthCheckGroupValidateBeforeCall(String environment, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1K2HealthCheckGroup(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling createK2V1K2HealthCheckGroup(Async)");
        }
        return this.createK2V1K2HealthCheckGroupCall(environment, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup createK2V1K2HealthCheckGroup(String environment, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.createK2V1K2HealthCheckGroupWithHttpInfo(environment, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> createK2V1K2HealthCheckGroupWithHttpInfo(String environment, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.createK2V1K2HealthCheckGroupValidateBeforeCall(environment, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1K2HealthCheckGroupAsync(String environment, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.createK2V1K2HealthCheckGroupValidateBeforeCall(environment, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createK2V1PartitionServiceCall(String environment, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createK2V1PartitionServiceValidateBeforeCall(String environment, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createK2V1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createK2V1PartitionService(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling createK2V1PartitionService(Async)");
        }
        return this.createK2V1PartitionServiceCall(environment, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService createK2V1PartitionService(String environment, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.createK2V1PartitionServiceWithHttpInfo(environment, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> createK2V1PartitionServiceWithHttpInfo(String environment, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.createK2V1PartitionServiceValidateBeforeCall(environment, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createK2V1PartitionServiceAsync(String environment, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.createK2V1PartitionServiceValidateBeforeCall(environment, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1BrokerPoolCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1BrokerPoolValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1BrokerPool(Async)");
        }
        return this.deleteK2V1BrokerPoolCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1BrokerPool deleteK2V1BrokerPool(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.deleteK2V1BrokerPoolWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> deleteK2V1BrokerPoolWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1BrokerPoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1BrokerPoolAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1BrokerPoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1BrokerPoolGroupCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1BrokerPoolGroup(Async)");
        }
        return this.deleteK2V1BrokerPoolGroupCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1BrokerPoolGroup deleteK2V1BrokerPoolGroup(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.deleteK2V1BrokerPoolGroupWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> deleteK2V1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1BrokerPoolGroupAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1ConfluxDeploymentCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1ConfluxDeployment(Async)");
        }
        return this.deleteK2V1ConfluxDeploymentCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1ConfluxDeployment deleteK2V1ConfluxDeployment(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.deleteK2V1ConfluxDeploymentWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> deleteK2V1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1ConfluxDeploymentAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1K2HealthCheckCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1K2HealthCheckValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1K2HealthCheck(Async)");
        }
        return this.deleteK2V1K2HealthCheckCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1K2HealthCheck deleteK2V1K2HealthCheck(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.deleteK2V1K2HealthCheckWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> deleteK2V1K2HealthCheckWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1K2HealthCheckValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1K2HealthCheckAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1K2HealthCheckValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1K2HealthCheckGroupCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1K2HealthCheckGroup(Async)");
        }
        return this.deleteK2V1K2HealthCheckGroupCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1K2HealthCheckGroup deleteK2V1K2HealthCheckGroup(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.deleteK2V1K2HealthCheckGroupWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> deleteK2V1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1K2HealthCheckGroupAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteK2V1PartitionServiceCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteK2V1PartitionServiceValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteK2V1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteK2V1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteK2V1PartitionService(Async)");
        }
        return this.deleteK2V1PartitionServiceCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public K2V1PartitionService deleteK2V1PartitionService(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.deleteK2V1PartitionServiceWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> deleteK2V1PartitionServiceWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteK2V1PartitionServiceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteK2V1PartitionServiceAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.deleteK2V1PartitionServiceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1BrokerPoolGroupsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1BrokerPoolGroupsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1BrokerPoolGroups(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1BrokerPoolGroups(Async)");
        }
        return this.listK2V1BrokerPoolGroupsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1BrokerPoolGroupList listK2V1BrokerPoolGroups(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroupList> localVarResp = this.listK2V1BrokerPoolGroupsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroupList> listK2V1BrokerPoolGroupsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1BrokerPoolGroupsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1BrokerPoolGroupList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1BrokerPoolGroupsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/brokerpoolgroups".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1BrokerPoolGroupsForAllEnvironments(Async)");
        }
        return this.listK2V1BrokerPoolGroupsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1BrokerPoolGroupList listK2V1BrokerPoolGroupsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroupList> localVarResp = this.listK2V1BrokerPoolGroupsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroupList> listK2V1BrokerPoolGroupsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1BrokerPoolGroupsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1BrokerPoolGroupList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1BrokerPoolsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1BrokerPoolsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1BrokerPools(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1BrokerPools(Async)");
        }
        return this.listK2V1BrokerPoolsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1BrokerPoolList listK2V1BrokerPools(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1BrokerPoolList> localVarResp = this.listK2V1BrokerPoolsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolList> listK2V1BrokerPoolsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1BrokerPoolsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1BrokerPoolList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1BrokerPoolsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/brokerpools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1BrokerPoolsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1BrokerPoolsForAllEnvironments(Async)");
        }
        return this.listK2V1BrokerPoolsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1BrokerPoolList listK2V1BrokerPoolsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1BrokerPoolList> localVarResp = this.listK2V1BrokerPoolsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolList> listK2V1BrokerPoolsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1BrokerPoolsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1BrokerPoolList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1BrokerPoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1ConfluxDeploymentsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1ConfluxDeploymentsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1ConfluxDeployments(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1ConfluxDeployments(Async)");
        }
        return this.listK2V1ConfluxDeploymentsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1ConfluxDeploymentList listK2V1ConfluxDeployments(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1ConfluxDeploymentList> localVarResp = this.listK2V1ConfluxDeploymentsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeploymentList> listK2V1ConfluxDeploymentsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1ConfluxDeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1ConfluxDeploymentsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1ConfluxDeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1ConfluxDeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1ConfluxDeploymentsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/confluxdeployments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1ConfluxDeploymentsForAllEnvironments(Async)");
        }
        return this.listK2V1ConfluxDeploymentsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1ConfluxDeploymentList listK2V1ConfluxDeploymentsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1ConfluxDeploymentList> localVarResp = this.listK2V1ConfluxDeploymentsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeploymentList> listK2V1ConfluxDeploymentsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1ConfluxDeploymentsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1ConfluxDeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1K2HealthCheckGroupsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1K2HealthCheckGroupsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1K2HealthCheckGroups(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1K2HealthCheckGroups(Async)");
        }
        return this.listK2V1K2HealthCheckGroupsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1K2HealthCheckGroupList listK2V1K2HealthCheckGroups(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroupList> localVarResp = this.listK2V1K2HealthCheckGroupsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroupList> listK2V1K2HealthCheckGroupsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthCheckGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1K2HealthCheckGroupsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1K2HealthCheckGroupList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthCheckGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1K2HealthCheckGroupsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/k2healthcheckgroups".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1K2HealthCheckGroupsForAllEnvironments(Async)");
        }
        return this.listK2V1K2HealthCheckGroupsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1K2HealthCheckGroupList listK2V1K2HealthCheckGroupsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroupList> localVarResp = this.listK2V1K2HealthCheckGroupsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroupList> listK2V1K2HealthCheckGroupsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1K2HealthCheckGroupsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1K2HealthCheckGroupList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1K2HealthChecksCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1K2HealthChecksValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1K2HealthChecks(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1K2HealthChecks(Async)");
        }
        return this.listK2V1K2HealthChecksCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1K2HealthCheckList listK2V1K2HealthChecks(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1K2HealthCheckList> localVarResp = this.listK2V1K2HealthChecksWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckList> listK2V1K2HealthChecksWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthChecksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1K2HealthChecksAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1K2HealthCheckList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthChecksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1K2HealthChecksForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/k2healthchecks".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1K2HealthChecksForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1K2HealthChecksForAllEnvironments(Async)");
        }
        return this.listK2V1K2HealthChecksForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1K2HealthCheckList listK2V1K2HealthChecksForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1K2HealthCheckList> localVarResp = this.listK2V1K2HealthChecksForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckList> listK2V1K2HealthChecksForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthChecksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1K2HealthChecksForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1K2HealthCheckList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1K2HealthChecksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1PartitionServicesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1PartitionServicesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listK2V1PartitionServices(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1PartitionServices(Async)");
        }
        return this.listK2V1PartitionServicesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1PartitionServiceList listK2V1PartitionServices(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1PartitionServiceList> localVarResp = this.listK2V1PartitionServicesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionServiceList> listK2V1PartitionServicesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1PartitionServicesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionServiceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1PartitionServicesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1PartitionServiceList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1PartitionServicesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionServiceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listK2V1PartitionServicesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/partitionservices".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listK2V1PartitionServicesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listK2V1PartitionServicesForAllEnvironments(Async)");
        }
        return this.listK2V1PartitionServicesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public K2V1PartitionServiceList listK2V1PartitionServicesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<K2V1PartitionServiceList> localVarResp = this.listK2V1PartitionServicesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionServiceList> listK2V1PartitionServicesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listK2V1PartitionServicesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionServiceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listK2V1PartitionServicesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<K2V1PartitionServiceList> _callback) throws ApiException {
        Call localVarCall = this.listK2V1PartitionServicesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionServiceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPool(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling patchK2V1BrokerPool(Async)");
        }
        return this.patchK2V1BrokerPoolCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool patchK2V1BrokerPool(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.patchK2V1BrokerPoolWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> patchK2V1BrokerPoolWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolFinalizersCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPoolFinalizers(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling patchK2V1BrokerPoolFinalizers(Async)");
        }
        return this.patchK2V1BrokerPoolFinalizersCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool patchK2V1BrokerPoolFinalizers(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.patchK2V1BrokerPoolFinalizersWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> patchK2V1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolFinalizersAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolGroupCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPoolGroup(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling patchK2V1BrokerPoolGroup(Async)");
        }
        return this.patchK2V1BrokerPoolGroupCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup patchK2V1BrokerPoolGroup(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.patchK2V1BrokerPoolGroupWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> patchK2V1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolGroupAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolGroupFinalizersCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling patchK2V1BrokerPoolGroupFinalizers(Async)");
        }
        return this.patchK2V1BrokerPoolGroupFinalizersCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup patchK2V1BrokerPoolGroupFinalizers(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.patchK2V1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> patchK2V1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolGroupStatusCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPoolGroupStatus(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling patchK2V1BrokerPoolGroupStatus(Async)");
        }
        return this.patchK2V1BrokerPoolGroupStatusCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup patchK2V1BrokerPoolGroupStatus(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.patchK2V1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> patchK2V1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolGroupStatusAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1BrokerPoolStatusCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1BrokerPoolStatus(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling patchK2V1BrokerPoolStatus(Async)");
        }
        return this.patchK2V1BrokerPoolStatusCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool patchK2V1BrokerPoolStatus(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.patchK2V1BrokerPoolStatusWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> patchK2V1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1BrokerPoolStatusAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1ConfluxDeploymentCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1ConfluxDeployment(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling patchK2V1ConfluxDeployment(Async)");
        }
        return this.patchK2V1ConfluxDeploymentCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment patchK2V1ConfluxDeployment(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.patchK2V1ConfluxDeploymentWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> patchK2V1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1ConfluxDeploymentAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1ConfluxDeploymentFinalizersCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling patchK2V1ConfluxDeploymentFinalizers(Async)");
        }
        return this.patchK2V1ConfluxDeploymentFinalizersCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment patchK2V1ConfluxDeploymentFinalizers(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.patchK2V1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> patchK2V1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1ConfluxDeploymentStatusCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1ConfluxDeploymentStatus(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling patchK2V1ConfluxDeploymentStatus(Async)");
        }
        return this.patchK2V1ConfluxDeploymentStatusCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment patchK2V1ConfluxDeploymentStatus(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.patchK2V1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> patchK2V1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1ConfluxDeploymentStatusAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheck(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling patchK2V1K2HealthCheck(Async)");
        }
        return this.patchK2V1K2HealthCheckCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck patchK2V1K2HealthCheck(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.patchK2V1K2HealthCheckWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> patchK2V1K2HealthCheckWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckFinalizersCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheckFinalizers(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling patchK2V1K2HealthCheckFinalizers(Async)");
        }
        return this.patchK2V1K2HealthCheckFinalizersCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck patchK2V1K2HealthCheckFinalizers(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.patchK2V1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> patchK2V1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckFinalizersAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckGroupCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheckGroup(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling patchK2V1K2HealthCheckGroup(Async)");
        }
        return this.patchK2V1K2HealthCheckGroupCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup patchK2V1K2HealthCheckGroup(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.patchK2V1K2HealthCheckGroupWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> patchK2V1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckGroupAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling patchK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.patchK2V1K2HealthCheckGroupFinalizersCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup patchK2V1K2HealthCheckGroupFinalizers(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.patchK2V1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> patchK2V1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckGroupStatusCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling patchK2V1K2HealthCheckGroupStatus(Async)");
        }
        return this.patchK2V1K2HealthCheckGroupStatusCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup patchK2V1K2HealthCheckGroupStatus(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.patchK2V1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> patchK2V1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckGroupStatusAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1K2HealthCheckStatusCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1K2HealthCheckStatus(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling patchK2V1K2HealthCheckStatus(Async)");
        }
        return this.patchK2V1K2HealthCheckStatusCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck patchK2V1K2HealthCheckStatus(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.patchK2V1K2HealthCheckStatusWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> patchK2V1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1K2HealthCheckStatusAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1PartitionServiceCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1PartitionServiceValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1PartitionService(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling patchK2V1PartitionService(Async)");
        }
        return this.patchK2V1PartitionServiceCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService patchK2V1PartitionService(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.patchK2V1PartitionServiceWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> patchK2V1PartitionServiceWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1PartitionServiceAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1PartitionServiceFinalizersCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1PartitionServiceFinalizers(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling patchK2V1PartitionServiceFinalizers(Async)");
        }
        return this.patchK2V1PartitionServiceFinalizersCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService patchK2V1PartitionServiceFinalizers(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.patchK2V1PartitionServiceFinalizersWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> patchK2V1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1PartitionServiceFinalizersAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchK2V1PartitionServiceStatusCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchK2V1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchK2V1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchK2V1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchK2V1PartitionServiceStatus(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling patchK2V1PartitionServiceStatus(Async)");
        }
        return this.patchK2V1PartitionServiceStatusCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService patchK2V1PartitionServiceStatus(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.patchK2V1PartitionServiceStatusWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> patchK2V1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchK2V1PartitionServiceStatusAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPool(Async)");
        }
        return this.readK2V1BrokerPoolCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPool readK2V1BrokerPool(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.readK2V1BrokerPoolWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> readK2V1BrokerPoolWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPoolFinalizers(Async)");
        }
        return this.readK2V1BrokerPoolFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPool readK2V1BrokerPoolFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.readK2V1BrokerPoolFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> readK2V1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolGroupCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPoolGroup(Async)");
        }
        return this.readK2V1BrokerPoolGroupCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPoolGroup readK2V1BrokerPoolGroup(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.readK2V1BrokerPoolGroupWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> readK2V1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolGroupAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolGroupFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPoolGroupFinalizers(Async)");
        }
        return this.readK2V1BrokerPoolGroupFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPoolGroup readK2V1BrokerPoolGroupFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.readK2V1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> readK2V1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolGroupStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPoolGroupStatus(Async)");
        }
        return this.readK2V1BrokerPoolGroupStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPoolGroup readK2V1BrokerPoolGroupStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.readK2V1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> readK2V1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolGroupStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1BrokerPoolStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1BrokerPoolStatus(Async)");
        }
        return this.readK2V1BrokerPoolStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1BrokerPool readK2V1BrokerPoolStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.readK2V1BrokerPoolStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> readK2V1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1BrokerPoolStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1ConfluxDeploymentCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1ConfluxDeployment(Async)");
        }
        return this.readK2V1ConfluxDeploymentCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1ConfluxDeployment readK2V1ConfluxDeployment(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.readK2V1ConfluxDeploymentWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> readK2V1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1ConfluxDeploymentAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1ConfluxDeploymentFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1ConfluxDeploymentFinalizers(Async)");
        }
        return this.readK2V1ConfluxDeploymentFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1ConfluxDeployment readK2V1ConfluxDeploymentFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.readK2V1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> readK2V1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1ConfluxDeploymentStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1ConfluxDeploymentStatus(Async)");
        }
        return this.readK2V1ConfluxDeploymentStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1ConfluxDeployment readK2V1ConfluxDeploymentStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.readK2V1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> readK2V1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1ConfluxDeploymentStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheck(Async)");
        }
        return this.readK2V1K2HealthCheckCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheck readK2V1K2HealthCheck(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.readK2V1K2HealthCheckWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> readK2V1K2HealthCheckWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheckFinalizers(Async)");
        }
        return this.readK2V1K2HealthCheckFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheck readK2V1K2HealthCheckFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.readK2V1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> readK2V1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckGroupCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheckGroup(Async)");
        }
        return this.readK2V1K2HealthCheckGroupCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheckGroup readK2V1K2HealthCheckGroup(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.readK2V1K2HealthCheckGroupWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> readK2V1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckGroupAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.readK2V1K2HealthCheckGroupFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheckGroup readK2V1K2HealthCheckGroupFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.readK2V1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> readK2V1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckGroupStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheckGroupStatus(Async)");
        }
        return this.readK2V1K2HealthCheckGroupStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheckGroup readK2V1K2HealthCheckGroupStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.readK2V1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> readK2V1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckGroupStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1K2HealthCheckStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1K2HealthCheckStatus(Async)");
        }
        return this.readK2V1K2HealthCheckStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1K2HealthCheck readK2V1K2HealthCheckStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.readK2V1K2HealthCheckStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> readK2V1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1K2HealthCheckStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1PartitionServiceCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1PartitionServiceValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1PartitionService(Async)");
        }
        return this.readK2V1PartitionServiceCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1PartitionService readK2V1PartitionService(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.readK2V1PartitionServiceWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> readK2V1PartitionServiceWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1PartitionServiceAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1PartitionServiceFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1PartitionServiceFinalizers(Async)");
        }
        return this.readK2V1PartitionServiceFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1PartitionService readK2V1PartitionServiceFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.readK2V1PartitionServiceFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> readK2V1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1PartitionServiceFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readK2V1PartitionServiceStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readK2V1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readK2V1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readK2V1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readK2V1PartitionServiceStatus(Async)");
        }
        return this.readK2V1PartitionServiceStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public K2V1PartitionService readK2V1PartitionServiceStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.readK2V1PartitionServiceStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> readK2V1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readK2V1PartitionServiceStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPool(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling updateK2V1BrokerPool(Async)");
        }
        return this.updateK2V1BrokerPoolCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool updateK2V1BrokerPool(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.updateK2V1BrokerPoolWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> updateK2V1BrokerPoolWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolFinalizersCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPoolFinalizers(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling updateK2V1BrokerPoolFinalizers(Async)");
        }
        return this.updateK2V1BrokerPoolFinalizersCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool updateK2V1BrokerPoolFinalizers(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.updateK2V1BrokerPoolFinalizersWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> updateK2V1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolFinalizersAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolGroupCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPoolGroup(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling updateK2V1BrokerPoolGroup(Async)");
        }
        return this.updateK2V1BrokerPoolGroupCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup updateK2V1BrokerPoolGroup(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.updateK2V1BrokerPoolGroupWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> updateK2V1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolGroupAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolGroupFinalizersCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPoolGroupFinalizers(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling updateK2V1BrokerPoolGroupFinalizers(Async)");
        }
        return this.updateK2V1BrokerPoolGroupFinalizersCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup updateK2V1BrokerPoolGroupFinalizers(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.updateK2V1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> updateK2V1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolGroupStatusCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPoolGroup localVarPostBody = k2V1BrokerPoolGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPoolGroupStatus(Async)");
        }
        if (k2V1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPoolGroup' when calling updateK2V1BrokerPoolGroupStatus(Async)");
        }
        return this.updateK2V1BrokerPoolGroupStatusCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
    }

    public K2V1BrokerPoolGroup updateK2V1BrokerPoolGroupStatus(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        ApiResponse<K2V1BrokerPoolGroup> localVarResp = this.updateK2V1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, k2V1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPoolGroup> updateK2V1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolGroupStatusAsync(String environment, String name, String org, K2V1BrokerPoolGroup k2V1BrokerPoolGroup, ApiCallback<K2V1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, k2V1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1BrokerPoolStatusCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1BrokerPool localVarPostBody = k2V1BrokerPool;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1BrokerPoolStatus(Async)");
        }
        if (k2V1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'k2V1BrokerPool' when calling updateK2V1BrokerPoolStatus(Async)");
        }
        return this.updateK2V1BrokerPoolStatusCall(environment, name, org, k2V1BrokerPool, _callback);
    }

    public K2V1BrokerPool updateK2V1BrokerPoolStatus(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        ApiResponse<K2V1BrokerPool> localVarResp = this.updateK2V1BrokerPoolStatusWithHttpInfo(environment, name, org, k2V1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1BrokerPool> updateK2V1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, k2V1BrokerPool, null);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1BrokerPoolStatusAsync(String environment, String name, String org, K2V1BrokerPool k2V1BrokerPool, ApiCallback<K2V1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1BrokerPoolStatusValidateBeforeCall(environment, name, org, k2V1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<K2V1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1ConfluxDeploymentCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1ConfluxDeployment(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling updateK2V1ConfluxDeployment(Async)");
        }
        return this.updateK2V1ConfluxDeploymentCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment updateK2V1ConfluxDeployment(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.updateK2V1ConfluxDeploymentWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> updateK2V1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1ConfluxDeploymentAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1ConfluxDeploymentFinalizersCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1ConfluxDeploymentFinalizers(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling updateK2V1ConfluxDeploymentFinalizers(Async)");
        }
        return this.updateK2V1ConfluxDeploymentFinalizersCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment updateK2V1ConfluxDeploymentFinalizers(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.updateK2V1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> updateK2V1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1ConfluxDeploymentStatusCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1ConfluxDeployment localVarPostBody = k2V1ConfluxDeployment;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1ConfluxDeploymentStatus(Async)");
        }
        if (k2V1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'k2V1ConfluxDeployment' when calling updateK2V1ConfluxDeploymentStatus(Async)");
        }
        return this.updateK2V1ConfluxDeploymentStatusCall(environment, name, org, k2V1ConfluxDeployment, _callback);
    }

    public K2V1ConfluxDeployment updateK2V1ConfluxDeploymentStatus(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        ApiResponse<K2V1ConfluxDeployment> localVarResp = this.updateK2V1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, k2V1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1ConfluxDeployment> updateK2V1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1ConfluxDeploymentStatusAsync(String environment, String name, String org, K2V1ConfluxDeployment k2V1ConfluxDeployment, ApiCallback<K2V1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, k2V1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<K2V1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheck(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling updateK2V1K2HealthCheck(Async)");
        }
        return this.updateK2V1K2HealthCheckCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck updateK2V1K2HealthCheck(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.updateK2V1K2HealthCheckWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> updateK2V1K2HealthCheckWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckFinalizersCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheckFinalizers(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling updateK2V1K2HealthCheckFinalizers(Async)");
        }
        return this.updateK2V1K2HealthCheckFinalizersCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck updateK2V1K2HealthCheckFinalizers(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.updateK2V1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> updateK2V1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckFinalizersAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckGroupCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheckGroup(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling updateK2V1K2HealthCheckGroup(Async)");
        }
        return this.updateK2V1K2HealthCheckGroupCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup updateK2V1K2HealthCheckGroup(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.updateK2V1K2HealthCheckGroupWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> updateK2V1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckGroupAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling updateK2V1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.updateK2V1K2HealthCheckGroupFinalizersCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup updateK2V1K2HealthCheckGroupFinalizers(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.updateK2V1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> updateK2V1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckGroupStatusCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheckGroup localVarPostBody = k2V1K2HealthCheckGroup;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheckGroupStatus(Async)");
        }
        if (k2V1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheckGroup' when calling updateK2V1K2HealthCheckGroupStatus(Async)");
        }
        return this.updateK2V1K2HealthCheckGroupStatusCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
    }

    public K2V1K2HealthCheckGroup updateK2V1K2HealthCheckGroupStatus(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        ApiResponse<K2V1K2HealthCheckGroup> localVarResp = this.updateK2V1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, k2V1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheckGroup> updateK2V1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckGroupStatusAsync(String environment, String name, String org, K2V1K2HealthCheckGroup k2V1K2HealthCheckGroup, ApiCallback<K2V1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1K2HealthCheckStatusCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1K2HealthCheck localVarPostBody = k2V1K2HealthCheck;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1K2HealthCheckStatus(Async)");
        }
        if (k2V1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'k2V1K2HealthCheck' when calling updateK2V1K2HealthCheckStatus(Async)");
        }
        return this.updateK2V1K2HealthCheckStatusCall(environment, name, org, k2V1K2HealthCheck, _callback);
    }

    public K2V1K2HealthCheck updateK2V1K2HealthCheckStatus(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        ApiResponse<K2V1K2HealthCheck> localVarResp = this.updateK2V1K2HealthCheckStatusWithHttpInfo(environment, name, org, k2V1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1K2HealthCheck> updateK2V1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1K2HealthCheckStatusAsync(String environment, String name, String org, K2V1K2HealthCheck k2V1K2HealthCheck, ApiCallback<K2V1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1K2HealthCheckStatusValidateBeforeCall(environment, name, org, k2V1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<K2V1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1PartitionServiceCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1PartitionServiceValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1PartitionService(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling updateK2V1PartitionService(Async)");
        }
        return this.updateK2V1PartitionServiceCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService updateK2V1PartitionService(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.updateK2V1PartitionServiceWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> updateK2V1PartitionServiceWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1PartitionServiceAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1PartitionServiceFinalizersCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1PartitionServiceFinalizers(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling updateK2V1PartitionServiceFinalizers(Async)");
        }
        return this.updateK2V1PartitionServiceFinalizersCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService updateK2V1PartitionServiceFinalizers(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.updateK2V1PartitionServiceFinalizersWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> updateK2V1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1PartitionServiceFinalizersAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateK2V1PartitionServiceStatusCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        K2V1PartitionService localVarPostBody = k2V1PartitionService;
        String localVarPath = "/apis/k2/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateK2V1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateK2V1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateK2V1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateK2V1PartitionServiceStatus(Async)");
        }
        if (k2V1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'k2V1PartitionService' when calling updateK2V1PartitionServiceStatus(Async)");
        }
        return this.updateK2V1PartitionServiceStatusCall(environment, name, org, k2V1PartitionService, _callback);
    }

    public K2V1PartitionService updateK2V1PartitionServiceStatus(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        ApiResponse<K2V1PartitionService> localVarResp = this.updateK2V1PartitionServiceStatusWithHttpInfo(environment, name, org, k2V1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<K2V1PartitionService> updateK2V1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, K2V1PartitionService k2V1PartitionService) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, k2V1PartitionService, null);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateK2V1PartitionServiceStatusAsync(String environment, String name, String org, K2V1PartitionService k2V1PartitionService, ApiCallback<K2V1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateK2V1PartitionServiceStatusValidateBeforeCall(environment, name, org, k2V1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<K2V1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

