/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.KafkaV1BrokerPool;
import io.confluent.flink.apiserver.client.model.KafkaV1BrokerPoolGroup;
import io.confluent.flink.apiserver.client.model.KafkaV1BrokerPoolGroupList;
import io.confluent.flink.apiserver.client.model.KafkaV1BrokerPoolList;
import io.confluent.flink.apiserver.client.model.KafkaV1ConfluxDeployment;
import io.confluent.flink.apiserver.client.model.KafkaV1ConfluxDeploymentList;
import io.confluent.flink.apiserver.client.model.KafkaV1K2HealthCheck;
import io.confluent.flink.apiserver.client.model.KafkaV1K2HealthCheckGroup;
import io.confluent.flink.apiserver.client.model.KafkaV1K2HealthCheckGroupList;
import io.confluent.flink.apiserver.client.model.KafkaV1K2HealthCheckList;
import io.confluent.flink.apiserver.client.model.KafkaV1PartitionService;
import io.confluent.flink.apiserver.client.model.KafkaV1PartitionServiceList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class KafkaV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public KafkaV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public KafkaV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createKafkaV1BrokerPoolCall(String environment, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1BrokerPoolValidateBeforeCall(String environment, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1BrokerPool(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling createKafkaV1BrokerPool(Async)");
        }
        return this.createKafkaV1BrokerPoolCall(environment, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool createKafkaV1BrokerPool(String environment, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.createKafkaV1BrokerPoolWithHttpInfo(environment, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> createKafkaV1BrokerPoolWithHttpInfo(String environment, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.createKafkaV1BrokerPoolValidateBeforeCall(environment, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1BrokerPoolAsync(String environment, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1BrokerPoolValidateBeforeCall(environment, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createKafkaV1BrokerPoolGroupCall(String environment, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1BrokerPoolGroupValidateBeforeCall(String environment, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1BrokerPoolGroup(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling createKafkaV1BrokerPoolGroup(Async)");
        }
        return this.createKafkaV1BrokerPoolGroupCall(environment, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup createKafkaV1BrokerPoolGroup(String environment, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.createKafkaV1BrokerPoolGroupWithHttpInfo(environment, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> createKafkaV1BrokerPoolGroupWithHttpInfo(String environment, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.createKafkaV1BrokerPoolGroupValidateBeforeCall(environment, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1BrokerPoolGroupAsync(String environment, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1BrokerPoolGroupValidateBeforeCall(environment, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createKafkaV1ConfluxDeploymentCall(String environment, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1ConfluxDeploymentValidateBeforeCall(String environment, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1ConfluxDeployment(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling createKafkaV1ConfluxDeployment(Async)");
        }
        return this.createKafkaV1ConfluxDeploymentCall(environment, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment createKafkaV1ConfluxDeployment(String environment, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.createKafkaV1ConfluxDeploymentWithHttpInfo(environment, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> createKafkaV1ConfluxDeploymentWithHttpInfo(String environment, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.createKafkaV1ConfluxDeploymentValidateBeforeCall(environment, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1ConfluxDeploymentAsync(String environment, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1ConfluxDeploymentValidateBeforeCall(environment, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createKafkaV1K2HealthCheckCall(String environment, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1K2HealthCheckValidateBeforeCall(String environment, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1K2HealthCheck(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling createKafkaV1K2HealthCheck(Async)");
        }
        return this.createKafkaV1K2HealthCheckCall(environment, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck createKafkaV1K2HealthCheck(String environment, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.createKafkaV1K2HealthCheckWithHttpInfo(environment, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> createKafkaV1K2HealthCheckWithHttpInfo(String environment, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.createKafkaV1K2HealthCheckValidateBeforeCall(environment, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1K2HealthCheckAsync(String environment, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1K2HealthCheckValidateBeforeCall(environment, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createKafkaV1K2HealthCheckGroupCall(String environment, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1K2HealthCheckGroupValidateBeforeCall(String environment, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1K2HealthCheckGroup(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling createKafkaV1K2HealthCheckGroup(Async)");
        }
        return this.createKafkaV1K2HealthCheckGroupCall(environment, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup createKafkaV1K2HealthCheckGroup(String environment, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.createKafkaV1K2HealthCheckGroupWithHttpInfo(environment, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> createKafkaV1K2HealthCheckGroupWithHttpInfo(String environment, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.createKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1K2HealthCheckGroupAsync(String environment, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createKafkaV1PartitionServiceCall(String environment, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createKafkaV1PartitionServiceValidateBeforeCall(String environment, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createKafkaV1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createKafkaV1PartitionService(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling createKafkaV1PartitionService(Async)");
        }
        return this.createKafkaV1PartitionServiceCall(environment, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService createKafkaV1PartitionService(String environment, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.createKafkaV1PartitionServiceWithHttpInfo(environment, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> createKafkaV1PartitionServiceWithHttpInfo(String environment, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.createKafkaV1PartitionServiceValidateBeforeCall(environment, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createKafkaV1PartitionServiceAsync(String environment, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.createKafkaV1PartitionServiceValidateBeforeCall(environment, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1BrokerPoolCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1BrokerPoolValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1BrokerPool(Async)");
        }
        return this.deleteKafkaV1BrokerPoolCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1BrokerPool deleteKafkaV1BrokerPool(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.deleteKafkaV1BrokerPoolWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> deleteKafkaV1BrokerPoolWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1BrokerPoolAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1BrokerPoolGroupCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1BrokerPoolGroup(Async)");
        }
        return this.deleteKafkaV1BrokerPoolGroupCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1BrokerPoolGroup deleteKafkaV1BrokerPoolGroup(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.deleteKafkaV1BrokerPoolGroupWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> deleteKafkaV1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1BrokerPoolGroupAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1ConfluxDeploymentCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1ConfluxDeployment(Async)");
        }
        return this.deleteKafkaV1ConfluxDeploymentCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1ConfluxDeployment deleteKafkaV1ConfluxDeployment(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.deleteKafkaV1ConfluxDeploymentWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> deleteKafkaV1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1ConfluxDeploymentAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1K2HealthCheckCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1K2HealthCheckValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1K2HealthCheck(Async)");
        }
        return this.deleteKafkaV1K2HealthCheckCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1K2HealthCheck deleteKafkaV1K2HealthCheck(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.deleteKafkaV1K2HealthCheckWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> deleteKafkaV1K2HealthCheckWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1K2HealthCheckAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1K2HealthCheckGroupCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1K2HealthCheckGroup(Async)");
        }
        return this.deleteKafkaV1K2HealthCheckGroupCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1K2HealthCheckGroup deleteKafkaV1K2HealthCheckGroup(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.deleteKafkaV1K2HealthCheckGroupWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> deleteKafkaV1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1K2HealthCheckGroupAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteKafkaV1PartitionServiceCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteKafkaV1PartitionServiceValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteKafkaV1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteKafkaV1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteKafkaV1PartitionService(Async)");
        }
        return this.deleteKafkaV1PartitionServiceCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public KafkaV1PartitionService deleteKafkaV1PartitionService(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.deleteKafkaV1PartitionServiceWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> deleteKafkaV1PartitionServiceWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteKafkaV1PartitionServiceAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.deleteKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1BrokerPoolGroupsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1BrokerPoolGroupsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1BrokerPoolGroups(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1BrokerPoolGroups(Async)");
        }
        return this.listKafkaV1BrokerPoolGroupsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1BrokerPoolGroupList listKafkaV1BrokerPoolGroups(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroupList> localVarResp = this.listKafkaV1BrokerPoolGroupsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroupList> listKafkaV1BrokerPoolGroupsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1BrokerPoolGroupsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1BrokerPoolGroupList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1BrokerPoolGroupsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/brokerpoolgroups".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1BrokerPoolGroupsForAllEnvironments(Async)");
        }
        return this.listKafkaV1BrokerPoolGroupsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1BrokerPoolGroupList listKafkaV1BrokerPoolGroupsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroupList> localVarResp = this.listKafkaV1BrokerPoolGroupsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroupList> listKafkaV1BrokerPoolGroupsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1BrokerPoolGroupsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1BrokerPoolGroupList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1BrokerPoolsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1BrokerPoolsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1BrokerPools(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1BrokerPools(Async)");
        }
        return this.listKafkaV1BrokerPoolsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1BrokerPoolList listKafkaV1BrokerPools(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolList> localVarResp = this.listKafkaV1BrokerPoolsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolList> listKafkaV1BrokerPoolsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1BrokerPoolsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1BrokerPoolList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1BrokerPoolsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/brokerpools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1BrokerPoolsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1BrokerPoolsForAllEnvironments(Async)");
        }
        return this.listKafkaV1BrokerPoolsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1BrokerPoolList listKafkaV1BrokerPoolsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolList> localVarResp = this.listKafkaV1BrokerPoolsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolList> listKafkaV1BrokerPoolsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1BrokerPoolsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1BrokerPoolList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1BrokerPoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1ConfluxDeploymentsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1ConfluxDeploymentsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1ConfluxDeployments(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1ConfluxDeployments(Async)");
        }
        return this.listKafkaV1ConfluxDeploymentsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1ConfluxDeploymentList listKafkaV1ConfluxDeployments(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeploymentList> localVarResp = this.listKafkaV1ConfluxDeploymentsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeploymentList> listKafkaV1ConfluxDeploymentsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1ConfluxDeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1ConfluxDeploymentsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1ConfluxDeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1ConfluxDeploymentsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1ConfluxDeploymentsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/confluxdeployments".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1ConfluxDeploymentsForAllEnvironments(Async)");
        }
        return this.listKafkaV1ConfluxDeploymentsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1ConfluxDeploymentList listKafkaV1ConfluxDeploymentsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeploymentList> localVarResp = this.listKafkaV1ConfluxDeploymentsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeploymentList> listKafkaV1ConfluxDeploymentsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeploymentList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1ConfluxDeploymentsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1ConfluxDeploymentList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1ConfluxDeploymentsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeploymentList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1K2HealthCheckGroupsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1K2HealthCheckGroupsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1K2HealthCheckGroups(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1K2HealthCheckGroups(Async)");
        }
        return this.listKafkaV1K2HealthCheckGroupsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1K2HealthCheckGroupList listKafkaV1K2HealthCheckGroups(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroupList> localVarResp = this.listKafkaV1K2HealthCheckGroupsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroupList> listKafkaV1K2HealthCheckGroupsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthCheckGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1K2HealthCheckGroupsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1K2HealthCheckGroupList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthCheckGroupsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1K2HealthCheckGroupsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/k2healthcheckgroups".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1K2HealthCheckGroupsForAllEnvironments(Async)");
        }
        return this.listKafkaV1K2HealthCheckGroupsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1K2HealthCheckGroupList listKafkaV1K2HealthCheckGroupsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroupList> localVarResp = this.listKafkaV1K2HealthCheckGroupsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroupList> listKafkaV1K2HealthCheckGroupsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1K2HealthCheckGroupsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1K2HealthCheckGroupList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthCheckGroupsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1K2HealthChecksCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1K2HealthChecksValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1K2HealthChecks(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1K2HealthChecks(Async)");
        }
        return this.listKafkaV1K2HealthChecksCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1K2HealthCheckList listKafkaV1K2HealthChecks(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckList> localVarResp = this.listKafkaV1K2HealthChecksWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckList> listKafkaV1K2HealthChecksWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthChecksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1K2HealthChecksAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1K2HealthCheckList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthChecksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1K2HealthChecksForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/k2healthchecks".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1K2HealthChecksForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1K2HealthChecksForAllEnvironments(Async)");
        }
        return this.listKafkaV1K2HealthChecksForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1K2HealthCheckList listKafkaV1K2HealthChecksForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckList> localVarResp = this.listKafkaV1K2HealthChecksForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckList> listKafkaV1K2HealthChecksForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthChecksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1K2HealthChecksForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1K2HealthCheckList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1K2HealthChecksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1PartitionServicesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1PartitionServicesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listKafkaV1PartitionServices(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1PartitionServices(Async)");
        }
        return this.listKafkaV1PartitionServicesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1PartitionServiceList listKafkaV1PartitionServices(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1PartitionServiceList> localVarResp = this.listKafkaV1PartitionServicesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionServiceList> listKafkaV1PartitionServicesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1PartitionServicesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionServiceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1PartitionServicesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1PartitionServiceList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1PartitionServicesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionServiceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listKafkaV1PartitionServicesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/partitionservices".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listKafkaV1PartitionServicesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listKafkaV1PartitionServicesForAllEnvironments(Async)");
        }
        return this.listKafkaV1PartitionServicesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public KafkaV1PartitionServiceList listKafkaV1PartitionServicesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<KafkaV1PartitionServiceList> localVarResp = this.listKafkaV1PartitionServicesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionServiceList> listKafkaV1PartitionServicesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listKafkaV1PartitionServicesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionServiceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listKafkaV1PartitionServicesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<KafkaV1PartitionServiceList> _callback) throws ApiException {
        Call localVarCall = this.listKafkaV1PartitionServicesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionServiceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPool(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling patchKafkaV1BrokerPool(Async)");
        }
        return this.patchKafkaV1BrokerPoolCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool patchKafkaV1BrokerPool(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.patchKafkaV1BrokerPoolWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> patchKafkaV1BrokerPoolWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolFinalizersCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling patchKafkaV1BrokerPoolFinalizers(Async)");
        }
        return this.patchKafkaV1BrokerPoolFinalizersCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool patchKafkaV1BrokerPoolFinalizers(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.patchKafkaV1BrokerPoolFinalizersWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> patchKafkaV1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolFinalizersAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolGroupCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPoolGroup(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling patchKafkaV1BrokerPoolGroup(Async)");
        }
        return this.patchKafkaV1BrokerPoolGroupCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup patchKafkaV1BrokerPoolGroup(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.patchKafkaV1BrokerPoolGroupWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> patchKafkaV1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolGroupAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolGroupFinalizersCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling patchKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        return this.patchKafkaV1BrokerPoolGroupFinalizersCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup patchKafkaV1BrokerPoolGroupFinalizers(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.patchKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> patchKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolGroupStatusCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling patchKafkaV1BrokerPoolGroupStatus(Async)");
        }
        return this.patchKafkaV1BrokerPoolGroupStatusCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup patchKafkaV1BrokerPoolGroupStatus(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.patchKafkaV1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> patchKafkaV1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolGroupStatusAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1BrokerPoolStatusCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1BrokerPoolStatus(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling patchKafkaV1BrokerPoolStatus(Async)");
        }
        return this.patchKafkaV1BrokerPoolStatusCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool patchKafkaV1BrokerPoolStatus(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.patchKafkaV1BrokerPoolStatusWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> patchKafkaV1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1BrokerPoolStatusAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1ConfluxDeploymentCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1ConfluxDeployment(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling patchKafkaV1ConfluxDeployment(Async)");
        }
        return this.patchKafkaV1ConfluxDeploymentCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment patchKafkaV1ConfluxDeployment(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.patchKafkaV1ConfluxDeploymentWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> patchKafkaV1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1ConfluxDeploymentAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1ConfluxDeploymentFinalizersCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling patchKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        return this.patchKafkaV1ConfluxDeploymentFinalizersCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment patchKafkaV1ConfluxDeploymentFinalizers(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.patchKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> patchKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1ConfluxDeploymentStatusCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling patchKafkaV1ConfluxDeploymentStatus(Async)");
        }
        return this.patchKafkaV1ConfluxDeploymentStatusCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment patchKafkaV1ConfluxDeploymentStatus(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.patchKafkaV1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> patchKafkaV1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1ConfluxDeploymentStatusAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheck(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling patchKafkaV1K2HealthCheck(Async)");
        }
        return this.patchKafkaV1K2HealthCheckCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck patchKafkaV1K2HealthCheck(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.patchKafkaV1K2HealthCheckWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> patchKafkaV1K2HealthCheckWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckFinalizersCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling patchKafkaV1K2HealthCheckFinalizers(Async)");
        }
        return this.patchKafkaV1K2HealthCheckFinalizersCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck patchKafkaV1K2HealthCheckFinalizers(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.patchKafkaV1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> patchKafkaV1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckFinalizersAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckGroupCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheckGroup(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling patchKafkaV1K2HealthCheckGroup(Async)");
        }
        return this.patchKafkaV1K2HealthCheckGroupCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup patchKafkaV1K2HealthCheckGroup(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.patchKafkaV1K2HealthCheckGroupWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> patchKafkaV1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckGroupAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling patchKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.patchKafkaV1K2HealthCheckGroupFinalizersCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup patchKafkaV1K2HealthCheckGroupFinalizers(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.patchKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> patchKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckGroupStatusCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling patchKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        return this.patchKafkaV1K2HealthCheckGroupStatusCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup patchKafkaV1K2HealthCheckGroupStatus(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.patchKafkaV1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> patchKafkaV1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckGroupStatusAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1K2HealthCheckStatusCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1K2HealthCheckStatus(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling patchKafkaV1K2HealthCheckStatus(Async)");
        }
        return this.patchKafkaV1K2HealthCheckStatusCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck patchKafkaV1K2HealthCheckStatus(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.patchKafkaV1K2HealthCheckStatusWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> patchKafkaV1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1K2HealthCheckStatusAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1PartitionServiceCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1PartitionServiceValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1PartitionService(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling patchKafkaV1PartitionService(Async)");
        }
        return this.patchKafkaV1PartitionServiceCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService patchKafkaV1PartitionService(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.patchKafkaV1PartitionServiceWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> patchKafkaV1PartitionServiceWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1PartitionServiceAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1PartitionServiceFinalizersCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling patchKafkaV1PartitionServiceFinalizers(Async)");
        }
        return this.patchKafkaV1PartitionServiceFinalizersCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService patchKafkaV1PartitionServiceFinalizers(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.patchKafkaV1PartitionServiceFinalizersWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> patchKafkaV1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1PartitionServiceFinalizersAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchKafkaV1PartitionServiceStatusCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchKafkaV1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchKafkaV1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchKafkaV1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchKafkaV1PartitionServiceStatus(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling patchKafkaV1PartitionServiceStatus(Async)");
        }
        return this.patchKafkaV1PartitionServiceStatusCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService patchKafkaV1PartitionServiceStatus(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.patchKafkaV1PartitionServiceStatusWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> patchKafkaV1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchKafkaV1PartitionServiceStatusAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.patchKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPool(Async)");
        }
        return this.readKafkaV1BrokerPoolCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPool readKafkaV1BrokerPool(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.readKafkaV1BrokerPoolWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> readKafkaV1BrokerPoolWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPoolFinalizers(Async)");
        }
        return this.readKafkaV1BrokerPoolFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPool readKafkaV1BrokerPoolFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.readKafkaV1BrokerPoolFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> readKafkaV1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolGroupCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPoolGroup(Async)");
        }
        return this.readKafkaV1BrokerPoolGroupCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPoolGroup readKafkaV1BrokerPoolGroup(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.readKafkaV1BrokerPoolGroupWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> readKafkaV1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolGroupAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolGroupFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        return this.readKafkaV1BrokerPoolGroupFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPoolGroup readKafkaV1BrokerPoolGroupFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.readKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> readKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolGroupStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPoolGroupStatus(Async)");
        }
        return this.readKafkaV1BrokerPoolGroupStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPoolGroup readKafkaV1BrokerPoolGroupStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.readKafkaV1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> readKafkaV1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolGroupStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1BrokerPoolStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1BrokerPoolStatus(Async)");
        }
        return this.readKafkaV1BrokerPoolStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1BrokerPool readKafkaV1BrokerPoolStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.readKafkaV1BrokerPoolStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> readKafkaV1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1BrokerPoolStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1ConfluxDeploymentCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1ConfluxDeployment(Async)");
        }
        return this.readKafkaV1ConfluxDeploymentCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1ConfluxDeployment readKafkaV1ConfluxDeployment(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.readKafkaV1ConfluxDeploymentWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> readKafkaV1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1ConfluxDeploymentAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1ConfluxDeploymentFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        return this.readKafkaV1ConfluxDeploymentFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1ConfluxDeployment readKafkaV1ConfluxDeploymentFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.readKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> readKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1ConfluxDeploymentStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1ConfluxDeploymentStatus(Async)");
        }
        return this.readKafkaV1ConfluxDeploymentStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1ConfluxDeployment readKafkaV1ConfluxDeploymentStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.readKafkaV1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> readKafkaV1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1ConfluxDeploymentStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheck(Async)");
        }
        return this.readKafkaV1K2HealthCheckCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheck readKafkaV1K2HealthCheck(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.readKafkaV1K2HealthCheckWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> readKafkaV1K2HealthCheckWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheckFinalizers(Async)");
        }
        return this.readKafkaV1K2HealthCheckFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheck readKafkaV1K2HealthCheckFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.readKafkaV1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> readKafkaV1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckGroupCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheckGroup(Async)");
        }
        return this.readKafkaV1K2HealthCheckGroupCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheckGroup readKafkaV1K2HealthCheckGroup(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.readKafkaV1K2HealthCheckGroupWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> readKafkaV1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckGroupAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.readKafkaV1K2HealthCheckGroupFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheckGroup readKafkaV1K2HealthCheckGroupFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.readKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> readKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckGroupStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        return this.readKafkaV1K2HealthCheckGroupStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheckGroup readKafkaV1K2HealthCheckGroupStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.readKafkaV1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> readKafkaV1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckGroupStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1K2HealthCheckStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1K2HealthCheckStatus(Async)");
        }
        return this.readKafkaV1K2HealthCheckStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1K2HealthCheck readKafkaV1K2HealthCheckStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.readKafkaV1K2HealthCheckStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> readKafkaV1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1K2HealthCheckStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1PartitionServiceCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1PartitionServiceValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1PartitionService(Async)");
        }
        return this.readKafkaV1PartitionServiceCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1PartitionService readKafkaV1PartitionService(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.readKafkaV1PartitionServiceWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> readKafkaV1PartitionServiceWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1PartitionServiceAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1PartitionServiceFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1PartitionServiceFinalizers(Async)");
        }
        return this.readKafkaV1PartitionServiceFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1PartitionService readKafkaV1PartitionServiceFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.readKafkaV1PartitionServiceFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> readKafkaV1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1PartitionServiceFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readKafkaV1PartitionServiceStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readKafkaV1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readKafkaV1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readKafkaV1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readKafkaV1PartitionServiceStatus(Async)");
        }
        return this.readKafkaV1PartitionServiceStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public KafkaV1PartitionService readKafkaV1PartitionServiceStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.readKafkaV1PartitionServiceStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> readKafkaV1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readKafkaV1PartitionServiceStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.readKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPool(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling updateKafkaV1BrokerPool(Async)");
        }
        return this.updateKafkaV1BrokerPoolCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool updateKafkaV1BrokerPool(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.updateKafkaV1BrokerPoolWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> updateKafkaV1BrokerPoolWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolFinalizersCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPoolFinalizers(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling updateKafkaV1BrokerPoolFinalizers(Async)");
        }
        return this.updateKafkaV1BrokerPoolFinalizersCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool updateKafkaV1BrokerPoolFinalizers(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.updateKafkaV1BrokerPoolFinalizersWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> updateKafkaV1BrokerPoolFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolFinalizersAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolGroupCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolGroupValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPoolGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPoolGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPoolGroup(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling updateKafkaV1BrokerPoolGroup(Async)");
        }
        return this.updateKafkaV1BrokerPoolGroupCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup updateKafkaV1BrokerPoolGroup(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.updateKafkaV1BrokerPoolGroupWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> updateKafkaV1BrokerPoolGroupWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolGroupAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolGroupFinalizersCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling updateKafkaV1BrokerPoolGroupFinalizers(Async)");
        }
        return this.updateKafkaV1BrokerPoolGroupFinalizersCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup updateKafkaV1BrokerPoolGroupFinalizers(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.updateKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> updateKafkaV1BrokerPoolGroupFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolGroupFinalizersAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolGroupStatusCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPoolGroup localVarPostBody = kafkaV1BrokerPoolGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpoolgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolGroupStatusValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPoolGroupStatus(Async)");
        }
        if (kafkaV1BrokerPoolGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPoolGroup' when calling updateKafkaV1BrokerPoolGroupStatus(Async)");
        }
        return this.updateKafkaV1BrokerPoolGroupStatusCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
    }

    public KafkaV1BrokerPoolGroup updateKafkaV1BrokerPoolGroupStatus(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        ApiResponse<KafkaV1BrokerPoolGroup> localVarResp = this.updateKafkaV1BrokerPoolGroupStatusWithHttpInfo(environment, name, org, kafkaV1BrokerPoolGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPoolGroup> updateKafkaV1BrokerPoolGroupStatusWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolGroupStatusAsync(String environment, String name, String org, KafkaV1BrokerPoolGroup kafkaV1BrokerPoolGroup, ApiCallback<KafkaV1BrokerPoolGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolGroupStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPoolGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPoolGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1BrokerPoolStatusCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1BrokerPool localVarPostBody = kafkaV1BrokerPool;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/brokerpools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1BrokerPoolStatusValidateBeforeCall(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1BrokerPoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1BrokerPoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1BrokerPoolStatus(Async)");
        }
        if (kafkaV1BrokerPool == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1BrokerPool' when calling updateKafkaV1BrokerPoolStatus(Async)");
        }
        return this.updateKafkaV1BrokerPoolStatusCall(environment, name, org, kafkaV1BrokerPool, _callback);
    }

    public KafkaV1BrokerPool updateKafkaV1BrokerPoolStatus(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        ApiResponse<KafkaV1BrokerPool> localVarResp = this.updateKafkaV1BrokerPoolStatusWithHttpInfo(environment, name, org, kafkaV1BrokerPool);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1BrokerPool> updateKafkaV1BrokerPoolStatusWithHttpInfo(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, null);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1BrokerPoolStatusAsync(String environment, String name, String org, KafkaV1BrokerPool kafkaV1BrokerPool, ApiCallback<KafkaV1BrokerPool> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1BrokerPoolStatusValidateBeforeCall(environment, name, org, kafkaV1BrokerPool, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1BrokerPool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1ConfluxDeploymentCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1ConfluxDeploymentValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1ConfluxDeployment(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1ConfluxDeployment(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1ConfluxDeployment(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling updateKafkaV1ConfluxDeployment(Async)");
        }
        return this.updateKafkaV1ConfluxDeploymentCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment updateKafkaV1ConfluxDeployment(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.updateKafkaV1ConfluxDeploymentWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> updateKafkaV1ConfluxDeploymentWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1ConfluxDeploymentAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1ConfluxDeploymentFinalizersCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling updateKafkaV1ConfluxDeploymentFinalizers(Async)");
        }
        return this.updateKafkaV1ConfluxDeploymentFinalizersCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment updateKafkaV1ConfluxDeploymentFinalizers(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.updateKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> updateKafkaV1ConfluxDeploymentFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1ConfluxDeploymentFinalizersAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentFinalizersValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1ConfluxDeploymentStatusCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1ConfluxDeployment localVarPostBody = kafkaV1ConfluxDeployment;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/confluxdeployments/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1ConfluxDeploymentStatusValidateBeforeCall(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1ConfluxDeploymentStatus(Async)");
        }
        if (kafkaV1ConfluxDeployment == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1ConfluxDeployment' when calling updateKafkaV1ConfluxDeploymentStatus(Async)");
        }
        return this.updateKafkaV1ConfluxDeploymentStatusCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
    }

    public KafkaV1ConfluxDeployment updateKafkaV1ConfluxDeploymentStatus(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        ApiResponse<KafkaV1ConfluxDeployment> localVarResp = this.updateKafkaV1ConfluxDeploymentStatusWithHttpInfo(environment, name, org, kafkaV1ConfluxDeployment);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1ConfluxDeployment> updateKafkaV1ConfluxDeploymentStatusWithHttpInfo(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, null);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1ConfluxDeploymentStatusAsync(String environment, String name, String org, KafkaV1ConfluxDeployment kafkaV1ConfluxDeployment, ApiCallback<KafkaV1ConfluxDeployment> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1ConfluxDeploymentStatusValidateBeforeCall(environment, name, org, kafkaV1ConfluxDeployment, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1ConfluxDeployment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheck(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheck(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheck(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling updateKafkaV1K2HealthCheck(Async)");
        }
        return this.updateKafkaV1K2HealthCheckCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck updateKafkaV1K2HealthCheck(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.updateKafkaV1K2HealthCheckWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> updateKafkaV1K2HealthCheckWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckFinalizersCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheckFinalizers(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling updateKafkaV1K2HealthCheckFinalizers(Async)");
        }
        return this.updateKafkaV1K2HealthCheckFinalizersCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck updateKafkaV1K2HealthCheckFinalizers(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.updateKafkaV1K2HealthCheckFinalizersWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> updateKafkaV1K2HealthCheckFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckFinalizersAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckGroupCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckGroupValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheckGroup(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheckGroup(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheckGroup(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling updateKafkaV1K2HealthCheckGroup(Async)");
        }
        return this.updateKafkaV1K2HealthCheckGroupCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup updateKafkaV1K2HealthCheckGroup(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.updateKafkaV1K2HealthCheckGroupWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> updateKafkaV1K2HealthCheckGroupWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckGroupAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckGroupFinalizersCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling updateKafkaV1K2HealthCheckGroupFinalizers(Async)");
        }
        return this.updateKafkaV1K2HealthCheckGroupFinalizersCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup updateKafkaV1K2HealthCheckGroupFinalizers(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.updateKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> updateKafkaV1K2HealthCheckGroupFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckGroupFinalizersAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupFinalizersValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckGroupStatusCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheckGroup localVarPostBody = kafkaV1K2HealthCheckGroup;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthcheckgroups/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        if (kafkaV1K2HealthCheckGroup == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheckGroup' when calling updateKafkaV1K2HealthCheckGroupStatus(Async)");
        }
        return this.updateKafkaV1K2HealthCheckGroupStatusCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
    }

    public KafkaV1K2HealthCheckGroup updateKafkaV1K2HealthCheckGroupStatus(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheckGroup> localVarResp = this.updateKafkaV1K2HealthCheckGroupStatusWithHttpInfo(environment, name, org, kafkaV1K2HealthCheckGroup);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheckGroup> updateKafkaV1K2HealthCheckGroupStatusWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckGroupStatusAsync(String environment, String name, String org, KafkaV1K2HealthCheckGroup kafkaV1K2HealthCheckGroup, ApiCallback<KafkaV1K2HealthCheckGroup> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckGroupStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheckGroup, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheckGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1K2HealthCheckStatusCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1K2HealthCheck localVarPostBody = kafkaV1K2HealthCheck;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/k2healthchecks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1K2HealthCheckStatusValidateBeforeCall(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1K2HealthCheckStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1K2HealthCheckStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1K2HealthCheckStatus(Async)");
        }
        if (kafkaV1K2HealthCheck == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1K2HealthCheck' when calling updateKafkaV1K2HealthCheckStatus(Async)");
        }
        return this.updateKafkaV1K2HealthCheckStatusCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
    }

    public KafkaV1K2HealthCheck updateKafkaV1K2HealthCheckStatus(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        ApiResponse<KafkaV1K2HealthCheck> localVarResp = this.updateKafkaV1K2HealthCheckStatusWithHttpInfo(environment, name, org, kafkaV1K2HealthCheck);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1K2HealthCheck> updateKafkaV1K2HealthCheckStatusWithHttpInfo(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, null);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1K2HealthCheckStatusAsync(String environment, String name, String org, KafkaV1K2HealthCheck kafkaV1K2HealthCheck, ApiCallback<KafkaV1K2HealthCheck> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1K2HealthCheckStatusValidateBeforeCall(environment, name, org, kafkaV1K2HealthCheck, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1K2HealthCheck>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1PartitionServiceCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1PartitionServiceValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1PartitionService(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1PartitionService(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1PartitionService(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling updateKafkaV1PartitionService(Async)");
        }
        return this.updateKafkaV1PartitionServiceCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService updateKafkaV1PartitionService(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.updateKafkaV1PartitionServiceWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> updateKafkaV1PartitionServiceWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1PartitionServiceAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1PartitionServiceFinalizersCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1PartitionServiceFinalizersValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1PartitionServiceFinalizers(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling updateKafkaV1PartitionServiceFinalizers(Async)");
        }
        return this.updateKafkaV1PartitionServiceFinalizersCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService updateKafkaV1PartitionServiceFinalizers(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.updateKafkaV1PartitionServiceFinalizersWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> updateKafkaV1PartitionServiceFinalizersWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1PartitionServiceFinalizersAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceFinalizersValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateKafkaV1PartitionServiceStatusCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        KafkaV1PartitionService localVarPostBody = kafkaV1PartitionService;
        String localVarPath = "/apis/kafka/v1/orgs/{org}/environments/{environment}/partitionservices/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateKafkaV1PartitionServiceStatusValidateBeforeCall(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateKafkaV1PartitionServiceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateKafkaV1PartitionServiceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateKafkaV1PartitionServiceStatus(Async)");
        }
        if (kafkaV1PartitionService == null) {
            throw new ApiException("Missing the required parameter 'kafkaV1PartitionService' when calling updateKafkaV1PartitionServiceStatus(Async)");
        }
        return this.updateKafkaV1PartitionServiceStatusCall(environment, name, org, kafkaV1PartitionService, _callback);
    }

    public KafkaV1PartitionService updateKafkaV1PartitionServiceStatus(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        ApiResponse<KafkaV1PartitionService> localVarResp = this.updateKafkaV1PartitionServiceStatusWithHttpInfo(environment, name, org, kafkaV1PartitionService);
        return localVarResp.getData();
    }

    public ApiResponse<KafkaV1PartitionService> updateKafkaV1PartitionServiceStatusWithHttpInfo(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, kafkaV1PartitionService, null);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateKafkaV1PartitionServiceStatusAsync(String environment, String name, String org, KafkaV1PartitionService kafkaV1PartitionService, ApiCallback<KafkaV1PartitionService> _callback) throws ApiException {
        Call localVarCall = this.updateKafkaV1PartitionServiceStatusValidateBeforeCall(environment, name, org, kafkaV1PartitionService, _callback);
        Type localVarReturnType = new TypeToken<KafkaV1PartitionService>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

