/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.RayV1ComputePool;
import io.confluent.flink.apiserver.client.model.RayV1ComputePoolList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RayV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RayV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public RayV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createRayV1ComputePoolCall(String environment, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRayV1ComputePoolValidateBeforeCall(String environment, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createRayV1ComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createRayV1ComputePool(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling createRayV1ComputePool(Async)");
        }
        return this.createRayV1ComputePoolCall(environment, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool createRayV1ComputePool(String environment, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.createRayV1ComputePoolWithHttpInfo(environment, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> createRayV1ComputePoolWithHttpInfo(String environment, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.createRayV1ComputePoolValidateBeforeCall(environment, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createRayV1ComputePoolAsync(String environment, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.createRayV1ComputePoolValidateBeforeCall(environment, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteRayV1ComputePoolCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRayV1ComputePoolValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteRayV1ComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteRayV1ComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteRayV1ComputePool(Async)");
        }
        return this.deleteRayV1ComputePoolCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public RayV1ComputePool deleteRayV1ComputePool(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.deleteRayV1ComputePoolWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> deleteRayV1ComputePoolWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteRayV1ComputePoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteRayV1ComputePoolAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.deleteRayV1ComputePoolValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRayV1ComputePoolsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRayV1ComputePoolsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listRayV1ComputePools(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listRayV1ComputePools(Async)");
        }
        return this.listRayV1ComputePoolsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public RayV1ComputePoolList listRayV1ComputePools(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<RayV1ComputePoolList> localVarResp = this.listRayV1ComputePoolsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePoolList> listRayV1ComputePoolsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listRayV1ComputePoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRayV1ComputePoolsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<RayV1ComputePoolList> _callback) throws ApiException {
        Call localVarCall = this.listRayV1ComputePoolsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRayV1ComputePoolsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/computepools".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRayV1ComputePoolsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listRayV1ComputePoolsForAllEnvironments(Async)");
        }
        return this.listRayV1ComputePoolsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public RayV1ComputePoolList listRayV1ComputePoolsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<RayV1ComputePoolList> localVarResp = this.listRayV1ComputePoolsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePoolList> listRayV1ComputePoolsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listRayV1ComputePoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePoolList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRayV1ComputePoolsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<RayV1ComputePoolList> _callback) throws ApiException {
        Call localVarCall = this.listRayV1ComputePoolsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePoolList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1ComputePoolCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1ComputePoolValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1ComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1ComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1ComputePool(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling patchRayV1ComputePool(Async)");
        }
        return this.patchRayV1ComputePoolCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool patchRayV1ComputePool(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.patchRayV1ComputePoolWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> patchRayV1ComputePoolWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1ComputePoolAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1ComputePoolFinalizersCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1ComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1ComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1ComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1ComputePoolFinalizers(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling patchRayV1ComputePoolFinalizers(Async)");
        }
        return this.patchRayV1ComputePoolFinalizersCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool patchRayV1ComputePoolFinalizers(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.patchRayV1ComputePoolFinalizersWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> patchRayV1ComputePoolFinalizersWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1ComputePoolFinalizersAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRayV1ComputePoolStatusCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRayV1ComputePoolStatusValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchRayV1ComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchRayV1ComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchRayV1ComputePoolStatus(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling patchRayV1ComputePoolStatus(Async)");
        }
        return this.patchRayV1ComputePoolStatusCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool patchRayV1ComputePoolStatus(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.patchRayV1ComputePoolStatusWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> patchRayV1ComputePoolStatusWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRayV1ComputePoolStatusAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.patchRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1ComputePoolCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1ComputePoolValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1ComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1ComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1ComputePool(Async)");
        }
        return this.readRayV1ComputePoolCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1ComputePool readRayV1ComputePool(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.readRayV1ComputePoolWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> readRayV1ComputePoolWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1ComputePoolAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1ComputePoolFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1ComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1ComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1ComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1ComputePoolFinalizers(Async)");
        }
        return this.readRayV1ComputePoolFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1ComputePool readRayV1ComputePoolFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.readRayV1ComputePoolFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> readRayV1ComputePoolFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1ComputePoolFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readRayV1ComputePoolStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readRayV1ComputePoolStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readRayV1ComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readRayV1ComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readRayV1ComputePoolStatus(Async)");
        }
        return this.readRayV1ComputePoolStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public RayV1ComputePool readRayV1ComputePoolStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.readRayV1ComputePoolStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> readRayV1ComputePoolStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readRayV1ComputePoolStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.readRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1ComputePoolCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1ComputePoolValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1ComputePool(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1ComputePool(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1ComputePool(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling updateRayV1ComputePool(Async)");
        }
        return this.updateRayV1ComputePoolCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool updateRayV1ComputePool(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.updateRayV1ComputePoolWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> updateRayV1ComputePoolWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1ComputePoolAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1ComputePoolFinalizersCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1ComputePoolFinalizersValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1ComputePoolFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1ComputePoolFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1ComputePoolFinalizers(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling updateRayV1ComputePoolFinalizers(Async)");
        }
        return this.updateRayV1ComputePoolFinalizersCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool updateRayV1ComputePoolFinalizers(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.updateRayV1ComputePoolFinalizersWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> updateRayV1ComputePoolFinalizersWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1ComputePoolFinalizersAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolFinalizersValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateRayV1ComputePoolStatusCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RayV1ComputePool localVarPostBody = rayV1ComputePool;
        String localVarPath = "/apis/ray/v1/orgs/{org}/environments/{environment}/computepools/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateRayV1ComputePoolStatusValidateBeforeCall(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateRayV1ComputePoolStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRayV1ComputePoolStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateRayV1ComputePoolStatus(Async)");
        }
        if (rayV1ComputePool == null) {
            throw new ApiException("Missing the required parameter 'rayV1ComputePool' when calling updateRayV1ComputePoolStatus(Async)");
        }
        return this.updateRayV1ComputePoolStatusCall(environment, name, org, rayV1ComputePool, _callback);
    }

    public RayV1ComputePool updateRayV1ComputePoolStatus(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        ApiResponse<RayV1ComputePool> localVarResp = this.updateRayV1ComputePoolStatusWithHttpInfo(environment, name, org, rayV1ComputePool);
        return localVarResp.getData();
    }

    public ApiResponse<RayV1ComputePool> updateRayV1ComputePoolStatusWithHttpInfo(String environment, String name, String org, RayV1ComputePool rayV1ComputePool) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, rayV1ComputePool, null);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateRayV1ComputePoolStatusAsync(String environment, String name, String org, RayV1ComputePool rayV1ComputePool, ApiCallback<RayV1ComputePool> _callback) throws ApiException {
        Call localVarCall = this.updateRayV1ComputePoolStatusValidateBeforeCall(environment, name, org, rayV1ComputePool, _callback);
        Type localVarReturnType = new TypeToken<RayV1ComputePool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

