/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.SecretsV1Secret;
import io.confluent.flink.apiserver.client.model.SecretsV1SecretDestination;
import io.confluent.flink.apiserver.client.model.SecretsV1SecretDestinationList;
import io.confluent.flink.apiserver.client.model.SecretsV1SecretList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SecretsV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SecretsV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSecretsV1SecretCall(String environment, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1Secret localVarPostBody = secretsV1Secret;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSecretsV1SecretValidateBeforeCall(String environment, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSecretsV1Secret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSecretsV1Secret(Async)");
        }
        if (secretsV1Secret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1Secret' when calling createSecretsV1Secret(Async)");
        }
        return this.createSecretsV1SecretCall(environment, org, secretsV1Secret, _callback);
    }

    public SecretsV1Secret createSecretsV1Secret(String environment, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.createSecretsV1SecretWithHttpInfo(environment, org, secretsV1Secret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> createSecretsV1SecretWithHttpInfo(String environment, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        Call localVarCall = this.createSecretsV1SecretValidateBeforeCall(environment, org, secretsV1Secret, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSecretsV1SecretAsync(String environment, String org, SecretsV1Secret secretsV1Secret, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.createSecretsV1SecretValidateBeforeCall(environment, org, secretsV1Secret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSecretsV1SecretDestinationCall(String environment, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSecretsV1SecretDestinationValidateBeforeCall(String environment, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSecretsV1SecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSecretsV1SecretDestination(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling createSecretsV1SecretDestination(Async)");
        }
        return this.createSecretsV1SecretDestinationCall(environment, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination createSecretsV1SecretDestination(String environment, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.createSecretsV1SecretDestinationWithHttpInfo(environment, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> createSecretsV1SecretDestinationWithHttpInfo(String environment, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.createSecretsV1SecretDestinationValidateBeforeCall(environment, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSecretsV1SecretDestinationAsync(String environment, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.createSecretsV1SecretDestinationValidateBeforeCall(environment, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSecretsV1SecretCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSecretsV1SecretValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSecretsV1Secret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSecretsV1Secret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSecretsV1Secret(Async)");
        }
        return this.deleteSecretsV1SecretCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SecretsV1Secret deleteSecretsV1Secret(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.deleteSecretsV1SecretWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> deleteSecretsV1SecretWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSecretsV1SecretValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSecretsV1SecretAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.deleteSecretsV1SecretValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSecretsV1SecretDestinationCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSecretsV1SecretDestinationValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSecretsV1SecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSecretsV1SecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSecretsV1SecretDestination(Async)");
        }
        return this.deleteSecretsV1SecretDestinationCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SecretsV1SecretDestination deleteSecretsV1SecretDestination(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.deleteSecretsV1SecretDestinationWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> deleteSecretsV1SecretDestinationWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSecretsV1SecretDestinationAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.deleteSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1SecretDestinationsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1SecretDestinationsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSecretsV1SecretDestinations(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1SecretDestinations(Async)");
        }
        return this.listSecretsV1SecretDestinationsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1SecretDestinationList listSecretsV1SecretDestinations(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1SecretDestinationList> localVarResp = this.listSecretsV1SecretDestinationsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestinationList> listSecretsV1SecretDestinationsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1SecretDestinationsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1SecretDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretDestinationsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1SecretDestinationsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/secretdestinations".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1SecretDestinationsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1SecretDestinationsForAllEnvironments(Async)");
        }
        return this.listSecretsV1SecretDestinationsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1SecretDestinationList listSecretsV1SecretDestinationsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1SecretDestinationList> localVarResp = this.listSecretsV1SecretDestinationsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestinationList> listSecretsV1SecretDestinationsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestinationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1SecretDestinationsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1SecretDestinationList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretDestinationsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestinationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1SecretsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1SecretsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSecretsV1Secrets(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1Secrets(Async)");
        }
        return this.listSecretsV1SecretsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1SecretList listSecretsV1Secrets(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1SecretList> localVarResp = this.listSecretsV1SecretsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretList> listSecretsV1SecretsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1SecretsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1SecretList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSecretsV1SecretsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/secrets".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSecretsV1SecretsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSecretsV1SecretsForAllEnvironments(Async)");
        }
        return this.listSecretsV1SecretsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SecretsV1SecretList listSecretsV1SecretsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SecretsV1SecretList> localVarResp = this.listSecretsV1SecretsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretList> listSecretsV1SecretsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSecretsV1SecretsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SecretsV1SecretList> _callback) throws ApiException {
        Call localVarCall = this.listSecretsV1SecretsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1SecretCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1Secret localVarPostBody = secretsV1Secret;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1SecretValidateBeforeCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1Secret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1Secret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1Secret(Async)");
        }
        if (secretsV1Secret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1Secret' when calling patchSecretsV1Secret(Async)");
        }
        return this.patchSecretsV1SecretCall(environment, name, org, secretsV1Secret, _callback);
    }

    public SecretsV1Secret patchSecretsV1Secret(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.patchSecretsV1SecretWithHttpInfo(environment, name, org, secretsV1Secret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> patchSecretsV1SecretWithHttpInfo(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretValidateBeforeCall(environment, name, org, secretsV1Secret, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1SecretAsync(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretValidateBeforeCall(environment, name, org, secretsV1Secret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1SecretDestinationCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1SecretDestinationValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1SecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1SecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1SecretDestination(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling patchSecretsV1SecretDestination(Async)");
        }
        return this.patchSecretsV1SecretDestinationCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination patchSecretsV1SecretDestination(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.patchSecretsV1SecretDestinationWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> patchSecretsV1SecretDestinationWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1SecretDestinationAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1SecretDestinationFinalizersCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1SecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling patchSecretsV1SecretDestinationFinalizers(Async)");
        }
        return this.patchSecretsV1SecretDestinationFinalizersCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination patchSecretsV1SecretDestinationFinalizers(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.patchSecretsV1SecretDestinationFinalizersWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> patchSecretsV1SecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1SecretDestinationFinalizersAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1SecretDestinationStatusCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1SecretDestinationStatusValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1SecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1SecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1SecretDestinationStatus(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling patchSecretsV1SecretDestinationStatus(Async)");
        }
        return this.patchSecretsV1SecretDestinationStatusCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination patchSecretsV1SecretDestinationStatus(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.patchSecretsV1SecretDestinationStatusWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> patchSecretsV1SecretDestinationStatusWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1SecretDestinationStatusAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSecretsV1SecretFinalizersCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1Secret localVarPostBody = secretsV1Secret;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSecretsV1SecretFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSecretsV1SecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSecretsV1SecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSecretsV1SecretFinalizers(Async)");
        }
        if (secretsV1Secret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1Secret' when calling patchSecretsV1SecretFinalizers(Async)");
        }
        return this.patchSecretsV1SecretFinalizersCall(environment, name, org, secretsV1Secret, _callback);
    }

    public SecretsV1Secret patchSecretsV1SecretFinalizers(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.patchSecretsV1SecretFinalizersWithHttpInfo(environment, name, org, secretsV1Secret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> patchSecretsV1SecretFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, secretsV1Secret, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSecretsV1SecretFinalizersAsync(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.patchSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, secretsV1Secret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1SecretCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1SecretValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1Secret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1Secret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1Secret(Async)");
        }
        return this.readSecretsV1SecretCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1Secret readSecretsV1Secret(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.readSecretsV1SecretWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> readSecretsV1SecretWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1SecretAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1SecretDestinationCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1SecretDestinationValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1SecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1SecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1SecretDestination(Async)");
        }
        return this.readSecretsV1SecretDestinationCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1SecretDestination readSecretsV1SecretDestination(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.readSecretsV1SecretDestinationWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> readSecretsV1SecretDestinationWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1SecretDestinationAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1SecretDestinationFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1SecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1SecretDestinationFinalizers(Async)");
        }
        return this.readSecretsV1SecretDestinationFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1SecretDestination readSecretsV1SecretDestinationFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.readSecretsV1SecretDestinationFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> readSecretsV1SecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1SecretDestinationFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1SecretDestinationStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1SecretDestinationStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1SecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1SecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1SecretDestinationStatus(Async)");
        }
        return this.readSecretsV1SecretDestinationStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1SecretDestination readSecretsV1SecretDestinationStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.readSecretsV1SecretDestinationStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> readSecretsV1SecretDestinationStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1SecretDestinationStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSecretsV1SecretFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSecretsV1SecretFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSecretsV1SecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSecretsV1SecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSecretsV1SecretFinalizers(Async)");
        }
        return this.readSecretsV1SecretFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SecretsV1Secret readSecretsV1SecretFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.readSecretsV1SecretFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> readSecretsV1SecretFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSecretsV1SecretFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.readSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1SecretCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1Secret localVarPostBody = secretsV1Secret;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1SecretValidateBeforeCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1Secret(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1Secret(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1Secret(Async)");
        }
        if (secretsV1Secret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1Secret' when calling updateSecretsV1Secret(Async)");
        }
        return this.updateSecretsV1SecretCall(environment, name, org, secretsV1Secret, _callback);
    }

    public SecretsV1Secret updateSecretsV1Secret(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.updateSecretsV1SecretWithHttpInfo(environment, name, org, secretsV1Secret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> updateSecretsV1SecretWithHttpInfo(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretValidateBeforeCall(environment, name, org, secretsV1Secret, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1SecretAsync(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretValidateBeforeCall(environment, name, org, secretsV1Secret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1SecretDestinationCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1SecretDestinationValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1SecretDestination(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1SecretDestination(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1SecretDestination(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling updateSecretsV1SecretDestination(Async)");
        }
        return this.updateSecretsV1SecretDestinationCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination updateSecretsV1SecretDestination(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.updateSecretsV1SecretDestinationWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> updateSecretsV1SecretDestinationWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1SecretDestinationAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1SecretDestinationFinalizersCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1SecretDestinationFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1SecretDestinationFinalizers(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling updateSecretsV1SecretDestinationFinalizers(Async)");
        }
        return this.updateSecretsV1SecretDestinationFinalizersCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination updateSecretsV1SecretDestinationFinalizers(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.updateSecretsV1SecretDestinationFinalizersWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> updateSecretsV1SecretDestinationFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1SecretDestinationFinalizersAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationFinalizersValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1SecretDestinationStatusCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1SecretDestination localVarPostBody = secretsV1SecretDestination;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secretdestinations/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1SecretDestinationStatusValidateBeforeCall(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1SecretDestinationStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1SecretDestinationStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1SecretDestinationStatus(Async)");
        }
        if (secretsV1SecretDestination == null) {
            throw new ApiException("Missing the required parameter 'secretsV1SecretDestination' when calling updateSecretsV1SecretDestinationStatus(Async)");
        }
        return this.updateSecretsV1SecretDestinationStatusCall(environment, name, org, secretsV1SecretDestination, _callback);
    }

    public SecretsV1SecretDestination updateSecretsV1SecretDestinationStatus(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        ApiResponse<SecretsV1SecretDestination> localVarResp = this.updateSecretsV1SecretDestinationStatusWithHttpInfo(environment, name, org, secretsV1SecretDestination);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1SecretDestination> updateSecretsV1SecretDestinationStatusWithHttpInfo(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1SecretDestination, null);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1SecretDestinationStatusAsync(String environment, String name, String org, SecretsV1SecretDestination secretsV1SecretDestination, ApiCallback<SecretsV1SecretDestination> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretDestinationStatusValidateBeforeCall(environment, name, org, secretsV1SecretDestination, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1SecretDestination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSecretsV1SecretFinalizersCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SecretsV1Secret localVarPostBody = secretsV1Secret;
        String localVarPath = "/apis/secrets/v1/orgs/{org}/environments/{environment}/secrets/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSecretsV1SecretFinalizersValidateBeforeCall(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSecretsV1SecretFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSecretsV1SecretFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSecretsV1SecretFinalizers(Async)");
        }
        if (secretsV1Secret == null) {
            throw new ApiException("Missing the required parameter 'secretsV1Secret' when calling updateSecretsV1SecretFinalizers(Async)");
        }
        return this.updateSecretsV1SecretFinalizersCall(environment, name, org, secretsV1Secret, _callback);
    }

    public SecretsV1Secret updateSecretsV1SecretFinalizers(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        ApiResponse<SecretsV1Secret> localVarResp = this.updateSecretsV1SecretFinalizersWithHttpInfo(environment, name, org, secretsV1Secret);
        return localVarResp.getData();
    }

    public ApiResponse<SecretsV1Secret> updateSecretsV1SecretFinalizersWithHttpInfo(String environment, String name, String org, SecretsV1Secret secretsV1Secret) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, secretsV1Secret, null);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSecretsV1SecretFinalizersAsync(String environment, String name, String org, SecretsV1Secret secretsV1Secret, ApiCallback<SecretsV1Secret> _callback) throws ApiException {
        Call localVarCall = this.updateSecretsV1SecretFinalizersValidateBeforeCall(environment, name, org, secretsV1Secret, _callback);
        Type localVarReturnType = new TypeToken<SecretsV1Secret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

