/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.SqlV1Database;
import io.confluent.flink.apiserver.client.model.SqlV1DatabaseList;
import io.confluent.flink.apiserver.client.model.SqlV1SQLJob;
import io.confluent.flink.apiserver.client.model.SqlV1SQLJobList;
import io.confluent.flink.apiserver.client.model.SqlV1Statement;
import io.confluent.flink.apiserver.client.model.SqlV1StatementList;
import io.confluent.flink.apiserver.client.model.SqlV1StatementResult;
import io.confluent.flink.apiserver.client.model.SqlV1StatementResultList;
import io.confluent.flink.apiserver.client.model.SqlV1Table;
import io.confluent.flink.apiserver.client.model.SqlV1TableList;
import io.confluent.flink.apiserver.client.model.SqlV1TableRequest;
import io.confluent.flink.apiserver.client.model.SqlV1TableRequestList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SqlV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SqlV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public SqlV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createSqlV1DatabaseCall(String environment, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1DatabaseValidateBeforeCall(String environment, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1Database(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1Database(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling createSqlV1Database(Async)");
        }
        return this.createSqlV1DatabaseCall(environment, org, sqlV1Database, _callback);
    }

    public SqlV1Database createSqlV1Database(String environment, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.createSqlV1DatabaseWithHttpInfo(environment, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> createSqlV1DatabaseWithHttpInfo(String environment, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.createSqlV1DatabaseValidateBeforeCall(environment, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1DatabaseAsync(String environment, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1DatabaseValidateBeforeCall(environment, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV1SQLJobCall(String environment, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1SQLJobValidateBeforeCall(String environment, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1SQLJob(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling createSqlV1SQLJob(Async)");
        }
        return this.createSqlV1SQLJobCall(environment, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob createSqlV1SQLJob(String environment, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.createSqlV1SQLJobWithHttpInfo(environment, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> createSqlV1SQLJobWithHttpInfo(String environment, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.createSqlV1SQLJobValidateBeforeCall(environment, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1SQLJobAsync(String environment, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1SQLJobValidateBeforeCall(environment, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV1StatementCall(String environment, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1StatementValidateBeforeCall(String environment, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1Statement(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling createSqlV1Statement(Async)");
        }
        return this.createSqlV1StatementCall(environment, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement createSqlV1Statement(String environment, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.createSqlV1StatementWithHttpInfo(environment, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> createSqlV1StatementWithHttpInfo(String environment, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.createSqlV1StatementValidateBeforeCall(environment, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1StatementAsync(String environment, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1StatementValidateBeforeCall(environment, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV1StatementResultCall(String environment, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1StatementResult localVarPostBody = sqlV1StatementResult;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1StatementResultValidateBeforeCall(String environment, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1StatementResult(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1StatementResult(Async)");
        }
        if (sqlV1StatementResult == null) {
            throw new ApiException("Missing the required parameter 'sqlV1StatementResult' when calling createSqlV1StatementResult(Async)");
        }
        return this.createSqlV1StatementResultCall(environment, org, sqlV1StatementResult, _callback);
    }

    public SqlV1StatementResult createSqlV1StatementResult(String environment, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.createSqlV1StatementResultWithHttpInfo(environment, org, sqlV1StatementResult);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> createSqlV1StatementResultWithHttpInfo(String environment, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        Call localVarCall = this.createSqlV1StatementResultValidateBeforeCall(environment, org, sqlV1StatementResult, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1StatementResultAsync(String environment, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1StatementResultValidateBeforeCall(environment, org, sqlV1StatementResult, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV1TableCall(String environment, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1TableValidateBeforeCall(String environment, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1Table(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1Table(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling createSqlV1Table(Async)");
        }
        return this.createSqlV1TableCall(environment, org, sqlV1Table, _callback);
    }

    public SqlV1Table createSqlV1Table(String environment, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.createSqlV1TableWithHttpInfo(environment, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> createSqlV1TableWithHttpInfo(String environment, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.createSqlV1TableValidateBeforeCall(environment, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1TableAsync(String environment, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1TableValidateBeforeCall(environment, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSqlV1TableRequestCall(String environment, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSqlV1TableRequestValidateBeforeCall(String environment, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createSqlV1TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createSqlV1TableRequest(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling createSqlV1TableRequest(Async)");
        }
        return this.createSqlV1TableRequestCall(environment, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest createSqlV1TableRequest(String environment, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.createSqlV1TableRequestWithHttpInfo(environment, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> createSqlV1TableRequestWithHttpInfo(String environment, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.createSqlV1TableRequestValidateBeforeCall(environment, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSqlV1TableRequestAsync(String environment, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.createSqlV1TableRequestValidateBeforeCall(environment, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1DatabaseCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1DatabaseValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1Database(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1Database(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1Database(Async)");
        }
        return this.deleteSqlV1DatabaseCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1Database deleteSqlV1Database(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.deleteSqlV1DatabaseWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> deleteSqlV1DatabaseWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1DatabaseValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1DatabaseAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1DatabaseValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1SQLJobCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1SQLJobValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1SQLJob(Async)");
        }
        return this.deleteSqlV1SQLJobCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1SQLJob deleteSqlV1SQLJob(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.deleteSqlV1SQLJobWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> deleteSqlV1SQLJobWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1SQLJobAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1SQLJobValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1StatementCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1StatementValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1Statement(Async)");
        }
        return this.deleteSqlV1StatementCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1Statement deleteSqlV1Statement(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.deleteSqlV1StatementWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> deleteSqlV1StatementWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1StatementAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1StatementValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1StatementResultCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1StatementResultValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1StatementResult(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1StatementResult(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1StatementResult(Async)");
        }
        return this.deleteSqlV1StatementResultCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1StatementResult deleteSqlV1StatementResult(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.deleteSqlV1StatementResultWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> deleteSqlV1StatementResultWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1StatementResultValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1StatementResultAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1StatementResultValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1TableCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1TableValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1Table(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1Table(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1Table(Async)");
        }
        return this.deleteSqlV1TableCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1Table deleteSqlV1Table(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.deleteSqlV1TableWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> deleteSqlV1TableWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1TableValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1TableAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1TableValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSqlV1TableRequestCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSqlV1TableRequestValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteSqlV1TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteSqlV1TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteSqlV1TableRequest(Async)");
        }
        return this.deleteSqlV1TableRequestCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public SqlV1TableRequest deleteSqlV1TableRequest(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.deleteSqlV1TableRequestWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> deleteSqlV1TableRequestWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteSqlV1TableRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSqlV1TableRequestAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.deleteSqlV1TableRequestValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1DatabasesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1DatabasesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1Databases(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1Databases(Async)");
        }
        return this.listSqlV1DatabasesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1DatabaseList listSqlV1Databases(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1DatabaseList> localVarResp = this.listSqlV1DatabasesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1DatabaseList> listSqlV1DatabasesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1DatabasesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1DatabaseList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1DatabasesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1DatabaseList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1DatabasesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1DatabaseList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1DatabasesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/databases".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1DatabasesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1DatabasesForAllEnvironments(Async)");
        }
        return this.listSqlV1DatabasesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1DatabaseList listSqlV1DatabasesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1DatabaseList> localVarResp = this.listSqlV1DatabasesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1DatabaseList> listSqlV1DatabasesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1DatabasesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1DatabaseList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1DatabasesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1DatabaseList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1DatabasesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1DatabaseList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1SQLJobsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1SQLJobsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1SQLJobs(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1SQLJobs(Async)");
        }
        return this.listSqlV1SQLJobsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1SQLJobList listSqlV1SQLJobs(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1SQLJobList> localVarResp = this.listSqlV1SQLJobsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJobList> listSqlV1SQLJobsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1SQLJobsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1SQLJobsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1SQLJobsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/sqljobs".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1SQLJobsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1SQLJobsForAllEnvironments(Async)");
        }
        return this.listSqlV1SQLJobsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1SQLJobList listSqlV1SQLJobsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1SQLJobList> localVarResp = this.listSqlV1SQLJobsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJobList> listSqlV1SQLJobsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJobList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1SQLJobsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1SQLJobList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1SQLJobsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJobList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1StatementResultsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1StatementResultsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1StatementResults(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1StatementResults(Async)");
        }
        return this.listSqlV1StatementResultsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1StatementResultList listSqlV1StatementResults(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1StatementResultList> localVarResp = this.listSqlV1StatementResultsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResultList> listSqlV1StatementResultsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1StatementResultsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResultList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1StatementResultsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1StatementResultList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1StatementResultsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResultList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1StatementResultsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/statementresults".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1StatementResultsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1StatementResultsForAllEnvironments(Async)");
        }
        return this.listSqlV1StatementResultsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1StatementResultList listSqlV1StatementResultsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1StatementResultList> localVarResp = this.listSqlV1StatementResultsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResultList> listSqlV1StatementResultsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1StatementResultsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResultList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1StatementResultsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1StatementResultList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1StatementResultsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResultList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1StatementsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1StatementsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1Statements(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1Statements(Async)");
        }
        return this.listSqlV1StatementsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1StatementList listSqlV1Statements(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1StatementList> localVarResp = this.listSqlV1StatementsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementList> listSqlV1StatementsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1StatementsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1StatementsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1StatementsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/statements".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1StatementsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1StatementsForAllEnvironments(Async)");
        }
        return this.listSqlV1StatementsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1StatementList listSqlV1StatementsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1StatementList> localVarResp = this.listSqlV1StatementsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementList> listSqlV1StatementsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1StatementsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1StatementList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1StatementsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1TableRequestsCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1TableRequestsValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1TableRequests(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1TableRequests(Async)");
        }
        return this.listSqlV1TableRequestsCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1TableRequestList listSqlV1TableRequests(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1TableRequestList> localVarResp = this.listSqlV1TableRequestsWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequestList> listSqlV1TableRequestsWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1TableRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1TableRequestsAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1TableRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1TableRequestsValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1TableRequestsForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/tablerequests".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1TableRequestsForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1TableRequestsForAllEnvironments(Async)");
        }
        return this.listSqlV1TableRequestsForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1TableRequestList listSqlV1TableRequestsForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1TableRequestList> localVarResp = this.listSqlV1TableRequestsForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequestList> listSqlV1TableRequestsForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1TableRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequestList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1TableRequestsForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1TableRequestList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1TableRequestsForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequestList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1TablesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1TablesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listSqlV1Tables(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1Tables(Async)");
        }
        return this.listSqlV1TablesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1TableList listSqlV1Tables(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1TableList> localVarResp = this.listSqlV1TablesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableList> listSqlV1TablesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1TablesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1TableList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1TablesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1TableList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1TablesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSqlV1TablesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/tables".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSqlV1TablesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listSqlV1TablesForAllEnvironments(Async)");
        }
        return this.listSqlV1TablesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public SqlV1TableList listSqlV1TablesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<SqlV1TableList> localVarResp = this.listSqlV1TablesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableList> listSqlV1TablesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listSqlV1TablesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<SqlV1TableList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSqlV1TablesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<SqlV1TableList> _callback) throws ApiException {
        Call localVarCall = this.listSqlV1TablesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1DatabaseCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1DatabaseValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1Database(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1Database(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1Database(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling patchSqlV1Database(Async)");
        }
        return this.patchSqlV1DatabaseCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database patchSqlV1Database(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.patchSqlV1DatabaseWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> patchSqlV1DatabaseWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1DatabaseAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1DatabaseFinalizersCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1DatabaseFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1DatabaseFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1DatabaseFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1DatabaseFinalizers(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling patchSqlV1DatabaseFinalizers(Async)");
        }
        return this.patchSqlV1DatabaseFinalizersCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database patchSqlV1DatabaseFinalizers(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.patchSqlV1DatabaseFinalizersWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> patchSqlV1DatabaseFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1DatabaseFinalizersAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1DatabaseStatusCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1DatabaseStatusValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1DatabaseStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1DatabaseStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1DatabaseStatus(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling patchSqlV1DatabaseStatus(Async)");
        }
        return this.patchSqlV1DatabaseStatusCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database patchSqlV1DatabaseStatus(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.patchSqlV1DatabaseStatusWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> patchSqlV1DatabaseStatusWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1DatabaseStatusAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1SQLJobCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1SQLJobValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1SQLJob(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling patchSqlV1SQLJob(Async)");
        }
        return this.patchSqlV1SQLJobCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob patchSqlV1SQLJob(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.patchSqlV1SQLJobWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> patchSqlV1SQLJobWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1SQLJobAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1SQLJobFinalizersCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1SQLJobFinalizers(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling patchSqlV1SQLJobFinalizers(Async)");
        }
        return this.patchSqlV1SQLJobFinalizersCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob patchSqlV1SQLJobFinalizers(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.patchSqlV1SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> patchSqlV1SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1SQLJobFinalizersAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1SQLJobStatusCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1SQLJobStatus(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling patchSqlV1SQLJobStatus(Async)");
        }
        return this.patchSqlV1SQLJobStatusCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob patchSqlV1SQLJobStatus(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.patchSqlV1SQLJobStatusWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> patchSqlV1SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1SQLJobStatusAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1StatementCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1StatementValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1Statement(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling patchSqlV1Statement(Async)");
        }
        return this.patchSqlV1StatementCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement patchSqlV1Statement(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.patchSqlV1StatementWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> patchSqlV1StatementWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1StatementAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1StatementFinalizersCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1StatementFinalizers(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling patchSqlV1StatementFinalizers(Async)");
        }
        return this.patchSqlV1StatementFinalizersCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement patchSqlV1StatementFinalizers(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.patchSqlV1StatementFinalizersWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> patchSqlV1StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1StatementFinalizersAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1StatementResultCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1StatementResult localVarPostBody = sqlV1StatementResult;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1StatementResultValidateBeforeCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1StatementResult(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1StatementResult(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1StatementResult(Async)");
        }
        if (sqlV1StatementResult == null) {
            throw new ApiException("Missing the required parameter 'sqlV1StatementResult' when calling patchSqlV1StatementResult(Async)");
        }
        return this.patchSqlV1StatementResultCall(environment, name, org, sqlV1StatementResult, _callback);
    }

    public SqlV1StatementResult patchSqlV1StatementResult(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.patchSqlV1StatementResultWithHttpInfo(environment, name, org, sqlV1StatementResult);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> patchSqlV1StatementResultWithHttpInfo(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementResultValidateBeforeCall(environment, name, org, sqlV1StatementResult, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1StatementResultAsync(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementResultValidateBeforeCall(environment, name, org, sqlV1StatementResult, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1StatementResultFinalizersCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1StatementResult localVarPostBody = sqlV1StatementResult;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1StatementResultFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1StatementResultFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1StatementResultFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1StatementResultFinalizers(Async)");
        }
        if (sqlV1StatementResult == null) {
            throw new ApiException("Missing the required parameter 'sqlV1StatementResult' when calling patchSqlV1StatementResultFinalizers(Async)");
        }
        return this.patchSqlV1StatementResultFinalizersCall(environment, name, org, sqlV1StatementResult, _callback);
    }

    public SqlV1StatementResult patchSqlV1StatementResultFinalizers(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.patchSqlV1StatementResultFinalizersWithHttpInfo(environment, name, org, sqlV1StatementResult);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> patchSqlV1StatementResultFinalizersWithHttpInfo(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, sqlV1StatementResult, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1StatementResultFinalizersAsync(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, sqlV1StatementResult, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1StatementStatusCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1StatementStatus(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling patchSqlV1StatementStatus(Async)");
        }
        return this.patchSqlV1StatementStatusCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement patchSqlV1StatementStatus(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.patchSqlV1StatementStatusWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> patchSqlV1StatementStatusWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementStatusValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1StatementStatusAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1StatementStatusValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1Table(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1Table(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1Table(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling patchSqlV1Table(Async)");
        }
        return this.patchSqlV1TableCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table patchSqlV1Table(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.patchSqlV1TableWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> patchSqlV1TableWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.patchSqlV1TableValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableFinalizersCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1TableFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1TableFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1TableFinalizers(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling patchSqlV1TableFinalizers(Async)");
        }
        return this.patchSqlV1TableFinalizersCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table patchSqlV1TableFinalizers(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.patchSqlV1TableFinalizersWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> patchSqlV1TableFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.patchSqlV1TableFinalizersValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableFinalizersAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableFinalizersValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableRequestCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableRequestValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1TableRequest(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling patchSqlV1TableRequest(Async)");
        }
        return this.patchSqlV1TableRequestCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest patchSqlV1TableRequest(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.patchSqlV1TableRequestWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> patchSqlV1TableRequestWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableRequestAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableRequestFinalizersCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1TableRequestFinalizers(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling patchSqlV1TableRequestFinalizers(Async)");
        }
        return this.patchSqlV1TableRequestFinalizersCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest patchSqlV1TableRequestFinalizers(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.patchSqlV1TableRequestFinalizersWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> patchSqlV1TableRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableRequestFinalizersAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableRequestStatusCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1TableRequestStatus(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling patchSqlV1TableRequestStatus(Async)");
        }
        return this.patchSqlV1TableRequestStatusCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest patchSqlV1TableRequestStatus(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.patchSqlV1TableRequestStatusWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> patchSqlV1TableRequestStatusWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableRequestStatusAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSqlV1TableStatusCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSqlV1TableStatusValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchSqlV1TableStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchSqlV1TableStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchSqlV1TableStatus(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling patchSqlV1TableStatus(Async)");
        }
        return this.patchSqlV1TableStatusCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table patchSqlV1TableStatus(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.patchSqlV1TableStatusWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> patchSqlV1TableStatusWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.patchSqlV1TableStatusValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSqlV1TableStatusAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.patchSqlV1TableStatusValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1DatabaseCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1DatabaseValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1Database(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1Database(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1Database(Async)");
        }
        return this.readSqlV1DatabaseCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Database readSqlV1Database(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.readSqlV1DatabaseWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> readSqlV1DatabaseWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1DatabaseAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1DatabaseFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1DatabaseFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1DatabaseFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1DatabaseFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1DatabaseFinalizers(Async)");
        }
        return this.readSqlV1DatabaseFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Database readSqlV1DatabaseFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.readSqlV1DatabaseFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> readSqlV1DatabaseFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1DatabaseFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1DatabaseStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1DatabaseStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1DatabaseStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1DatabaseStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1DatabaseStatus(Async)");
        }
        return this.readSqlV1DatabaseStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Database readSqlV1DatabaseStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.readSqlV1DatabaseStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> readSqlV1DatabaseStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1DatabaseStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1SQLJobCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1SQLJobValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1SQLJob(Async)");
        }
        return this.readSqlV1SQLJobCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1SQLJob readSqlV1SQLJob(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.readSqlV1SQLJobWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> readSqlV1SQLJobWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1SQLJobAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1SQLJobFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1SQLJobFinalizers(Async)");
        }
        return this.readSqlV1SQLJobFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1SQLJob readSqlV1SQLJobFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.readSqlV1SQLJobFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> readSqlV1SQLJobFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1SQLJobFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1SQLJobStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1SQLJobStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1SQLJobStatus(Async)");
        }
        return this.readSqlV1SQLJobStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1SQLJob readSqlV1SQLJobStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.readSqlV1SQLJobStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> readSqlV1SQLJobStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1SQLJobStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1StatementCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1StatementValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1Statement(Async)");
        }
        return this.readSqlV1StatementCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Statement readSqlV1Statement(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.readSqlV1StatementWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> readSqlV1StatementWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1StatementValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1StatementAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1StatementValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1StatementFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1StatementFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1StatementFinalizers(Async)");
        }
        return this.readSqlV1StatementFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Statement readSqlV1StatementFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.readSqlV1StatementFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> readSqlV1StatementFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1StatementFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1StatementResultCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1StatementResultValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1StatementResult(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1StatementResult(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1StatementResult(Async)");
        }
        return this.readSqlV1StatementResultCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1StatementResult readSqlV1StatementResult(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.readSqlV1StatementResultWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> readSqlV1StatementResultWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1StatementResultValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1StatementResultAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1StatementResultValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1StatementResultFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1StatementResultFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1StatementResultFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1StatementResultFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1StatementResultFinalizers(Async)");
        }
        return this.readSqlV1StatementResultFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1StatementResult readSqlV1StatementResultFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.readSqlV1StatementResultFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> readSqlV1StatementResultFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1StatementResultFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1StatementStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1StatementStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1StatementStatus(Async)");
        }
        return this.readSqlV1StatementStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Statement readSqlV1StatementStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.readSqlV1StatementStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> readSqlV1StatementStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1StatementStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1StatementStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1Table(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1Table(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1Table(Async)");
        }
        return this.readSqlV1TableCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Table readSqlV1Table(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.readSqlV1TableWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> readSqlV1TableWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1TableFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1TableFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1TableFinalizers(Async)");
        }
        return this.readSqlV1TableFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Table readSqlV1TableFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.readSqlV1TableFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> readSqlV1TableFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableRequestCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableRequestValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1TableRequest(Async)");
        }
        return this.readSqlV1TableRequestCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1TableRequest readSqlV1TableRequest(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.readSqlV1TableRequestWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> readSqlV1TableRequestWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableRequestAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableRequestFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1TableRequestFinalizers(Async)");
        }
        return this.readSqlV1TableRequestFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1TableRequest readSqlV1TableRequestFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.readSqlV1TableRequestFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> readSqlV1TableRequestFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableRequestFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableRequestStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableRequestStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1TableRequestStatus(Async)");
        }
        return this.readSqlV1TableRequestStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1TableRequest readSqlV1TableRequestStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.readSqlV1TableRequestStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> readSqlV1TableRequestStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableRequestStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readSqlV1TableStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readSqlV1TableStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readSqlV1TableStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readSqlV1TableStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readSqlV1TableStatus(Async)");
        }
        return this.readSqlV1TableStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public SqlV1Table readSqlV1TableStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.readSqlV1TableStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> readSqlV1TableStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readSqlV1TableStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readSqlV1TableStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.readSqlV1TableStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1DatabaseCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1DatabaseValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1Database(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1Database(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1Database(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling updateSqlV1Database(Async)");
        }
        return this.updateSqlV1DatabaseCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database updateSqlV1Database(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.updateSqlV1DatabaseWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> updateSqlV1DatabaseWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1DatabaseAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1DatabaseFinalizersCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1DatabaseFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1DatabaseFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1DatabaseFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1DatabaseFinalizers(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling updateSqlV1DatabaseFinalizers(Async)");
        }
        return this.updateSqlV1DatabaseFinalizersCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database updateSqlV1DatabaseFinalizers(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.updateSqlV1DatabaseFinalizersWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> updateSqlV1DatabaseFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1DatabaseFinalizersAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseFinalizersValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1DatabaseStatusCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Database localVarPostBody = sqlV1Database;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/databases/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1DatabaseStatusValidateBeforeCall(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1DatabaseStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1DatabaseStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1DatabaseStatus(Async)");
        }
        if (sqlV1Database == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Database' when calling updateSqlV1DatabaseStatus(Async)");
        }
        return this.updateSqlV1DatabaseStatusCall(environment, name, org, sqlV1Database, _callback);
    }

    public SqlV1Database updateSqlV1DatabaseStatus(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        ApiResponse<SqlV1Database> localVarResp = this.updateSqlV1DatabaseStatusWithHttpInfo(environment, name, org, sqlV1Database);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Database> updateSqlV1DatabaseStatusWithHttpInfo(String environment, String name, String org, SqlV1Database sqlV1Database) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, sqlV1Database, null);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1DatabaseStatusAsync(String environment, String name, String org, SqlV1Database sqlV1Database, ApiCallback<SqlV1Database> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1DatabaseStatusValidateBeforeCall(environment, name, org, sqlV1Database, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Database>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1SQLJobCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1SQLJobValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1SQLJob(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1SQLJob(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1SQLJob(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling updateSqlV1SQLJob(Async)");
        }
        return this.updateSqlV1SQLJobCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob updateSqlV1SQLJob(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.updateSqlV1SQLJobWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> updateSqlV1SQLJobWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1SQLJobAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1SQLJobFinalizersCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1SQLJobFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1SQLJobFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1SQLJobFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1SQLJobFinalizers(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling updateSqlV1SQLJobFinalizers(Async)");
        }
        return this.updateSqlV1SQLJobFinalizersCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob updateSqlV1SQLJobFinalizers(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.updateSqlV1SQLJobFinalizersWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> updateSqlV1SQLJobFinalizersWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1SQLJobFinalizersAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobFinalizersValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1SQLJobStatusCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1SQLJob localVarPostBody = sqlV1SQLJob;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/sqljobs/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1SQLJobStatusValidateBeforeCall(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1SQLJobStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1SQLJobStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1SQLJobStatus(Async)");
        }
        if (sqlV1SQLJob == null) {
            throw new ApiException("Missing the required parameter 'sqlV1SQLJob' when calling updateSqlV1SQLJobStatus(Async)");
        }
        return this.updateSqlV1SQLJobStatusCall(environment, name, org, sqlV1SQLJob, _callback);
    }

    public SqlV1SQLJob updateSqlV1SQLJobStatus(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        ApiResponse<SqlV1SQLJob> localVarResp = this.updateSqlV1SQLJobStatusWithHttpInfo(environment, name, org, sqlV1SQLJob);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1SQLJob> updateSqlV1SQLJobStatusWithHttpInfo(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, sqlV1SQLJob, null);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1SQLJobStatusAsync(String environment, String name, String org, SqlV1SQLJob sqlV1SQLJob, ApiCallback<SqlV1SQLJob> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1SQLJobStatusValidateBeforeCall(environment, name, org, sqlV1SQLJob, _callback);
        Type localVarReturnType = new TypeToken<SqlV1SQLJob>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1StatementCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1StatementValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1Statement(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1Statement(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1Statement(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling updateSqlV1Statement(Async)");
        }
        return this.updateSqlV1StatementCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement updateSqlV1Statement(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.updateSqlV1StatementWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> updateSqlV1StatementWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1StatementAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1StatementFinalizersCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1StatementFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1StatementFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1StatementFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1StatementFinalizers(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling updateSqlV1StatementFinalizers(Async)");
        }
        return this.updateSqlV1StatementFinalizersCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement updateSqlV1StatementFinalizers(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.updateSqlV1StatementFinalizersWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> updateSqlV1StatementFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1StatementFinalizersAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementFinalizersValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1StatementResultCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1StatementResult localVarPostBody = sqlV1StatementResult;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1StatementResultValidateBeforeCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1StatementResult(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1StatementResult(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1StatementResult(Async)");
        }
        if (sqlV1StatementResult == null) {
            throw new ApiException("Missing the required parameter 'sqlV1StatementResult' when calling updateSqlV1StatementResult(Async)");
        }
        return this.updateSqlV1StatementResultCall(environment, name, org, sqlV1StatementResult, _callback);
    }

    public SqlV1StatementResult updateSqlV1StatementResult(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.updateSqlV1StatementResultWithHttpInfo(environment, name, org, sqlV1StatementResult);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> updateSqlV1StatementResultWithHttpInfo(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementResultValidateBeforeCall(environment, name, org, sqlV1StatementResult, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1StatementResultAsync(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementResultValidateBeforeCall(environment, name, org, sqlV1StatementResult, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1StatementResultFinalizersCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1StatementResult localVarPostBody = sqlV1StatementResult;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statementresults/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1StatementResultFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1StatementResultFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1StatementResultFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1StatementResultFinalizers(Async)");
        }
        if (sqlV1StatementResult == null) {
            throw new ApiException("Missing the required parameter 'sqlV1StatementResult' when calling updateSqlV1StatementResultFinalizers(Async)");
        }
        return this.updateSqlV1StatementResultFinalizersCall(environment, name, org, sqlV1StatementResult, _callback);
    }

    public SqlV1StatementResult updateSqlV1StatementResultFinalizers(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        ApiResponse<SqlV1StatementResult> localVarResp = this.updateSqlV1StatementResultFinalizersWithHttpInfo(environment, name, org, sqlV1StatementResult);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1StatementResult> updateSqlV1StatementResultFinalizersWithHttpInfo(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, sqlV1StatementResult, null);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1StatementResultFinalizersAsync(String environment, String name, String org, SqlV1StatementResult sqlV1StatementResult, ApiCallback<SqlV1StatementResult> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementResultFinalizersValidateBeforeCall(environment, name, org, sqlV1StatementResult, _callback);
        Type localVarReturnType = new TypeToken<SqlV1StatementResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1StatementStatusCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Statement localVarPostBody = sqlV1Statement;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/statements/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1StatementStatusValidateBeforeCall(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1StatementStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1StatementStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1StatementStatus(Async)");
        }
        if (sqlV1Statement == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Statement' when calling updateSqlV1StatementStatus(Async)");
        }
        return this.updateSqlV1StatementStatusCall(environment, name, org, sqlV1Statement, _callback);
    }

    public SqlV1Statement updateSqlV1StatementStatus(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        ApiResponse<SqlV1Statement> localVarResp = this.updateSqlV1StatementStatusWithHttpInfo(environment, name, org, sqlV1Statement);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Statement> updateSqlV1StatementStatusWithHttpInfo(String environment, String name, String org, SqlV1Statement sqlV1Statement) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementStatusValidateBeforeCall(environment, name, org, sqlV1Statement, null);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1StatementStatusAsync(String environment, String name, String org, SqlV1Statement sqlV1Statement, ApiCallback<SqlV1Statement> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1StatementStatusValidateBeforeCall(environment, name, org, sqlV1Statement, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Statement>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1Table(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1Table(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1Table(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling updateSqlV1Table(Async)");
        }
        return this.updateSqlV1TableCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table updateSqlV1Table(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.updateSqlV1TableWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> updateSqlV1TableWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.updateSqlV1TableValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableFinalizersCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1TableFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1TableFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1TableFinalizers(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling updateSqlV1TableFinalizers(Async)");
        }
        return this.updateSqlV1TableFinalizersCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table updateSqlV1TableFinalizers(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.updateSqlV1TableFinalizersWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> updateSqlV1TableFinalizersWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.updateSqlV1TableFinalizersValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableFinalizersAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableFinalizersValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableRequestCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableRequestValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1TableRequest(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1TableRequest(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1TableRequest(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling updateSqlV1TableRequest(Async)");
        }
        return this.updateSqlV1TableRequestCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest updateSqlV1TableRequest(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.updateSqlV1TableRequestWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> updateSqlV1TableRequestWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableRequestAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableRequestFinalizersCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableRequestFinalizersValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1TableRequestFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1TableRequestFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1TableRequestFinalizers(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling updateSqlV1TableRequestFinalizers(Async)");
        }
        return this.updateSqlV1TableRequestFinalizersCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest updateSqlV1TableRequestFinalizers(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.updateSqlV1TableRequestFinalizersWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> updateSqlV1TableRequestFinalizersWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableRequestFinalizersAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestFinalizersValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableRequestStatusCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1TableRequest localVarPostBody = sqlV1TableRequest;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tablerequests/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableRequestStatusValidateBeforeCall(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1TableRequestStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1TableRequestStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1TableRequestStatus(Async)");
        }
        if (sqlV1TableRequest == null) {
            throw new ApiException("Missing the required parameter 'sqlV1TableRequest' when calling updateSqlV1TableRequestStatus(Async)");
        }
        return this.updateSqlV1TableRequestStatusCall(environment, name, org, sqlV1TableRequest, _callback);
    }

    public SqlV1TableRequest updateSqlV1TableRequestStatus(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        ApiResponse<SqlV1TableRequest> localVarResp = this.updateSqlV1TableRequestStatusWithHttpInfo(environment, name, org, sqlV1TableRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1TableRequest> updateSqlV1TableRequestStatusWithHttpInfo(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, sqlV1TableRequest, null);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableRequestStatusAsync(String environment, String name, String org, SqlV1TableRequest sqlV1TableRequest, ApiCallback<SqlV1TableRequest> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableRequestStatusValidateBeforeCall(environment, name, org, sqlV1TableRequest, _callback);
        Type localVarReturnType = new TypeToken<SqlV1TableRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSqlV1TableStatusCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SqlV1Table localVarPostBody = sqlV1Table;
        String localVarPath = "/apis/sql/v1/orgs/{org}/environments/{environment}/tables/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSqlV1TableStatusValidateBeforeCall(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateSqlV1TableStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateSqlV1TableStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateSqlV1TableStatus(Async)");
        }
        if (sqlV1Table == null) {
            throw new ApiException("Missing the required parameter 'sqlV1Table' when calling updateSqlV1TableStatus(Async)");
        }
        return this.updateSqlV1TableStatusCall(environment, name, org, sqlV1Table, _callback);
    }

    public SqlV1Table updateSqlV1TableStatus(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        ApiResponse<SqlV1Table> localVarResp = this.updateSqlV1TableStatusWithHttpInfo(environment, name, org, sqlV1Table);
        return localVarResp.getData();
    }

    public ApiResponse<SqlV1Table> updateSqlV1TableStatusWithHttpInfo(String environment, String name, String org, SqlV1Table sqlV1Table) throws ApiException {
        Call localVarCall = this.updateSqlV1TableStatusValidateBeforeCall(environment, name, org, sqlV1Table, null);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSqlV1TableStatusAsync(String environment, String name, String org, SqlV1Table sqlV1Table, ApiCallback<SqlV1Table> _callback) throws ApiException {
        Call localVarCall = this.updateSqlV1TableStatusValidateBeforeCall(environment, name, org, sqlV1Table, _callback);
        Type localVarReturnType = new TypeToken<SqlV1Table>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

