/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.SecretsV1SecurePayload;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecretsV1SecretSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PLAIN_TEXT = "plainText";
    @SerializedName(value="plainText")
    private byte[] plainText;
    public static final String SERIALIZED_NAME_SECRET_TYPE = "secretType";
    @SerializedName(value="secretType")
    private String secretType = "";
    public static final String SERIALIZED_NAME_SECRET_VERSION = "secretVersion";
    @SerializedName(value="secretVersion")
    private String secretVersion = "";
    public static final String SERIALIZED_NAME_SECURE_PAYLOAD = "securePayload";
    @SerializedName(value="securePayload")
    private SecretsV1SecurePayload securePayload;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SecretsV1SecretSpec plainText(byte[] plainText) {
        this.plainText = plainText;
        return this;
    }

    @Nullable
    public byte[] getPlainText() {
        return this.plainText;
    }

    public void setPlainText(byte[] plainText) {
        this.plainText = plainText;
    }

    public SecretsV1SecretSpec secretType(String secretType) {
        this.secretType = secretType;
        return this;
    }

    @Nonnull
    public String getSecretType() {
        return this.secretType;
    }

    public void setSecretType(String secretType) {
        this.secretType = secretType;
    }

    public SecretsV1SecretSpec secretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Nonnull
    public String getSecretVersion() {
        return this.secretVersion;
    }

    public void setSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
    }

    public SecretsV1SecretSpec securePayload(SecretsV1SecurePayload securePayload) {
        this.securePayload = securePayload;
        return this;
    }

    @Nonnull
    public SecretsV1SecurePayload getSecurePayload() {
        return this.securePayload;
    }

    public void setSecurePayload(SecretsV1SecurePayload securePayload) {
        this.securePayload = securePayload;
    }

    public SecretsV1SecretSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretsV1SecretSpec secretsV1SecretSpec = (SecretsV1SecretSpec)o;
        return Arrays.equals(this.plainText, secretsV1SecretSpec.plainText) && Objects.equals(this.secretType, secretsV1SecretSpec.secretType) && Objects.equals(this.secretVersion, secretsV1SecretSpec.secretVersion) && Objects.equals(this.securePayload, secretsV1SecretSpec.securePayload) && Objects.equals(this.additionalProperties, secretsV1SecretSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.plainText), this.secretType, this.secretVersion, this.securePayload, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecretsV1SecretSpec {\n");
        sb.append("    plainText: ").append(this.toIndentedString(this.plainText)).append("\n");
        sb.append("    secretType: ").append(this.toIndentedString(this.secretType)).append("\n");
        sb.append("    secretVersion: ").append(this.toIndentedString(this.secretVersion)).append("\n");
        sb.append("    securePayload: ").append(this.toIndentedString(this.securePayload)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SecretsV1SecretSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SECRET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secretType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SECRET_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secretVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET_VERSION).toString()));
        }
    }

    public static SecretsV1SecretSpec fromJson(String jsonString) throws IOException {
        return (SecretsV1SecretSpec)JSON.getGson().fromJson(jsonString, SecretsV1SecretSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PLAIN_TEXT);
        openapiFields.add(SERIALIZED_NAME_SECRET_TYPE);
        openapiFields.add(SERIALIZED_NAME_SECRET_VERSION);
        openapiFields.add(SERIALIZED_NAME_SECURE_PAYLOAD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SECRET_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_SECRET_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_SECURE_PAYLOAD);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SecretsV1SecretSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SecretsV1SecretSpec.class));
            return new TypeAdapter<SecretsV1SecretSpec>(){

                public void write(JsonWriter out, SecretsV1SecretSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SecretsV1SecretSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SecretsV1SecretSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SecretsV1SecretSpec instance = (SecretsV1SecretSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

