/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.util.LicenseAddonTypes;
import io.confluent.license.util.StringUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwt.JwtClaims;

public class CSFLELicense
extends License {
    private final Time clock;

    public CSFLELicense(JwtClaims claims, Time clock, String serialized) {
        super(claims, clock, serialized, null);
        this.clock = clock;
    }

    @Override
    public String toString() {
        if (this.jwtClaims() == null) {
            return "Invalid License";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getString());
        if (!StringUtils.isBlank(this.subject())) {
            sb.append("for ").append(this.subject());
        }
        try {
            if (this.isExpired()) {
                sb.append(" expired on ").append(this.expirationDateString());
            } else {
                long remainingMillis = this.timeRemaining(TimeUnit.MILLISECONDS);
                long daysRemaining = TimeUnit.MILLISECONDS.toDays(remainingMillis);
                sb.append(" expires in ").append(daysRemaining).append(" days on ").append(this.expirationDateString());
            }
        }
        catch (Throwable t) {
            sb.append(" with invalid expiration");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public long timeRemaining(TimeUnit unit) {
        long timeRemainingMillis = this.expirationMillis() - this.clock.milliseconds();
        return unit.convert(timeRemainingMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isExpired() {
        return this.isCSFLE() && this.timeRemaining(TimeUnit.MILLISECONDS) <= 0L;
    }

    @Override
    protected long expirationMillis() {
        Map csfleMap;
        Map addon;
        Object csfleAddon;
        Object claimValue = this.jwtClaims().getClaimValue("addon");
        if (claimValue instanceof Map && (csfleAddon = (addon = (Map)claimValue).get(LicenseAddonTypes.CSFLE.getValue())) instanceof Map && (csfleMap = (Map)csfleAddon).containsKey("exp")) {
            return (Long)csfleMap.get("exp") * 1000L;
        }
        return Long.MIN_VALUE;
    }

    private String getString() {
        if (this.isCSFLE()) {
            return "CSFLE Addon License ";
        }
        return "Unknown License ";
    }

    @Override
    public boolean isValid() {
        return this.isCSFLE() && !super.isExpired() && !this.isExpired();
    }

    @Override
    public License.Type type() {
        if (this.isCSFLE()) {
            return License.Type.CSFLE;
        }
        throw new InvalidLicenseException("Invalid license type");
    }

    public boolean isCSFLE() {
        return this.hasCSFLEAddonLicense();
    }

    @Override
    public boolean isRenewalOf(License other) {
        if (!(other instanceof CSFLELicense)) {
            return false;
        }
        CSFLELicense otherLicense = (CSFLELicense)other;
        return this.hasMatchingClaims(other, new String[0]) && otherLicense.updatedAtMillis() < this.updatedAtMillis() && otherLicense.expirationMillis() < this.expirationMillis();
    }

    @Override
    public boolean expiresBefore(License other) {
        if (other == null) {
            return false;
        }
        return this.expirationMillis() < other.expirationMillis();
    }

    private boolean hasCSFLEAddonLicense() {
        Map addon;
        Object csfleAddon;
        Object claimValue = this.jwtClaims().getClaimValue("addon");
        if (claimValue instanceof Map && (csfleAddon = (addon = (Map)claimValue).get(LicenseAddonTypes.CSFLE.getValue())) instanceof Map) {
            Map csfleMap = (Map)csfleAddon;
            return csfleMap.containsKey("exp") && csfleMap.containsKey("iat");
        }
        return false;
    }
}

