/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.IdentityMetadata;

public enum CallingResourceIdentityType {
    DEFAULT(0, "default"),
    CONFLUENT_TABLEFLOW(1, "tableflow"),
    CONFLUENT_FLINK(2, "default");

    private static final Map<Byte, CallingResourceIdentityType> INDEXED_BY_ID;
    private final byte id;
    private final String applicationIdentity;

    private CallingResourceIdentityType(byte id, String applicationIdentity) {
        this.id = id;
        this.applicationIdentity = applicationIdentity;
    }

    public byte id() {
        return this.id;
    }

    public String applicationIdentity() {
        return this.applicationIdentity;
    }

    public static CallingResourceIdentityType findById(byte id) {
        return INDEXED_BY_ID.getOrDefault(id, DEFAULT);
    }

    public static CallingResourceIdentityType fromPrincipal(MultiTenantPrincipal principal) {
        return principal.maybeGetIdentityMetadata().map(IdentityMetadata::callingResourceIdentityType).orElse(DEFAULT);
    }

    static {
        INDEXED_BY_ID = new HashMap<Byte, CallingResourceIdentityType>();
        for (CallingResourceIdentityType callingResourceIdentityType : CallingResourceIdentityType.values()) {
            INDEXED_BY_ID.put(callingResourceIdentityType.id, callingResourceIdentityType);
        }
    }
}

