/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTopicSwitchoverInfo;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ClusterLinkSwitchoverStatusDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String remoteClusterId;
    private final String localClusterId;
    private final Map<String, Optional<ClusterLinkTopicSwitchoverInfo>> topicToTopicSwitchoverInfo;
    private final ClusterLinkDescription.LinkState linkState;
    private final ClusterLinkDescription.LinkState remoteLinkState;
    private final ClusterLinkError clusterLinkError;
    private final String linkErrorMessage;
    private final ClusterLinkError remoteLinkError;
    private final String remoteLinkErrorMessage;
    private final List<ClusterLinkTaskDescription> taskDescriptions;
    private final SwitchoverType switchoverType;
    private final SwitchoverState switchoverState;

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topicToTopicSwitchoverInfo, this.linkState, this.remoteLinkState, this.clusterLinkError, this.linkErrorMessage, this.remoteLinkError, this.remoteLinkErrorMessage, this.taskDescriptions, this.switchoverType, this.switchoverState});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkSwitchoverStatusDescription that = (ClusterLinkSwitchoverStatusDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.remoteClusterId, that.remoteClusterId) && Objects.equals(this.localClusterId, that.localClusterId) && Objects.equals(this.topicToTopicSwitchoverInfo, that.topicToTopicSwitchoverInfo) && this.linkState == that.linkState && this.remoteLinkState == that.remoteLinkState && this.clusterLinkError == that.clusterLinkError && Objects.equals(this.linkErrorMessage, that.linkErrorMessage) && this.remoteLinkError == that.remoteLinkError && Objects.equals(this.remoteLinkErrorMessage, that.remoteLinkErrorMessage) && Objects.equals(this.taskDescriptions, that.taskDescriptions) && this.switchoverType == that.switchoverType && this.switchoverState == that.switchoverState;
    }

    public String toString() {
        return "ClusterLinkSwitchoverStatusDescription(linkName=" + this.linkName + ", linkId=" + String.valueOf(this.linkId) + ", remoteClusterId=" + this.remoteClusterId + ", localClusterId=" + this.localClusterId + ", topicToTopicSwitchoverInfo=" + String.valueOf(this.topicToTopicSwitchoverInfo) + ", linkState=" + String.valueOf((Object)this.linkState) + ", remoteLinkState=" + String.valueOf((Object)this.remoteLinkState) + ", clusterLinkError=" + String.valueOf((Object)this.clusterLinkError) + ", linkErrorMessage=" + this.linkErrorMessage + ", remoteLinkError=" + String.valueOf((Object)this.remoteLinkError) + ", remoteLinkErrorMessage=" + this.remoteLinkErrorMessage + ", taskDescriptions=" + String.valueOf(this.taskDescriptions) + ", switchoverType=" + String.valueOf((Object)this.switchoverType) + ", switchoverState=" + String.valueOf((Object)this.switchoverState) + ")";
    }

    public ClusterLinkSwitchoverStatusDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Map<String, Optional<ClusterLinkTopicSwitchoverInfo>> topicToTopicSwitchoverInfo, ClusterLinkDescription.LinkState linkState, ClusterLinkDescription.LinkState remoteLinkState, ClusterLinkError clusterLinkError, String linkErrorMessage, ClusterLinkError remoteLinkError, String remoteLinkErrorMessage, List<ClusterLinkTaskDescription> taskDescriptions, SwitchoverType switchoverType, SwitchoverState switchoverState) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = localClusterId;
        this.topicToTopicSwitchoverInfo = topicToTopicSwitchoverInfo;
        this.linkState = linkState;
        this.remoteLinkState = remoteLinkState;
        this.clusterLinkError = clusterLinkError;
        this.linkErrorMessage = linkErrorMessage;
        this.remoteLinkError = remoteLinkError;
        this.remoteLinkErrorMessage = remoteLinkErrorMessage;
        this.taskDescriptions = taskDescriptions;
        this.switchoverType = switchoverType;
        this.switchoverState = switchoverState;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public Map<String, Optional<ClusterLinkTopicSwitchoverInfo>> topicToTopicSwitchoverInfo() {
        return this.topicToTopicSwitchoverInfo;
    }

    public ClusterLinkDescription.LinkState linkState() {
        return this.linkState;
    }

    public ClusterLinkDescription.LinkState remoteLinkState() {
        return this.remoteLinkState;
    }

    public ClusterLinkError clusterLinkError() {
        return this.clusterLinkError;
    }

    public String linkErrorMessage() {
        return this.linkErrorMessage;
    }

    public ClusterLinkError remoteLinkError() {
        return this.remoteLinkError;
    }

    public String remoteLinkErrorMessage() {
        return this.remoteLinkErrorMessage;
    }

    public List<ClusterLinkTaskDescription> taskDescriptions() {
        return this.taskDescriptions;
    }

    public SwitchoverType switchoverType() {
        return this.switchoverType;
    }

    public SwitchoverState switchoverState() {
        return this.switchoverState;
    }

    public static enum SwitchoverType {
        UNKNOWN(0),
        FAILOVER(1),
        REVERSE(2),
        RESTORE(3);

        private final byte value;

        private SwitchoverType(byte b) {
            this.value = b;
        }

        public byte value() {
            return this.value;
        }

        public static SwitchoverType fromValue(byte b) {
            for (SwitchoverType type : SwitchoverType.values()) {
                if (type.value != b) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown SwitchoverType byte value: " + b);
        }
    }

    public static enum SwitchoverState {
        UNKNOWN(0),
        ACTIVE(1),
        PASSIVE(2),
        PENDING_ACTIVE(3),
        PENDING_PASSIVE(4),
        INACTIVE(5);

        private final byte value;

        private SwitchoverState(byte b) {
            this.value = b;
        }

        public byte value() {
            return this.value;
        }

        public static SwitchoverState fromValue(byte b) {
            for (SwitchoverState state : SwitchoverState.values()) {
                if (state.value != b) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown SwitchoverState byte value: " + b);
        }
    }
}

