/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ExclusionOp {
    private final OpType opType;
    private final String reason;

    public ExclusionOp(OpType operationType) {
        this(operationType, "");
    }

    public ExclusionOp(OpType operationType, String reason) {
        this.opType = Objects.requireNonNull(operationType);
        this.reason = Objects.requireNonNull(reason);
    }

    public String reason() {
        return this.reason;
    }

    public OpType opType() {
        return this.opType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExclusionOp that = (ExclusionOp)o;
        return this.opType == that.opType && this.reason == that.reason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.opType, this.reason});
    }

    public String toString() {
        return "ExclusionOp{opType=" + String.valueOf((Object)this.opType) + ", reason='" + this.reason + "'}";
    }

    public static enum OpType {
        UNKNOWN(0),
        SET(1),
        DELETE(2);

        private static final Map<Byte, OpType> OP_TYPES;
        private final byte id;

        private OpType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static OpType forId(byte id) {
            return OP_TYPES.getOrDefault(id, UNKNOWN);
        }

        static {
            OP_TYPES = Collections.unmodifiableMap(Arrays.stream(OpType.values()).collect(Collectors.toMap(OpType::id, Function.identity())));
        }
    }
}

