/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.Value;

public class SensorBuilder {
    private final Metrics metrics;
    private final Sensor sensor;
    private final boolean preexisting;
    private final Map<String, String> tags;

    public SensorBuilder(Metrics metrics, String name) {
        this(metrics, name, Collections::emptyMap);
    }

    public SensorBuilder(Metrics metrics, String name, Supplier<Map<String, String>> tagsSupplier) {
        this.metrics = metrics;
        Sensor s2 = metrics.getSensor(name);
        if (s2 != null) {
            this.sensor = s2;
            this.tags = Collections.emptyMap();
            this.preexisting = true;
        } else {
            this.sensor = metrics.sensor(name);
            this.tags = tagsSupplier.get();
            this.preexisting = false;
        }
    }

    SensorBuilder withAvg(MetricNameTemplate name) {
        if (!this.preexisting) {
            this.sensor.add(this.metrics.metricInstance(name, this.tags), new Avg());
        }
        return this;
    }

    SensorBuilder withMin(MetricNameTemplate name) {
        if (!this.preexisting) {
            this.sensor.add(this.metrics.metricInstance(name, this.tags), new Min());
        }
        return this;
    }

    SensorBuilder withMax(MetricNameTemplate name) {
        if (!this.preexisting) {
            this.sensor.add(this.metrics.metricInstance(name, this.tags), new Max());
        }
        return this;
    }

    SensorBuilder withValue(MetricNameTemplate name) {
        if (!this.preexisting) {
            this.sensor.add(this.metrics.metricInstance(name, this.tags), new Value());
        }
        return this;
    }

    SensorBuilder withMeter(MetricNameTemplate rateName, MetricNameTemplate totalName) {
        if (!this.preexisting) {
            this.sensor.add(new Meter(this.metrics.metricInstance(rateName, this.tags), this.metrics.metricInstance(totalName, this.tags)));
        }
        return this;
    }

    SensorBuilder withMeter(SampledStat sampledStat, MetricNameTemplate rateName, MetricNameTemplate totalName) {
        if (!this.preexisting) {
            this.sensor.add(new Meter(sampledStat, this.metrics.metricInstance(rateName, this.tags), this.metrics.metricInstance(totalName, this.tags)));
        }
        return this;
    }

    Sensor build() {
        return this.sensor;
    }
}

