/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;

public class Endpoint {
    private final String listener;
    private final SecurityProtocol securityProtocol;
    private final String host;
    private final int port;

    public Endpoint(String listener, SecurityProtocol securityProtocol, String host, int port) {
        this.listener = listener;
        this.securityProtocol = securityProtocol;
        this.host = host;
        this.port = port;
    }

    public String listener() {
        return this.listener;
    }

    @Deprecated(since="4.1", forRemoval=true)
    public Optional<String> listenerName() {
        return Optional.ofNullable(this.listener);
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint that = (Endpoint)o;
        return Objects.equals(this.listener, that.listener) && Objects.equals((Object)this.securityProtocol, (Object)that.securityProtocol) && Objects.equals(this.host, that.host) && this.port == that.port;
    }

    public String connectionString() {
        String hostport = this.host == null ? ":" + this.port : Utils.formatAddress(this.host, this.port);
        return this.listener + "://" + hostport;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listener, this.securityProtocol, this.host, this.port});
    }

    public String toString() {
        return "Endpoint(listenerName='" + this.listener + "', securityProtocol=" + String.valueOf((Object)this.securityProtocol) + ", host='" + this.host + "', port=" + this.port + ")";
    }
}

