/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.List;
import java.util.Objects;

public class Tenant {
    private final String tenantId;
    private final List<Integer> cellIds;

    public Tenant(String tenantId, List<Integer> cellIds) {
        this.tenantId = tenantId;
        this.validateCellIds(cellIds);
        this.cellIds = cellIds;
    }

    private void validateCellIds(List<Integer> cellIds) {
        if (cellIds == null) {
            throw new IllegalArgumentException("cell-ids passed cannot be null");
        }
        if ((long)cellIds.size() != cellIds.stream().distinct().count()) {
            throw new IllegalArgumentException("Invalid cell-ids passed: cell-ids not unique");
        }
    }

    public String tenantId() {
        return this.tenantId;
    }

    public List<Integer> cellIds() {
        return this.cellIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant that = (Tenant)o;
        return this.tenantId.equals(that.tenantId()) && this.cellIds.equals(that.cellIds());
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.cellIds);
    }

    public String toString() {
        return "Tenant{tenantId=" + this.tenantId + ", cellIds=" + String.valueOf(this.cellIds) + "}";
    }
}

