/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteAclsRequestData
implements ApiMessage {
    List<DeleteAclsFilter> filters;
    String clusterId;
    byte aclState;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("filters", new ArrayOf(DeleteAclsFilter.SCHEMA_1), "The filters to use when deleting ACLs."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DeleteAclsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DeleteAclsRequestData() {
        this.filters = new ArrayList<DeleteAclsFilter>(0);
        this.clusterId = "";
        this.aclState = (byte)3;
    }

    @Override
    public short apiKey() {
        return 31;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        DeleteAclsFilter _filtersTransformed;
        DeleteAclsFilter _filtersRawElement;
        int i;
        ArrayList<DeleteAclsFilter> newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _filtersRawElement = new DeleteAclsFilter(_readable, _version, _context);
                _filtersTransformed = (DeleteAclsFilter)_context.read(EntityType.ACL_RESOURCE_FILTER, _filtersRawElement);
                newCollection.add(_filtersTransformed);
            }
            this.filters = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filters was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DeleteAclsFilter>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                _filtersRawElement = new DeleteAclsFilter(_readable, _version, _context);
                _filtersTransformed = (DeleteAclsFilter)_context.read(EntityType.ACL_RESOURCE_FILTER, _filtersRawElement);
                newCollection.add(_filtersTransformed);
            }
            this.filters = newCollection;
        }
        this.clusterId = "";
        this.aclState = (byte)3;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            throw new RuntimeException("non-nullable field clusterId was serialized as null");
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field clusterId had invalid length " + length);
                        }
                        this.clusterId = _readable.readString(length);
                        continue block6;
                    }
                    case 10001: {
                        this.aclState = _readable.readByte();
                        continue block6;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        ArrayList _filtersTransformed;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.filters.size() + 1);
            _filtersTransformed = (ArrayList)_cache.getTransformedValue(this.filters);
            for (DeleteAclsFilter filtersElement : _filtersTransformed) {
                filtersElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.filters.size());
            _filtersTransformed = (ArrayList)_cache.getTransformedValue(this.filters);
            for (DeleteAclsFilter filtersElement : _filtersTransformed) {
                filtersElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 2) {
            if (!this.clusterId.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        if (_version >= 2) {
            if (this.aclState != 3) {
                ++_numTaggedFields;
            }
        } else if (this.aclState != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default aclState at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.clusterId.equals("")) {
                _writable.writeUnsignedVarint(10000);
                byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.aclState != 3) {
                _writable.writeUnsignedVarint(10001);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.aclState);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.filters.size() + 1));
        } else {
            _size.addBytes(4);
        }
        ArrayList<DeleteAclsFilter> _filtersTransformed = new ArrayList<DeleteAclsFilter>(this.filters.size());
        for (DeleteAclsFilter filtersElement : this.filters) {
            DeleteAclsFilter _transformedMessage = (DeleteAclsFilter)_context.write(EntityType.ACL_RESOURCE_FILTER, filtersElement);
            _filtersTransformed.add(_transformedMessage);
            _transformedMessage.addSize(_size, _cache, _version, _context);
        }
        _cache.cacheTransformedValue(this.filters, _filtersTransformed);
        if (_version >= 2 && !this.clusterId.equals("")) {
            ++_numTaggedFields;
            _size.addBytes(2);
            byte[] _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, _stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
        }
        if (_version >= 2 && this.aclState != 3) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsRequestData)) {
            return false;
        }
        DeleteAclsRequestData other = (DeleteAclsRequestData)obj;
        if (this.filters == null ? other.filters != null : !this.filters.equals(other.filters)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.aclState != other.aclState) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.filters == null ? 0 : this.filters.hashCode());
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.aclState;
        return hashCode;
    }

    @Override
    public DeleteAclsRequestData duplicate() {
        DeleteAclsRequestData _duplicate = new DeleteAclsRequestData();
        ArrayList<DeleteAclsFilter> newFilters = new ArrayList<DeleteAclsFilter>(this.filters.size());
        for (DeleteAclsFilter _element : this.filters) {
            newFilters.add(_element.duplicate());
        }
        _duplicate.filters = newFilters;
        _duplicate.clusterId = this.clusterId;
        _duplicate.aclState = this.aclState;
        return _duplicate;
    }

    public String toString() {
        return "DeleteAclsRequestData(filters=" + MessageUtil.deepToString(this.filters.iterator()) + ", clusterId=" + (String)(this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", aclState=" + this.aclState + ")";
    }

    public List<DeleteAclsFilter> filters() {
        return this.filters;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public byte aclState() {
        return this.aclState;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteAclsRequestData setFilters(List<DeleteAclsFilter> v) {
        this.filters = v;
        return this;
    }

    public DeleteAclsRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public DeleteAclsRequestData setAclState(byte v) {
        this.aclState = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("filters", new CompactArrayOf(DeleteAclsFilter.SCHEMA_2), "The filters to use when deleting ACLs."), Field.TaggedFieldsSection.of(10000, new Field("cluster_id", Type.COMPACT_STRING, "Optional cluster-id for centralized ACLs."), 10001, new Field("acl_state", Type.INT8, "The state to match, can be used to delete the soft/active ACLs")));
        SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DeleteAclsFilter
    implements Message {
        byte resourceTypeFilter;
        String resourceNameFilter;
        byte patternTypeFilter;
        String principalFilter;
        String hostFilter;
        byte operation;
        byte permissionType;
        List<Uuid> clusterLinkIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", Type.INT8, "The pattern type."), new Field("principal_filter", Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The permission type."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DeleteAclsFilter(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DeleteAclsFilter() {
            this.resourceTypeFilter = 0;
            this.resourceNameFilter = "";
            this.patternTypeFilter = (byte)3;
            this.principalFilter = "";
            this.hostFilter = "";
            this.operation = 0;
            this.permissionType = 0;
            this.clusterLinkIds = new ArrayList<Uuid>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilter");
            }
            this.resourceTypeFilter = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.resourceNameFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field resourceNameFilter had invalid length " + length);
                }
                this.resourceNameFilter = _readable.readString(length);
            }
            this.patternTypeFilter = _readable.readByte();
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.principalFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field principalFilter had invalid length " + length);
                }
                this.principalFilter = _context.read(EntityType.ACL_PRINCIPAL_FILTER, _readable.readString(length));
            }
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.hostFilter = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field hostFilter had invalid length " + length);
                }
                this.hostFilter = _readable.readString(length);
            }
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this.clusterLinkIds = new ArrayList<Uuid>(0);
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength = _readable.readUnsignedVarint() - 1;
                            if (arrayLength < 0) {
                                throw new RuntimeException("non-nullable field clusterLinkIds was serialized as null");
                            }
                            if (arrayLength > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Uuid> newCollection = new ArrayList<Uuid>(arrayLength);
                            for (int i = 0; i < arrayLength; ++i) {
                                newCollection.add(_readable.readUuid());
                            }
                            this.clusterLinkIds = newCollection;
                            continue block3;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceTypeFilter);
            if (this.resourceNameFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.resourceNameFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.patternTypeFilter);
            if (this.principalFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.principalFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (this.hostFilter == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.hostFilter);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.clusterLinkIds.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.clusterLinkIds));
                    _writable.writeUnsignedVarint(this.clusterLinkIds.size() + 1);
                    for (Uuid clusterLinkIdsElement : this.clusterLinkIds) {
                        _writable.writeUuid(clusterLinkIdsElement);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsFilter");
            }
            _size.addBytes(1);
            if (this.resourceNameFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.resourceNameFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'resourceNameFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.resourceNameFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            if (this.principalFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = _context.write(EntityType.ACL_PRINCIPAL_FILTER, this.principalFilter).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'principalFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.principalFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this.hostFilter == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.hostFilter.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'hostFilter' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.hostFilter, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            _size.addBytes(1);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clusterLinkIds.size() + 1));
                _size.addBytes(this.clusterLinkIds.size() * 16);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.clusterLinkIds, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilter)) {
                return false;
            }
            DeleteAclsFilter other = (DeleteAclsFilter)obj;
            if (this.resourceTypeFilter != other.resourceTypeFilter) {
                return false;
            }
            if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
                return false;
            }
            if (this.patternTypeFilter != other.patternTypeFilter) {
                return false;
            }
            if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
                return false;
            }
            if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            if (this.permissionType != other.permissionType) {
                return false;
            }
            if (this.clusterLinkIds == null ? other.clusterLinkIds != null : !this.clusterLinkIds.equals(other.clusterLinkIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceTypeFilter;
            hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
            hashCode = 31 * hashCode + this.patternTypeFilter;
            hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
            hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            hashCode = 31 * hashCode + (this.clusterLinkIds == null ? 0 : this.clusterLinkIds.hashCode());
            return hashCode;
        }

        @Override
        public DeleteAclsFilter duplicate() {
            DeleteAclsFilter _duplicate = new DeleteAclsFilter();
            _duplicate.resourceTypeFilter = this.resourceTypeFilter;
            _duplicate.resourceNameFilter = this.resourceNameFilter == null ? null : this.resourceNameFilter;
            _duplicate.patternTypeFilter = this.patternTypeFilter;
            _duplicate.principalFilter = this.principalFilter == null ? null : this.principalFilter;
            _duplicate.hostFilter = this.hostFilter == null ? null : this.hostFilter;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            ArrayList<Uuid> newClusterLinkIds = new ArrayList<Uuid>(this.clusterLinkIds.size());
            for (Uuid _element : this.clusterLinkIds) {
                newClusterLinkIds.add(_element);
            }
            _duplicate.clusterLinkIds = newClusterLinkIds;
            return _duplicate;
        }

        public String toString() {
            return "DeleteAclsFilter(resourceTypeFilter=" + this.resourceTypeFilter + ", resourceNameFilter=" + (String)(this.resourceNameFilter == null ? "null" : "'" + this.resourceNameFilter.toString() + "'") + ", patternTypeFilter=" + this.patternTypeFilter + ", principalFilter=" + (String)(this.principalFilter == null ? "null" : "'" + this.principalFilter.toString() + "'") + ", hostFilter=" + (String)(this.hostFilter == null ? "null" : "'" + this.hostFilter.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ", clusterLinkIds=" + MessageUtil.deepToString(this.clusterLinkIds.iterator()) + ")";
        }

        public byte resourceTypeFilter() {
            return this.resourceTypeFilter;
        }

        public String resourceNameFilter() {
            return this.resourceNameFilter;
        }

        public byte patternTypeFilter() {
            return this.patternTypeFilter;
        }

        public String principalFilter() {
            return this.principalFilter;
        }

        public String hostFilter() {
            return this.hostFilter;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public List<Uuid> clusterLinkIds() {
            return this.clusterLinkIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsFilter setResourceTypeFilter(byte v) {
            this.resourceTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setResourceNameFilter(String v) {
            this.resourceNameFilter = v;
            return this;
        }

        public DeleteAclsFilter setPatternTypeFilter(byte v) {
            this.patternTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setPrincipalFilter(String v) {
            this.principalFilter = v;
            return this;
        }

        public DeleteAclsFilter setHostFilter(String v) {
            this.hostFilter = v;
            return this;
        }

        public DeleteAclsFilter setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsFilter setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        public DeleteAclsFilter setClusterLinkIds(List<Uuid> v) {
            this.clusterLinkIds = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("resource_type_filter", Type.INT8, "The resource type."), new Field("resource_name_filter", Type.COMPACT_NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", Type.INT8, "The pattern type."), new Field("principal_filter", Type.COMPACT_NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", Type.COMPACT_NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The permission type."), Field.TaggedFieldsSection.of(10000, new Field("cluster_link_ids", new CompactArrayOf(Type.UUID), "Cluster link IDs to delete only ACLs that were migrated from a source cluster by a specific cluster link.")));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

