/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public abstract class AbstractStreamHandler<T>
extends SimpleChannelInboundHandler<T> {
    private final NettyStream stream;
    private NettyStream.StreamHandler handler;
    final Logger log;

    public AbstractStreamHandler(NettyStream stream, NettyStream.StreamHandler handler, LogContext logContext) {
        this.stream = stream;
        this.handler = handler;
        this.log = logContext.logger(AbstractStreamHandler.class);
    }

    public NettyStream.StreamHandler streamHandler() {
        return this.handler;
    }

    protected void streamHandler(NettyStream.StreamHandler handler) {
        this.handler = handler;
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.handler == null) {
            this.log.error("Stream handler is not initialized, cannot handle writability change, closing channel");
            ctx.channel().close();
            return;
        }
        if (ctx.channel().isWritable()) {
            try {
                this.handler.handleReadyForSend();
            }
            catch (Throwable t) {
                this.log.error("Failed to handle writable event", t);
                this.handler.handleException(t);
            }
        } else {
            this.stream.flush();
        }
        super.channelWritabilityChanged(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.handler != null) {
            this.handler.handleException(cause);
        } else {
            this.log.error("Stream handler is not initialized, cannot handle exception, closing channel", cause);
            ctx.channel().close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.handleClose();
        }
        super.channelInactive(ctx);
    }
}

