/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.AbstractStreamHandler;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.NettyStreamChannel;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class NettyRawBytesStream
extends NettyStreamChannel
implements NettyStream {
    private final Logger log;
    private final Channel streamChannel;
    private final boolean flowControlEnabled;
    AbstractStreamHandler<?> pipelineStreamHandler;

    public NettyRawBytesStream(Channel streamChannel, LogContext logContext) {
        this(streamChannel, 8192, 8192, logContext, true);
    }

    public NettyRawBytesStream(Channel streamChannel, int fileTransferChunkSize, int byteBufferTransferChunkSize, LogContext logContext, boolean flowControlEnabled) {
        super(logContext, fileTransferChunkSize, byteBufferTransferChunkSize);
        this.streamChannel = streamChannel;
        this.log = logContext.logger(NettyRawBytesStream.class);
        this.flowControlEnabled = flowControlEnabled;
        if (flowControlEnabled) {
            streamChannel.config().setAutoRead(false);
        }
    }

    @Override
    protected NettyStream nettyStream() {
        return this;
    }

    @Override
    public TransferableChannel transferableChannel() {
        return this;
    }

    public void setAbstractStreamHandler(AbstractStreamHandler<?> newPipelineStreamHandler) {
        if (!this.inEventLoop()) {
            throw new IllegalStateException("setAbstractStreamHandler must be called on the event loop of the stream: " + this.streamId());
        }
        this.pipelineStreamHandler = newPipelineStreamHandler;
    }

    @Override
    public void setStreamHandler(NettyStream.StreamHandler newHandler) {
        if (!this.inEventLoop()) {
            throw new IllegalStateException("setStreamHandler must be called on the event loop of the stream: " + this.streamId());
        }
        this.pipelineStreamHandler.streamHandler(newHandler);
    }

    @Override
    public NettyStream.StreamHandler getStreamHandler() {
        if (this.inEventLoop()) {
            return this.pipelineStreamHandler.streamHandler();
        }
        throw new IllegalStateException("getStreamHandler must be called on the event loop of the stream: " + this.streamId());
    }

    public Channel channel() {
        return this.streamChannel;
    }

    @Override
    public String streamId() {
        return this.streamChannel.id().asLongText();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.streamChannel.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.streamChannel.localAddress();
    }

    @Override
    public boolean isReadyForSending() {
        return this.streamChannel.isWritable();
    }

    @Override
    public boolean isOpen() {
        return this.streamChannel.isOpen();
    }

    @Override
    public NettyStream.Priority priority() {
        return NettyStream.Priority.NORMAL;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.streamChannel.alloc();
    }

    @Override
    public Future<Void> send(ByteBuf data, boolean flush) {
        this.log.debug("Writing {} bytes to stream {}", (Object)data.readableBytes(), (Object)this.streamChannel);
        return this.sendMessage(data, flush);
    }

    protected Future<Void> sendMessage(Object msg, boolean flush) {
        ChannelPromise promise = this.streamChannel.newPromise();
        if (flush) {
            this.streamChannel.writeAndFlush(msg, promise);
        } else {
            this.streamChannel.write(msg, promise);
        }
        return promise;
    }

    @Override
    public void flush() {
        this.streamChannel.flush();
    }

    @Override
    public void receiveMore() {
        if (this.flowControlEnabled) {
            this.log.debug("Requesting more data on stream {}", (Object)this.streamChannel);
            this.streamChannel.read();
        }
    }

    @Override
    public void setPriority(NettyStream.Priority priority) {
        throw new UnsupportedOperationException("Setting priority of raw bytes stream is not supported.");
    }

    @Override
    public Future<Void> closeStream() {
        this.log.debug("Closing stream channel {}", (Object)this.streamChannel);
        return this.streamChannel.close();
    }

    @Override
    public void runOnEventLoop(Runnable op, boolean forceReschedule) {
        if (!forceReschedule && this.inEventLoop()) {
            op.run();
        } else {
            this.streamChannel.eventLoop().execute(op);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithDelayOnEventLoop(Runnable op, long delay, TimeUnit unit) {
        return this.streamChannel.eventLoop().schedule(op, delay, unit);
    }

    @Override
    public boolean inEventLoop() {
        return this.streamChannel.eventLoop().inEventLoop();
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Utils.sslSession(this.streamChannel);
    }

    @Override
    public String toString() {
        return this.streamChannel.id().asShortText() + "(" + this.streamId() + ")";
    }

    public static class NettyRawBytesStreamHandler
    extends AbstractStreamHandler<ByteBuf> {
        public NettyRawBytesStreamHandler(NettyStream stream, LogContext logContext) {
            this(stream, null, logContext);
        }

        public NettyRawBytesStreamHandler(NettyStream stream, NettyStream.StreamHandler handler, LogContext logContext) {
            super(stream, handler, logContext);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            this.streamHandler().handleData(msg);
        }
    }
}

