/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterClusterLinksResponse
extends AbstractResponse {
    private final AlterClusterLinksResponseData data;

    public AlterClusterLinksResponse(AlterClusterLinksResponseData data) {
        super(ApiKeys.ALTER_CLUSTER_LINKS);
        this.data = data;
    }

    @Override
    public AlterClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        errors.put(Errors.forCode(this.data.errorCode()), 1);
        this.data.alterClusterLinkResults().forEach(alterClusterLinkResult -> errors.compute(Errors.forCode(this.data.errorCode()), (k, v) -> v == null ? 1 : v + 1));
        return errors;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AlterClusterLinksResponse parse(Readable readable, short version, MessageContext context) {
        return new AlterClusterLinksResponse(new AlterClusterLinksResponseData(readable, version, context));
    }

    public void complete(Map<String, KafkaFutureImpl<Void>> futures) {
        Iterator<KafkaFutureImpl<Void>> iterator = futures.values().iterator();
        for (AlterClusterLinksResponseData.AlterClusterLinkResult result : this.data.alterClusterLinkResults()) {
            Errors error = Errors.forCode(result.errorCode());
            KafkaFutureImpl<Void> future = iterator.next();
            if (error != Errors.NONE) {
                future.completeExceptionally(error.exception(result.errorMessage()));
                continue;
            }
            future.complete(null);
        }
    }
}

