/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ReplicaStatusRequestData;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ReplicaStatusResponse;

public class ReplicaStatusRequest
extends AbstractRequest {
    private final ReplicaStatusRequestData data;

    public ReplicaStatusRequest(ReplicaStatusRequestData data, short version) {
        super(ApiKeys.REPLICA_STATUS, version);
        this.data = data;
    }

    @Override
    public ReplicaStatusRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable ex) {
        ApiError apiError = ApiError.fromThrowable(ex);
        ReplicaStatusResponseData response = new ReplicaStatusResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(apiError.error().code());
        for (ReplicaStatusRequestData.ReplicaStatusTopic topic : this.data.topics()) {
            ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse = new ReplicaStatusResponseData.ReplicaStatusTopicResponse().setName(topic.name());
            for (int partition : topic.partitions()) {
                topicResponse.partitions().add(new ReplicaStatusResponseData.ReplicaStatusPartitionResponse().setPartitionIndex(partition).setErrorCode(apiError.error().code()).setReplicas(null));
            }
            response.topics().add(topicResponse);
        }
        return new ReplicaStatusResponse(response);
    }

    public static ReplicaStatusRequest parse(Readable readable, short version, MessageContext context) {
        return new ReplicaStatusRequest(new ReplicaStatusRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReplicaStatusRequest> {
        private final ReplicaStatusRequestData data;

        public Builder(Set<TopicPartition> partitions, boolean includeLinkedReplicas) {
            super(ApiKeys.REPLICA_STATUS);
            HashMap<String, List> topicToPartitions = new HashMap<String, List>();
            for (TopicPartition partition : partitions) {
                topicToPartitions.computeIfAbsent(partition.topic(), k -> new ArrayList()).add(partition.partition());
            }
            ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic> dataTopics = new ArrayList<ReplicaStatusRequestData.ReplicaStatusTopic>(topicToPartitions.size());
            for (Map.Entry entry : topicToPartitions.entrySet()) {
                dataTopics.add(new ReplicaStatusRequestData.ReplicaStatusTopic().setName((String)entry.getKey()).setPartitions((List)entry.getValue()));
            }
            this.data = new ReplicaStatusRequestData().setTopics(dataTopics).setIncludeLinkedReplicas(includeLinkedReplicas);
        }

        @Override
        public ReplicaStatusRequest build(short version) {
            return new ReplicaStatusRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

