/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.message.ReportQuotaConsumptionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReportQuotaConsumptionResponse
extends AbstractResponse {
    private final ReportQuotaConsumptionResponseData data;

    public ReportQuotaConsumptionResponse(ReportQuotaConsumptionResponseData data) {
        super(ApiKeys.REPORT_QUOTA_CONSUMPTION);
        this.data = data;
    }

    @Override
    public ReportQuotaConsumptionResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (ReportQuotaConsumptionResponseData.EntryData result : this.data.entries()) {
            ReportQuotaConsumptionResponse.updateErrorCounts(counts, Errors.forCode(result.errorCode()));
        }
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static ReportQuotaConsumptionResponse parse(Readable readable, short version, MessageContext context) {
        return new ReportQuotaConsumptionResponse(new ReportQuotaConsumptionResponseData(readable, version, context));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportQuotaConsumptionResponse that = (ReportQuotaConsumptionResponse)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }
}

