/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.BrokerJwtValidator;
import org.apache.kafka.common.security.oauthbearer.ClientJwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.utils.Utils;

public class DefaultJwtValidator
implements JwtValidator {
    private final Optional<CloseableVerificationKeyResolver> verificationKeyResolver;
    private JwtValidator delegate;

    public DefaultJwtValidator() {
        this.verificationKeyResolver = Optional.empty();
    }

    public DefaultJwtValidator(CloseableVerificationKeyResolver verificationKeyResolver) {
        this.verificationKeyResolver = Optional.of(verificationKeyResolver);
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu;
        this.delegate = this.verificationKeyResolver.isPresent() ? new BrokerJwtValidator(this.verificationKeyResolver.get()) : (!Utils.isBlank((cu = new ConfigurationUtils(configs, saslMechanism)).validateString("sasl.oauthbearer.jwks.endpoint.url", false)) ? new BrokerJwtValidator() : new ClientJwtValidator());
        this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public OAuthBearerToken validate(String accessToken) throws JwtValidatorException {
        if (this.delegate == null) {
            throw new IllegalStateException("JWT validator delegate is null; please call configure() first");
        }
        return this.delegate.validate(accessToken);
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly(this.delegate, "JWT validator delegate");
    }

    JwtValidator delegate() {
        return this.delegate;
    }
}

