/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.client;

import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import java.util.Objects;

public class SecretMetadata {
    private String path;
    private String key;
    private int version;
    private String secret;

    public SecretMetadata(String path, String key, int version, String secret) {
        this.path = path;
        this.key = key;
        this.version = version;
        this.secret = secret;
    }

    public SecretMetadata(Secret secret) {
        this.path = secret.getPath();
        this.key = secret.getKey();
        this.version = secret.getVersion();
        this.secret = secret.getSecret();
    }

    public String getPath() {
        return this.path;
    }

    public String getKey() {
        return this.key;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretMetadata that = (SecretMetadata)o;
        return this.version == that.version && Objects.equals(this.path, that.path) && Objects.equals(this.key, that.key) && Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.key, this.version, this.secret);
    }

    public String toString() {
        return "SecretMetadata{path='" + this.path + "', key='" + this.key + "', version=" + this.version + ", secret='[hidden]'}";
    }
}

