/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import io.confluent.kafka.storage.log.AbstractLog;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.group.ListenerAdapter;
import kafka.server.LogAppendResult;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.coordinator.common.runtime.PartitionWriter;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.transaction.AddPartitionsToTxnManager;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u0007\u000e\u0001QA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006e\u0001!\ta\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019a\u0004\u0001)A\u0005s!)!\t\u0001C!\u0007\")!\f\u0001C!7\")a\f\u0001C!?\")1\u000e\u0001C!Y\"9\u00111\u0006\u0001\u0005B\u00055\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0005i\u0019un\u001c:eS:\fGo\u001c:QCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s\u0015\tqq\"A\u0003he>,\bO\u0003\u0002\u0011#\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0004\u0001Ui\u0002C\u0001\f\u001c\u001b\u00059\"B\u0001\r\u001a\u0003\u0011a\u0017M\\4\u000b\u0003i\tAA[1wC&\u0011Ad\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005yIS\"A\u0010\u000b\u0005\u0001\n\u0013a\u0002:v]RLW.\u001a\u0006\u0003E\r\naaY8n[>t'B\u0001\t%\u0015\t\u0011RE\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016 \u0005=\u0001\u0016M\u001d;ji&|gn\u0016:ji\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003[Aj\u0011A\f\u0006\u0003_E\taa]3sm\u0016\u0014\u0018BA\u0019/\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fa\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u000e\u0011\u0015Y#\u00011\u0001-\u0003E!\u0017N]3di\u0006\u001bG/[8o#V,W/Z\u000b\u0002sI\u0019!(F\u001f\u0007\tm\"\u0001!\u000f\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0013I&\u0014Xm\u0019;BGRLwN\\)vKV,\u0007\u0005\u0005\u0002?\u00016\tqH\u0003\u00020I%\u0011\u0011i\u0010\u0002\f\u0003\u000e$\u0018n\u001c8Rk\u0016,X-\u0001\tsK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feR\u0019AIS)\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\u0003iB\u0004\"!T(\u000e\u00039S!A\t\u0013\n\u0005As%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006%\u0016\u0001\raU\u0001\tY&\u001cH/\u001a8feB\u0011Ak\u0016\b\u0003=UK!AV\u0010\u0002\u001fA\u000b'\u000f^5uS>twK]5uKJL!\u0001W-\u0003\u00111K7\u000f^3oKJT!AV\u0010\u0002%\u0011,'/Z4jgR,'\u000fT5ti\u0016tWM\u001d\u000b\u0004\trk\u0006\"B&\u0007\u0001\u0004a\u0005\"\u0002*\u0007\u0001\u0004\u0019\u0016AB2p]\u001aLw\r\u0006\u0002aUB\u0011\u0011\r[\u0007\u0002E*\u00111\rZ\u0001\u0004Y><'BA3g\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002hI\u000591\u000f^8sC\u001e,\u0017BA5c\u0005%aunZ\"p]\u001aLw\rC\u0003L\u000f\u0001\u0007A*A\u0011nCf\u0014Wm\u0015;beR$&/\u00198tC\u000e$\u0018n\u001c8WKJLg-[2bi&|g\u000eF\u0005nqf\fi!a\u0006\u0002\"A\u0019an];\u000e\u0003=T!\u0001]9\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002s3\u0005!Q\u000f^5m\u0013\t!xNA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004\"!\u0019<\n\u0005]\u0014'!\u0005,fe&4\u0017nY1uS>tw)^1sI\")1\n\u0003a\u0001\u0019\")!\u0010\u0003a\u0001w\u0006yAO]1og\u0006\u001cG/[8oC2LE\rE\u0002}\u0003\u000fq1!`A\u0002!\tqh)D\u0001\u0000\u0015\r\t\taE\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015a)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b1\u0005bBA\b\u0011\u0001\u0007\u0011\u0011C\u0001\u000baJ|G-^2fe&#\u0007cA#\u0002\u0014%\u0019\u0011Q\u0003$\u0003\t1{gn\u001a\u0005\b\u00033A\u0001\u0019AA\u000e\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019Q)!\b\n\u0007\u0005}aIA\u0003TQ>\u0014H\u000fC\u0004\u0002$!\u0001\r!!\n\u0002\u0015\u0005\u0004\u0018NV3sg&|g\u000eE\u0002F\u0003OI1!!\u000bG\u0005\rIe\u000e^\u0001\u0007CB\u0004XM\u001c3\u0015\u0011\u0005E\u0011qFA\u0019\u0003kAQaS\u0005A\u00021Ca!a\r\n\u0001\u0004)\u0018!\u0005<fe&4\u0017nY1uS>tw)^1sI\"9\u0011qG\u0005A\u0002\u0005e\u0012a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b(\u0002\rI,7m\u001c:e\u0013\u0011\t\u0019%!\u0010\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0003\u0011\u0019\u0018N_3\u0015\t\u0005E\u0011\u0011\n\u0005\u0006\u0017*\u0001\r\u0001T\u0001\u000eI\u0016dW\r^3SK\u000e|'\u000fZ:\u0015\r\u0005=\u0013qKA-!\u0011q7/!\u0015\u0011\u0007Y\t\u0019&C\u0002\u0002V]\u0011AAV8jI\")1j\u0003a\u0001\u0019\"9\u00111L\u0006A\u0002\u0005E\u0011A\u00053fY\u0016$XMQ3g_J,wJ\u001a4tKR\u0004")
public class CoordinatorPartitionWriter
implements PartitionWriter {
    private final ReplicaManager replicaManager;
    private final ActionQueue directActionQueue;

    private ActionQueue directActionQueue() {
        return this.directActionQueue;
    }

    @Override
    public void registerListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.maybeAddListener(tp, new ListenerAdapter(listener));
    }

    @Override
    public void deregisterListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.removeListener(tp, new ListenerAdapter(listener));
    }

    @Override
    public LogConfig config(TopicPartition tp) {
        return (LogConfig)this.replicaManager.getLogConfig(tp).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw Errors.NOT_LEADER_OR_FOLLOWER.exception();
        });
    }

    @Override
    public CompletableFuture<VerificationGuard> maybeStartTransactionVerification(TopicPartition tp, String transactionalId, long producerId, short producerEpoch, int apiVersion) {
        AddPartitionsToTxnManager.TransactionSupportedOperation transactionSupportedOperation = AddPartitionsToTxnManager.txnOffsetCommitRequestVersionToTransactionSupportedOperation(apiVersion);
        CompletableFuture<VerificationGuard> future = new CompletableFuture<VerificationGuard>();
        this.replicaManager.maybeSendPartitionToTransactionCoordinator(tp, transactionalId, producerId, producerEpoch, -1, (Function1<Tuple2<Errors, VerificationGuard>, BoxedUnit>)(Function1<Tuple2, Object> & Serializable)errorAndGuard -> {
            CoordinatorPartitionWriter.$anonfun$maybeStartTransactionVerification$1(future, errorAndGuard);
            return BoxedUnit.UNIT;
        }, transactionSupportedOperation);
        return future;
    }

    @Override
    public long append(TopicPartition tp, VerificationGuard verificationGuard, MemoryRecords records) {
        TopicIdPartition topicIdPartition = tp != null ? this.replicaManager.topicIdPartition(tp) : null;
        boolean x$1 = true;
        boolean x$2 = true;
        AppendOrigin x$3 = AppendOrigin.COORDINATOR;
        Map x$4 = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicIdPartition), records)}));
        RequestLocal x$5 = RequestLocal.noCaching();
        Map x$6 = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), verificationGuard)}));
        ActionQueue x$7 = this.directActionQueue();
        Map<TopicIdPartition, LogAppendResult> appendResults = this.replicaManager.appendRecordsToLeader((short)1, true, AppendOrigin.COORDINATOR, x$4, x$5, x$7, x$6);
        LogAppendResult partitionResult = (LogAppendResult)appendResults.getOrElse(topicIdPartition, (Function0<Nothing$> & Serializable)() -> {
            throw new IllegalStateException("Append status " + appendResults + " should have partition " + tp + ".");
        });
        Errors errors = partitionResult.error();
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2)) {
            throw partitionResult.error().exception();
        }
        return partitionResult.info().lastOffset() + 1L;
    }

    @Override
    public long size(TopicPartition tp) {
        return BoxesRunTime.unboxToLong(this.replicaManager.getLog(tp).map((Function1<AbstractLog, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.size())).getOrElse(() -> 0L));
    }

    @Override
    public CompletableFuture<Void> deleteRecords(TopicPartition tp, long deleteBeforeOffset) {
        CompletableFuture<Void> responseFuture = new CompletableFuture<Void>();
        this.replicaManager.deleteRecords(30000L, (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToLong(deleteBeforeOffset))})), (Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit>)(Function1<Map, Object> & Serializable)results -> {
            CoordinatorPartitionWriter.$anonfun$deleteRecords$1(tp, responseFuture, results);
            return BoxedUnit.UNIT;
        }, true);
        return responseFuture;
    }

    public static final /* synthetic */ void $anonfun$maybeStartTransactionVerification$1(CompletableFuture future$1, Tuple2 errorAndGuard) {
        Tuple2 tuple2 = errorAndGuard;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Errors error = (Errors)((Object)tuple2._1());
        VerificationGuard verificationGuard = (VerificationGuard)tuple2._2();
        Tuple2<Errors, VerificationGuard> tuple22 = new Tuple2<Errors, VerificationGuard>(error, verificationGuard);
        Errors error2 = tuple22._1();
        VerificationGuard verificationGuard2 = tuple22._2();
        Errors errors = error2;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2)) {
            future$1.completeExceptionally(error2.exception());
            return;
        }
        future$1.complete(verificationGuard2);
    }

    public static final /* synthetic */ void $anonfun$deleteRecords$1(TopicPartition tp$2, CompletableFuture responseFuture$1, Map results) {
        Option result = results.get(tp$2);
        if (result.isEmpty()) {
            responseFuture$1.completeExceptionally(new IllegalStateException("Delete status " + result + " should have partition " + tp$2 + "."));
            return;
        }
        if (((DeleteRecordsResponseData.DeleteRecordsPartitionResult)result.get()).errorCode() != Errors.NONE.code()) {
            responseFuture$1.completeExceptionally(Errors.forCode(((DeleteRecordsResponseData.DeleteRecordsPartitionResult)result.get()).errorCode()).exception());
            return;
        }
        responseFuture$1.complete(null);
    }

    public CoordinatorPartitionWriter(ReplicaManager replicaManager) {
        this.replicaManager = replicaManager;
        this.directActionQueue = new ActionQueue(null){

            public void add(Runnable action) {
                action.run();
            }

            public void tryCompleteActions() {
            }
        };
    }
}

