/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.image.publisher.TenantMetricsPublisher;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaSnapshot;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.FlexFanoutQuotaManager;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.quota.ElasticCkuDefinitionUtils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rMs!\u0002\u001d:\u0011\u0003\u0001e!\u0002\":\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005b\u0002'\u0002\u0005\u0004%\t!\u0014\u0005\u0007?\u0006\u0001\u000b\u0011\u0002(\t\u000b\u0001\fA\u0011A1\t\u000f\ru\u0012\u0001\"\u0003\u0004@!91QJ\u0001\u0005\n\r=c\u0001\u0002\":\u0001\rD\u0001\u0002\u001d\u0005\u0003\u0006\u0004%\t!\u001d\u0005\tk\"\u0011\t\u0011)A\u0005e\"Aa\u000f\u0003B\u0001B\u0003%q\u000f\u0003\u0005{\u0011\t\u0015\r\u0011\"\u0001|\u0011!y\bB!A!\u0002\u0013a\bBCA\u0001\u0011\t\u0015\r\u0011\"\u0001\u0002\u0004!Q\u0011Q\u0004\u0005\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u0005}\u0001B!b\u0001\n\u0003\t\t\u0003\u0003\u0006\u0002<!\u0011\t\u0011)A\u0005\u0003GA!\"!\u0010\t\u0005\u000b\u0007I\u0011AA \u0011)\tY\u0005\u0003B\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003\u001bB!Q1A\u0005\u0002\u0005=\u0003BCA,\u0011\t\u0005\t\u0015!\u0003\u0002R!Q\u0011\u0011\f\u0005\u0003\u0006\u0004%\t!a\u0017\t\u0015\u0005-\u0004B!A!\u0002\u0013\ti\u0006\u0003\u0004K\u0011\u0011\u0005\u0011Q\u000e\u0005\n\u0003\u007fB!\u0019!C\u0001\u0003\u0003C\u0001\"a%\tA\u0003%\u00111\u0011\u0005\n\u0003+C\u0001\u0019!C\u0005\u0003/C\u0011\"!'\t\u0001\u0004%I!a'\t\u000f\u0005\u001d\u0006\u0002)Q\u0005o\"I\u0011\u0011\u0017\u0005C\u0002\u0013%\u00111\u0017\u0005\t\u0003\u0007D\u0001\u0015!\u0003\u00026\"I\u0011Q\u0019\u0005C\u0002\u0013%\u00111\u0017\u0005\t\u0003\u000fD\u0001\u0015!\u0003\u00026\"9\u0011\u0011\u001a\u0005\u0005\u0002\u0005]\u0005bBAf\u0011\u0011\u0005\u0011Q\u001a\u0005\b\u00033DA\u0011AAn\u0011\u001d\t\t\u000f\u0003C\u0001\u0003GDq!!>\t\t\u0003\t9\u0010C\u0004\u0002\u0000\"!IA!\u0001\t\u000f\t\u001d\u0001\u0002\"\u0003\u0003\n!9!Q\u0002\u0005\u0005\n\t=\u0001b\u0002B\u0014\u0011\u0011\u0005!\u0011\u0006\u0005\b\u00053BA\u0011\u0001B.\u0011\u001d\u00119\u0007\u0003C\u0001\u0005SBqA!\"\t\t\u0003\u00119\tC\u0004\u0003\u0010\"!\tA!%\t\u000f\tU\u0005\u0002\"\u0001\u0003\u0018\"9!Q\u0014\u0005\u0005\u0002\t}\u0005b\u0002BU\u0011\u0011\u0005!1\u0016\u0005\b\u0005gCA\u0011\u0001B[\u0011\u001d\u0011\t\r\u0003C\u0001\u0005\u0007DaA!2\t\t\u0003j\u0005b\u0002Bd\u0011\u0011\u0005#\u0011\u001a\u0005\b\u0005+DA\u0011\u0001Bl\u0011\u001d\u0011y\u000e\u0003C\u0005\u0005C\f\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005iZ\u0014!B9v_R\f'B\u0001\u001f>\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003y\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002B\u00035\t\u0011H\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;peN\u0011\u0011\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0015!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002\u001dB\u0019qJ\u0015+\u000e\u0003AS!!\u0015$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T!\n\u00191+\u001a;\u0011\u0005UcfB\u0001,[!\t9f)D\u0001Y\u0015\tIv(\u0001\u0004=e>|GOP\u0005\u00037\u001a\u000ba\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111LR\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005)\u0011\r\u001d9msR)\"Ma:\u0003j\n-81BB\u000f\u0007O\u0019Ica\u000b\u0004.\rm\u0002CA!\t'\u0011AA\t\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dl\u0014!B;uS2\u001c\u0018BA5g\u0005\u001daunZ4j]\u001e\u0004\"a\u001b8\u000e\u00031T!!\\\u001f\u0002\rM,'O^3s\u0013\tyGN\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\tEJ|7.\u001a:JIV\t!\u000f\u0005\u0002Fg&\u0011AO\u0012\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011\t_\u0005\u0003sf\u0012a#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:D_:4\u0017nZ\u0001\u0012cV|G/Y*uCR,W*\u00198bO\u0016\u0014X#\u0001?\u0011\u0005\u0005k\u0018B\u0001@:\u0005E\tVo\u001c;b'R\fG/Z'b]\u0006<WM]\u0001\u0013cV|G/Y*uCR,W*\u00198bO\u0016\u0014\b%A\u0005tG\",G-\u001e7feV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0011)H/\u001b7\u000b\u00075\fyAC\u0002?\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r]1dQ\u0016T!!a\u0006\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0005%!!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0016S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3s+\t\t\u0019\u0003\u0005\u0004\u0002&\u0005E\u0012QG\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002\f\u00055\"BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012q\u0005\u0002\t'V\u0004\b\u000f\\5feB\u00191.a\u000e\n\u0007\u0005eBNA\u0007J]R,'O\\1m\u0003\u0012l\u0017N\\\u0001\u0017S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3sA\u0005I2\r\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2l+\t\t\t\u0005\u0005\u0003\u0002D\u0005\u001dSBAA#\u0015\rQ\u0014QB\u0005\u0005\u0003\u0013\n)EA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AG2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013!\u00054mKb4\u0015M\\8vi6\u000bg.Y4feV\u0011\u0011\u0011\u000b\t\u0004W\u0006M\u0013bAA+Y\n1b\t\\3y\r\u0006tw.\u001e;Rk>$\u0018-T1oC\u001e,'/\u0001\ngY\u0016Dh)\u00198pkRl\u0015M\\1hKJ\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0018\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CR1aZA2\u0015\u0011\t)'a\u0004\u0002\r\r|W.\\8o\u0013\u0011\tI'!\u0019\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u0012E\u0006=\u0014\u0011OA:\u0003k\n9(!\u001f\u0002|\u0005u\u0004\"\u00029\u0019\u0001\u0004\u0011\b\"\u0002<\u0019\u0001\u00049\b\"\u0002>\u0019\u0001\u0004a\bbBA\u00011\u0001\u0007\u0011Q\u0001\u0005\b\u0003?A\u0002\u0019AA\u0012\u0011\u001d\ti\u0004\u0007a\u0001\u0003\u0003Bq!!\u0014\u0019\u0001\u0004\t\t\u0006C\u0004\u0002Za\u0001\r!!\u0018\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u00061\u0011\r^8nS\u000eTA!!$\u0002,\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u0015q\u0011\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0013%\u001c\u0018i\u0019;jm\u0016\u0004\u0013\u0001D0rk>$\u0018mQ8oM&<W#A<\u0002!}\u000bXo\u001c;b\u0007>tg-[4`I\u0015\fH\u0003BAO\u0003G\u00032!RAP\u0013\r\t\tK\u0012\u0002\u0005+:LG\u000f\u0003\u0005\u0002&r\t\t\u00111\u0001x\u0003\rAH%M\u0001\u000e?F,x\u000e^1D_:4\u0017n\u001a\u0011)\u0007u\tY\u000bE\u0002F\u0003[K1!a,G\u0005!1x\u000e\\1uS2,\u0017a\b;f]\u0006tGO\u0011:pW\u0016\u0014X*\u0019=Qe>$WoY3s\u0005f$XMU1uKV\u0011\u0011Q\u0017\t\b\u0003o\u000bI\fVA_\u001b\t\tY)\u0003\u0003\u0002<\u0006-%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019Q)a0\n\u0007\u0005\u0005gI\u0001\u0004E_V\u0014G.Z\u0001!i\u0016t\u0017M\u001c;Ce>\\WM]'bqB\u0013x\u000eZ;dKJ\u0014\u0015\u0010^3SCR,\u0007%A\u0010uK:\fg\u000e\u001e\"s_.,'/T1y\u0007>t7/^7fe\nKH/\u001a*bi\u0016\f\u0001\u0005^3oC:$(I]8lKJl\u0015\r_\"p]N,X.\u001a:CsR,'+\u0019;fA\u0005Y\u0011/^8uC\u000e{gNZ5h\u0003%\u0019X\r^!di&4X\r\u0006\u0003\u0002\u001e\u0006=\u0007bBAiG\u0001\u0007\u00111[\u0001\u0007C\u000e$\u0018N^3\u0011\u0007\u0015\u000b).C\u0002\u0002X\u001a\u0013qAQ8pY\u0016\fg.A\u000etKR\u0014%o\\6feJ+\u0007o\u001c:u\u001b&tWk]1hK6{G-\u001a\u000b\u0005\u0003;\u000bi\u000eC\u0004\u0002`\u0012\u0002\r!a5\u0002\u000f\u0015t\u0017M\u00197fI\u0006\u00113/\u001a;UK:\fg\u000e\u001e\"s_.,'/T1y!J|G-^2fe\nKH/\u001a*bi\u0016$b!!(\u0002f\u0006=\bbBAtK\u0001\u0007\u0011\u0011^\u0001\fi\u0016t\u0017M\u001c;JI>\u0003H\u000f\u0005\u0003F\u0003W$\u0016bAAw\r\n1q\n\u001d;j_:Dq!!=&\u0001\u0004\t\u00190\u0001\u000fce>\\WM]'bqB\u0013x\u000eZ;dKJ\u0014\u0015\u0010^3SCR,w\n\u001d;\u0011\u000b\u0015\u000bY/!0\u0002EM,G\u000fV3oC:$(I]8lKJl\u0015\r_\"p]N,X.\u001a:CsR,'+\u0019;f)\u0019\ti*!?\u0002|\"9\u0011q\u001d\u0014A\u0002\u0005%\bbBA\u007fM\u0001\u0007\u00111_\u0001\u001dEJ|7.\u001a:NCb\u001cuN\\:v[\u0016\u0014()\u001f;f%\u0006$Xm\u00149u\u0003e\tXo\u001c;bg\n\u0013xn[3s\u0019&l\u0017\u000e\u001e)s_\u0012,8-\u001a:\u0015\t\u0005u&1\u0001\u0005\u0007\u0005\u000b9\u0003\u0019\u0001+\u0002\rQ,g.\u00198u\u0003e\tXo\u001c;bg\n\u0013xn[3s\u0019&l\u0017\u000e^\"p]N,X.\u001a:\u0015\t\u0005u&1\u0002\u0005\u0007\u0005\u000bA\u0003\u0019\u0001+\u0002'\u001d,GO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;\u0015\r\u0005u&\u0011\u0003B\u000e\u0011\u001d\u0011\u0019\"\u000ba\u0001\u0005+\t\u0011\"];pi\u0006$\u0016\u0010]3\u0011\t\u0005\r#qC\u0005\u0005\u00053\t)EA\bDY&,g\u000e^)v_R\fG+\u001f9f\u0011\u001d\u0011i\"\u000ba\u0001\u0005?\t!\"\u001a8uSRLH+\u001f9f!\u0019\u0011\tCa\tU)6\u0011\u00111F\u0005\u0005\u0005K\tYCA\u0002NCB\fQbY8naV$X-U;pi\u0006\u001cH\u0003CAO\u0005W\u0011iC!\u0013\t\u000bAT\u0003\u0019\u0001:\t\u000f\t=\"\u00061\u0001\u00032\u0005a\u0011/^8uC\u0016sGO]5fgB1!1\u0007B\u001f\u0005\u0007rAA!\u000e\u0003:9\u0019qKa\u000e\n\u0003\u001dK1Aa\u000fG\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0010\u0003B\tA\u0011\n^3sC\ndWMC\u0002\u0003<\u0019\u00032!\u0011B#\u0013\r\u00119%\u000f\u0002\u001b#V|G/Y#oi&$\u00180\u00118e\u0007>t7/^7qi&|gn\u001d\u0005\b\u0005\u0017R\u0003\u0019\u0001B'\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004F\u0005\u001f\u0012\u0019&!(\n\u0007\tEcIA\u0005Gk:\u001cG/[8ocA\u0019\u0011I!\u0016\n\u0007\t]\u0013HA\tSKB|'\u000f^)v_R\f'+Z:vYR\f!%[:Es:\fW.[2Rk>$\u0018mQ8naV$X\r\u001a\"z\r2,\u0007PR1o_V$H\u0003BAj\u0005;BqAa\u0018,\u0001\u0004\u0011\t'A\u0006rk>$\u0018-\u00128uSRL\bcA!\u0003d%\u0019!QM\u001d\u0003\u0017E+x\u000e^1F]RLG/_\u0001\u000eI\u0016\u001c8M]5cKF+x\u000e^1\u0015\t\t-$1\u0011\t\b\u000b\n5$\u0011\u000fB?\u0013\r\u0011yG\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\tM$\u0011P\u0007\u0003\u0005kRAAa\u001e\u0002d\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003|\tU$AB#se>\u00148\u000fE\u0002B\u0005\u007fJ1A!!:\u0005A\tVo\u001c;b\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003`1\u0002\rA!\u0019\u0002%E,x\u000e^1t)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0005\u0013\u0003BA!\t\u0003\f&!!QRA\u0016\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004e\nM\u0005b\u0002B0]\u0001\u0007!\u0011M\u0001\u0014m\u0006d\u0017\u000eZ1uKF+x\u000e^1F]RLG/\u001f\u000b\u0005\u00053\u0013Y\nE\u0003F\u0003W\u0014\t\bC\u0004\u0003`=\u0002\rA!\u0019\u0002\u0015=tW\t\\3di&|g\u000e\u0006\u0004\u0002\u001e\n\u0005&Q\u0015\u0005\u0007\u0005G\u0003\u0004\u0019\u0001:\u0002+E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8JI\"1!q\u0015\u0019A\u0002I\f\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002\u001b=t'+Z:jO:\fG/[8o)\u0019\tiJ!,\u00030\"1!1U\u0019A\u0002IDqAa*2\u0001\u0004\u0011\t\f\u0005\u0003F\u0003W\u0014\u0018aB:uCJ$X\u000f\u001d\u000b\u0005\u0003;\u00139\fC\u0004\u0003:J\u0002\rAa/\u0002AI,GO]5fm\u0016\fVo\u001c;b)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\t\u0005\u000b\nu&/C\u0002\u0003@\u001a\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\u0011MDW\u000f\u001e3po:$\"!!(\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003;\u0013Y\rC\u0004\u0003NV\u0002\rAa4\u0002\u00139,woQ8oM&<\u0007cA6\u0003R&\u0019!1\u001b7\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\u001e\ne'Q\u001c\u0005\b\u000574\u0004\u0019\u0001Bh\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0003NZ\u0002\rAa4\u0002-%\u001c8\t\\5f]R\fVo\u001c;b)f\u0004XMV1mS\u0012$B!a5\u0003d\"1!Q]\u001cA\u0002Q\u000b\u0011a\u001d\u0005\u0007m\u0016\u0001\rAa4\t\u000f\u0005\u0005Q\u00011\u0001\u0002\u0006!9!Q^\u0003A\u0002\t=\u0018A\u0006;f]\u0006tG/T3ue&\u001c7\u000fU;cY&\u001c\b.\u001a:\u0011\u000b\u0015\u000bYO!=\u0011\t\tM8qA\u0007\u0003\u0005kTAAa>\u0003z\u0006I\u0001/\u001e2mSNDWM\u001d\u0006\u0005\u0005w\u0014i0A\u0003j[\u0006<WMC\u0002?\u0005\u007fTAa!\u0001\u0004\u0004\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0007\u000b\t!![8\n\t\r%!Q\u001f\u0002\u0017)\u0016t\u0017M\u001c;NKR\u0014\u0018nY:Qk\nd\u0017n\u001d5fe\"91QB\u0003A\u0002\r=\u0011aE7vYRLG+\u001a8b]RlU\r^1eCR\f\u0007#B#\u0002l\u000eE\u0001\u0003BB\n\u00073i!a!\u0006\u000b\t\r]\u0011QB\u0001\f[VdG/\u001b;f]\u0006tG/\u0003\u0003\u0004\u001c\rU!aE'vYRLG+\u001a8b]RlU\r^1eCR\f\u0007bBB\u0010\u000b\u0001\u00071\u0011E\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\rY71E\u0005\u0004\u0007Ka'A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003?)\u0001\u0019AA\u0012\u0011\u001d\ti$\u0002a\u0001\u0003\u0003Bq!!\u0014\u0006\u0001\u0004\t\t\u0006C\u0004\u00040\u0015\u0001\ra!\r\u0002\u000f5,GO]5dgB!11GB\u001c\u001b\t\u0019)D\u0003\u0003\u00040\u0005\r\u0014\u0002BB\u001d\u0007k\u0011q!T3ue&\u001c7\u000fC\u0004\u0002Z\u0015\u0001\r!!\u0018\u00025M,G\u000fV3oC:$(I]8lKJl\u0015\r\u001f\"zi\u0016\u0014\u0016\r^3\u0015\u0011\u0005u5\u0011IB$\u0007\u0013Bqaa\u0011\u0007\u0001\u0004\u0019)%A\fuK:\fg\u000e\u001e\"s_.,'/T1y\u0005f$XMU1uKB9!\u0011\u0005B\u0012)\u0006u\u0006bBAt\r\u0001\u0007\u0011\u0011\u001e\u0005\b\u0007\u00172\u0001\u0019AAz\u0003Q\u0011'o\\6fe6\u000b\u0007PQ=uKJ\u000bG/Z(qi\u00061\u0012/^8uC\u000e{wN\u001d3j]\u0006$xN]\"p]\u001aLw\rF\u0002x\u0007#BaA^\u0004A\u0002\t=\u0007")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final FlexFanoutQuotaManager flexFanoutManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile QuotaCoordinatorConfig _quotaConfig;
    private final ConcurrentHashMap<String, Object> tenantBrokerMaxProducerByteRate;
    private final ConcurrentHashMap<String, Object> tenantBrokerMaxConsumerByteRate;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig config, Scheduler scheduler, Option<TenantMetricsPublisher> tenantMetricsPublisher, Option<MultiTenantMetadata> multiTenantMetadata, ReplicaManager replicaManager, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, FlexFanoutQuotaManager flexFanoutManager, Metrics metrics, Time time) {
        return QuotaCoordinator$.MODULE$.apply(config, scheduler, tenantMetricsPublisher, multiTenantMetadata, replicaManager, internalAdminSupplier, clusterLevelQuotaCallback, flexFanoutManager, metrics, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        QuotaCoordinator quotaCoordinator = this;
        synchronized (quotaCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public FlexFanoutQuotaManager flexFanoutManager() {
        return this.flexFanoutManager;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    private QuotaCoordinatorConfig _quotaConfig() {
        return this._quotaConfig;
    }

    private void _quotaConfig_$eq(QuotaCoordinatorConfig x$1) {
        this._quotaConfig = x$1;
    }

    private ConcurrentHashMap<String, Object> tenantBrokerMaxProducerByteRate() {
        return this.tenantBrokerMaxProducerByteRate;
    }

    private ConcurrentHashMap<String, Object> tenantBrokerMaxConsumerByteRate() {
        return this.tenantBrokerMaxConsumerByteRate;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this._quotaConfig();
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public void setBrokerReportMinUsageMode(boolean enabled) {
        this._quotaConfig().enableBrokerReportMinUsageMode_$eq(enabled);
    }

    public void setTenantBrokerMaxProducerByteRate(Option<String> tenantIdOpt, Option<Object> brokerMaxProducerByteRateOpt) {
        QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$setTenantBrokerMaxByteRate(this.tenantBrokerMaxProducerByteRate(), tenantIdOpt, brokerMaxProducerByteRateOpt);
    }

    public void setTenantBrokerMaxConsumerByteRate(Option<String> tenantIdOpt, Option<Object> brokerMaxConsumerByteRateOpt) {
        QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$setTenantBrokerMaxByteRate(this.tenantBrokerMaxConsumerByteRate(), tenantIdOpt, brokerMaxConsumerByteRateOpt);
    }

    private double quotasBrokerLimitProducer(String tenant) {
        return BoxesRunTime.unboxToDouble(this.tenantBrokerMaxProducerByteRate().getOrDefault(tenant, BoxesRunTime.boxToDouble(this._quotaConfig().quotasBrokerLimitProducer())));
    }

    private double quotasBrokerLimitConsumer(String tenant) {
        return BoxesRunTime.unboxToDouble(this.tenantBrokerMaxConsumerByteRate().getOrDefault(tenant, BoxesRunTime.boxToDouble(this._quotaConfig().quotasBrokerLimitConsumer())));
    }

    private double getBrokerQuotaLimit(ClientQuotaType quotaType, java.util.Map<String, String> entityType) {
        String tenant;
        String string = tenant = entityType.get("tenant");
        String string2 = "lkc-internal-tenant";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ClientQuotaType clientQuotaType = quotaType;
            if (((Object)((Object)ClientQuotaType.FETCH)).equals((Object)clientQuotaType)) {
                return this._quotaConfig().quotasBrokerInternalLimitConsumer();
            }
            if (((Object)((Object)ClientQuotaType.PRODUCE)).equals((Object)clientQuotaType)) {
                return this._quotaConfig().quotasBrokerInternalLimitProducer();
            }
            throw new IllegalArgumentException("Not a client quota type: " + quotaType);
        }
        ClientQuotaType clientQuotaType = quotaType;
        if (((Object)((Object)ClientQuotaType.FETCH)).equals((Object)clientQuotaType)) {
            return this.quotasBrokerLimitConsumer(tenant);
        }
        if (((Object)((Object)ClientQuotaType.PRODUCE)).equals((Object)clientQuotaType)) {
            return this.quotasBrokerLimitProducer(tenant);
        }
        throw new IllegalArgumentException("Not a client quota type: " + quotaType);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply(new ReportQuotaResult(((IterableOnceOps)quotaEntries.map((Function1<QuotaEntityAndConsumptions, Tuple2> & Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntityAndConsumptions.entity()), Errors.COORDINATOR_NOT_AVAILABLE))).toMap($less$colon$less$.MODULE$.refl())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1<QuotaEntityAndConsumptions, Object> & Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String> & Serializable)() -> "Skipping quota computation for " + invalidQuotaEntries.size() + " quota entries because they failed validation");
        }
        scala.collection.immutable.Map<TopicPartition, Iterable<QuotaEntry>> quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1<QuotaEntry, TopicPartition> & Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas(quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1<Map, Object> & Serializable)responseStatus -> {
            this.storeQuotaCallback$1(responseStatus, quotaEntries, responseCallback, invalidQuotaEntries);
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public boolean isDynamicQuotaComputedByFlexFanout(QuotaEntity quotaEntity) {
        return this.flexFanoutManager().isDynamicQuotaComputedByFlexFanout(quotaEntity);
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2<Errors, QuotaDescription>(Errors.COORDINATOR_NOT_AVAILABLE, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Some some = (Some)option;
            Errors error = (Errors)((Object)some.value());
            return new Tuple2<Errors, QuotaDescription>(error, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                QuotaEntry quotaEntry = (QuotaEntry)some.value();
                scala.collection.immutable.Map brokerQuotaEntries = (scala.collection.immutable.Map)((MapOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(quotaEntry.computedQuotas()).asScala().filter((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        int brokerId = tuple2._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)tuple2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(brokerId)), ((MapOps)perBrokerQuotas.filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$3(this, x0$2)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 != null) {
                                String quotaType = (String)tuple2._1();
                                QuotaValue quotaValue = (QuotaValue)tuple2._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaType), BoxesRunTime.boxToDouble(quotaValue.quota()));
                            }
                            throw new MatchError(tuple2);
                        }).toMap($less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(tuple2);
                }).toMap($less$colon$less$.MODULE$.refl()).filter((Function1<Tuple2, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$5(x$2)));
                if (!brokerQuotaEntries.exists((Function1<Tuple2, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(QuotaCoordinator.$anonfun$describeQuota$6(x$3)))) {
                    return new Tuple2<Errors, QuotaDescription>(Errors.QUOTA_ENTITY_NOT_FOUND, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
                }
                return new Tuple2<Errors, QuotaDescription>(Errors.NONE, new QuotaDescription(brokerQuotaEntries));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2<Errors, QuotaDescription>(Errors.QUOTA_ENTITY_NOT_FOUND, new QuotaDescription((Map)scala.collection.Map$.MODULE$.empty()));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some<Errors>(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some<Errors>(Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String> & Serializable)() -> "Elected as the quota coordinator for partition " + quotaTopicPartitionId + " at epoch " + coordinatorEpoch);
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String> & Serializable)() -> "Resigned as the quota coordinator for partition " + quotaTopicPartitionId + " at epoch " + coordinatorEpoch);
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String> & Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, () -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String> & Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String> & Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.consumer.rate'  to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client internal bandwidth throttle config require 'confluent.quota.tenant.internal.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerInternalTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client internal bandwidth throttle config require 'confluent.quota.tenant.internal.broker.max.consumer.rate'  to be positive");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        QuotaCoordinatorConfig newQuotaConfig = QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig);
        this.quotaStateManager().reconfigure(newQuotaConfig);
        this._quotaConfig_$eq(newQuotaConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isClientQuotaTypeValid(String s) {
        String string = s;
        String string2 = ClientQuotaType.PRODUCE.toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = s;
        String string4 = ClientQuotaType.FETCH.toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ long $anonfun$computeQuotas$4(java.util.Map elasticCkuDef) {
        return elasticCkuDef.getOrDefault((Object)ElasticCkuDefinitionUtils.ElasticCkuDefinitionKey.TOTAL_THROUGHPUT, Predef$.MODULE$.int2Integer(0)).longValue();
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        boolean isValidQuotaType = $this.isClientQuotaTypeValid(quotaConsumption.quotaType());
        if (isValidQuotaType) {
            java.util.Map<String, String> entityType = CollectionConverters$.MODULE$.MapHasAsJava(quotaEntry$1.quotaEntity().entityTypes()).asJava();
            long totalPerECKUThroughputLimit = BoxesRunTime.unboxToLong(Option$.MODULE$.apply($this.clusterLevelQuotaCallback().elasticCkuDefinition(entityType)).map((Function1<java.util.Map, Object> & Serializable)elasticCkuDef -> BoxesRunTime.boxToLong(QuotaCoordinator.$anonfun$computeQuotas$4(elasticCkuDef))).getOrElse(() -> 0L));
            Double produceClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.PRODUCE, entityType);
            Double fetchClusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(ClientQuotaType.FETCH, entityType);
            double totalThroughputLimit = totalPerECKUThroughputLimit > 0L ? Predef$.MODULE$.Double2double(produceClusterQuotaLimit) + Predef$.MODULE$.Double2double(fetchClusterQuotaLimit) : 0.0;
            QuotaSnapshot produceQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.PRODUCE.toString(), Predef$.MODULE$.Double2double(produceClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.PRODUCE, entityType));
            QuotaSnapshot fetchQuotaSnapshot = new QuotaSnapshot(ClientQuotaType.FETCH.toString(), Predef$.MODULE$.Double2double(fetchClusterQuotaLimit), $this.getBrokerQuotaLimit(ClientQuotaType.FETCH, entityType));
            quotaEntry$1.updateConsumptionAndRecomputeQuotas($this.quotaConfig(), brokerId$1, quotaConsumption, produceQuotaSnapshot, fetchQuotaSnapshot, totalThroughputLimit, $this.flexFanoutManager(), $this.time().milliseconds());
            return;
        }
        quotaEntry$1.updateConsumption(brokerId$1, quotaConsumption, $this.time().milliseconds());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Some some = (Some)option;
            Errors error = (Errors)((Object)some.value());
            invalidQuotaEntries$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntityAndConsumptions.entity()), error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock(() -> quotaEntityAndConsumptions.consumptions().foreach((Function1<QuotaConsumption, Object> & Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq(quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((IterableOnceOps)quotaEntries$1.map((Function1<QuotaEntityAndConsumptions, Tuple2> & Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntry.entity()), responseStatus.getOrElse(BoxesRunTime.boxToInteger(this.partitionFor(quotaEntry.entity())), (Function0<Errors> & Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)))).toMap($less$colon$less$.MODULE$.refl());
        responseCallback$1.apply(new ReportQuotaResult((Map)entityResults.$plus$plus(invalidQuotaEntries$1)));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$3(QuotaCoordinator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String quotaType = (String)tuple2._1();
            return $this.isClientQuotaTypeValid(quotaType);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$5(Tuple2 x$2) {
        return ((IterableOnceOps)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$6(Tuple2 x$3) {
        return ((IterableOnceOps)x$3._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String> & Serializable)() -> "Failed to create topic _confluent-quotas with error " + t + ", retrying after 5 seconds");
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig config, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, FlexFanoutQuotaManager flexFanoutManager, Time time) {
        this.brokerId = brokerId;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.flexFanoutManager = flexFanoutManager;
        this.time = time;
        Logging.$init$(this);
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq("[QuotaCoordinator brokerId=" + brokerId + "]: ");
        this._quotaConfig = config;
        this.tenantBrokerMaxProducerByteRate = new ConcurrentHashMap();
        this.tenantBrokerMaxConsumerByteRate = new ConcurrentHashMap();
    }
}

