/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaSnapshot;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.server.FlexFanoutQuotaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.server.config.FlexFanoutMode;
import org.apache.kafka.server.quota.ClientQuotaType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\f\u0018\u0001yA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BA\u0002\u0013\u00051\u0007\u0003\u00058\u0001\t\u0005\r\u0011\"\u00019\u0011!q\u0004A!A!B\u0013!\u0004\"B\"\u0001\t\u0003!U\u0001\u0002%\u0001\t%Cqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004n\u0001\u0001\u0006I!\u0019\u0005\b]\u0002\u0011\r\u0011\"\u0001p\u0011\u0019I\b\u0001)A\u0005a\"9!\u0010\u0001b\u0001\n\u0013Y\bBB?\u0001A\u0003%A\u0010C\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a*\u0001\t\u0003\n)K\u0001\u0006Rk>$\u0018-\u00128uefT!\u0001G\r\u0002\u000bE,x\u000e^1\u000b\u0005iY\u0012aC2p_J$\u0017N\\1u_JT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!Z\u0012!B;uS2\u001c\u0018B\u0001\u0016(\u0005\u001daunZ4j]\u001e\f1\"];pi\u0006,e\u000e^5usV\tQ\u0006\u0005\u0002/_5\tq#\u0003\u00021/\tY\u0011+^8uC\u0016sG/\u001b;z\u00031\tXo\u001c;b\u000b:$\u0018\u000e^=!\u0003Qa\u0017m\u001d;Va\u0012\fG/\u001a3US6,7\u000f^1naV\tA\u0007\u0005\u0002!k%\u0011a'\t\u0002\u0005\u0019>tw-\u0001\rmCN$X\u000b\u001d3bi\u0016$G+[7fgR\fW\u000e]0%KF$\"!\u000f\u001f\u0011\u0005\u0001R\u0014BA\u001e\"\u0005\u0011)f.\u001b;\t\u000fu\"\u0011\u0011!a\u0001i\u0005\u0019\u0001\u0010J\u0019\u0002+1\f7\u000f^+qI\u0006$X\r\u001a+j[\u0016\u001cH/Y7qA!\u0012Q\u0001\u0011\t\u0003A\u0005K!AQ\u0011\u0003\u0011Y|G.\u0019;jY\u0016\fa\u0001P5oSRtDcA#G\u000fB\u0011a\u0006\u0001\u0005\u0006W\u0019\u0001\r!\f\u0005\u0006e\u0019\u0001\r\u0001\u000e\u0002\u0010!\u0016\u0014(I]8lKJ\fVo\u001c;bgB!!jT)]\u001b\u0005Y%B\u0001'N\u0003\u001diW\u000f^1cY\u0016T!AT\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Q\u0017\n\u0019Q*\u00199\u0011\u0005IKfBA*X!\t!\u0016%D\u0001V\u0015\t1V$\u0001\u0004=e>|GOP\u0005\u00031\u0006\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001,\t\t\u0003]uK!AX\f\u0003\u0015E+x\u000e^1WC2,X-\u0001\u0003m_\u000e\\W#A1\u0011\u0005\t\\W\"A2\u000b\u0005\u0011,\u0017!\u00027pG.\u001c(B\u00014h\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Q&\fA!\u001e;jY*\t!.\u0001\u0003kCZ\f\u0017B\u00017d\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006)An\\2lA\u0005q1m\\7qkR,G-U;pi\u0006\u001cX#\u00019\u0011\tE\u0014Ho^\u0007\u0002K&\u00111/\u001a\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u0011v\u0013\t1\u0018EA\u0002J]R\u0004\"\u0001_\u0004\u000e\u0003\u0001\tqbY8naV$X\rZ)v_R\f7\u000fI\u0001\u0015Y\u0006\u001cHOU3d_6\u0004X\u000f^3e)&lW-T:\u0016\u0003q\u0004B!\u001d:Ri\u0005)B.Y:u%\u0016\u001cw.\u001c9vi\u0016$G+[7f\u001bN\u0004\u0013AB5o\u0019>\u001c7.\u0006\u0003\u0002\u0002\u0005\u001dA\u0003BA\u0002\u00033\u0001B!!\u0002\u0002\b1\u0001AaBA\u0005\u001d\t\u0007\u00111\u0002\u0002\u0002)F!\u0011QBA\n!\r\u0001\u0013qB\u0005\u0004\u0003#\t#a\u0002(pi\"Lgn\u001a\t\u0004A\u0005U\u0011bAA\fC\t\u0019\u0011I\\=\t\u0011\u0005ma\u0002\"a\u0001\u0003;\t1AZ;o!\u0015\u0001\u0013qDA\u0002\u0013\r\t\t#\t\u0002\ty\tLh.Y7f}\u0005i\u0001/\u001e;Rk>$\u0018MV1mk\u0016$r!OA\u0014\u0003W\ty\u0003\u0003\u0004\u0002*=\u0001\r\u0001^\u0001\tEJ|7.\u001a:JI\"1\u0011QF\bA\u0002E\u000b\u0011\"];pi\u0006$\u0016\u0010]3\t\r\u0005Er\u00021\u0001]\u0003)\tXo\u001c;b-\u0006dW/Z\u0001\u000eO\u0016$\u0018+^8uCZ\u000bG.^3\u0015\r\u0005]\u0012QHA !\u0011\u0001\u0013\u0011\b/\n\u0007\u0005m\u0012E\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003S\u0001\u0002\u0019\u0001;\t\r\u00055\u0002\u00031\u0001R\u0003\r*\b\u000fZ1uK\u000e{gn];naRLwN\\!oIJ+7m\\7qkR,\u0017+^8uCN$\u0012#OA#\u0003\u001f\n\t&a\u0017\u0002f\u0005%\u00141OAB\u0011\u001d\t9%\u0005a\u0001\u0003\u0013\n1\"];pi\u0006\u001cuN\u001c4jOB\u0019a&a\u0013\n\u0007\u00055sC\u0001\fRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u000e{gNZ5h\u0011\u0019\tI#\u0005a\u0001i\"9\u00111K\tA\u0002\u0005U\u0013aC2p]N,X\u000e\u001d;j_:\u00042ALA,\u0013\r\tIf\u0006\u0002\u0011#V|G/Y\"p]N,X\u000e\u001d;j_:Dq!!\u0018\u0012\u0001\u0004\ty&\u0001\u000bqe>$WoY3Rk>$\u0018m\u00158baNDw\u000e\u001e\t\u0004]\u0005\u0005\u0014bAA2/\ti\u0011+^8uCNs\u0017\r]:i_RDq!a\u001a\u0012\u0001\u0004\ty&\u0001\ngKR\u001c\u0007.U;pi\u0006\u001cf.\u00199tQ>$\bbBA6#\u0001\u0007\u0011QN\u0001\u0015i>$\u0018\r\u001c+ie>,x\r\u001b9viF+x\u000e^1\u0011\u0007\u0001\ny'C\u0002\u0002r\u0005\u0012a\u0001R8vE2,\u0007bBA;#\u0001\u0007\u0011qO\u0001\u0012M2,\u0007PR1o_V$X*\u00198bO\u0016\u0014\b\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005u4$\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u0003\u000bYH\u0001\fGY\u0016Dh)\u00198pkR\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u0019\t))\u0005a\u0001i\u0005i1-\u001e:sK:$H+[7f\u001bN\f\u0011#\u001e9eCR,7i\u001c8tk6\u0004H/[8o)\u001dI\u00141RAG\u0003\u001fCa!!\u000b\u0013\u0001\u0004!\bbBA*%\u0001\u0007\u0011Q\u000b\u0005\u0007\u0003\u000b\u0013\u0002\u0019\u0001\u001b\u0002\u001fI,7m\\7qkR,\u0017+^8uCN$r\"OAK\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011\u0015\u0005\b\u0003\u000f\u001a\u0002\u0019AA%\u0011\u0019\tic\u0005a\u0001#\"9\u0011QL\nA\u0002\u0005}\u0003bBA4'\u0001\u0007\u0011q\f\u0005\b\u0003W\u001a\u0002\u0019AA7\u0011\u001d\t)h\u0005a\u0001\u0003oBa!!\"\u0014\u0001\u0004!\u0014\u0001F2p[B,H/\u001a3Rk>$\u0018m]*ue&tw\rF\u0001R\u0003!!xn\u0015;sS:<\u0007f\u0001\u0001\u0002,B\u0019a%!,\n\u0007\u0005=vEA\u0007o_:$\bN]3bIN\fg-\u001a")
public class QuotaEntry
implements Logging {
    private final QuotaEntity quotaEntity;
    private volatile long lastUpdatedTimestamp;
    private final ReentrantLock lock;
    private final ConcurrentHashMap<Object, Map<String, QuotaValue>> computedQuotas;
    private final ConcurrentHashMap<String, Object> lastRecomputedTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        QuotaEntry quotaEntry = this;
        synchronized (quotaEntry) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaEntity quotaEntity() {
        return this.quotaEntity;
    }

    public long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public void lastUpdatedTimestamp_$eq(long x$1) {
        this.lastUpdatedTimestamp = x$1;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public ConcurrentHashMap<Object, Map<String, QuotaValue>> computedQuotas() {
        return this.computedQuotas;
    }

    private ConcurrentHashMap<String, Object> lastRecomputedTimeMs() {
        return this.lastRecomputedTimeMs;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void putQuotaValue(int brokerId, String quotaType, QuotaValue quotaValue) {
        ((scala.collection.mutable.MapOps)this.computedQuotas().computeIfAbsent(BoxesRunTime.boxToInteger(brokerId), x$1 -> QuotaEntry.$anonfun$putQuotaValue$1(BoxesRunTime.unboxToInt(x$1)))).put(quotaType, quotaValue);
    }

    private Option<QuotaValue> getQuotaValue(int brokerId, String quotaType) {
        return ((MapOps)this.computedQuotas().computeIfAbsent(BoxesRunTime.boxToInteger(brokerId), x$2 -> QuotaEntry.$anonfun$getQuotaValue$1(BoxesRunTime.unboxToInt(x$2)))).get(quotaType);
    }

    public void updateConsumptionAndRecomputeQuotas(QuotaCoordinatorConfig quotaConfig, int brokerId, QuotaConsumption consumption, QuotaSnapshot produceQuotaSnapshot, QuotaSnapshot fetchQuotaSnapshot, double totalThroughputQuota, FlexFanoutQuotaManager flexFanoutManager, long currentTimeMs) {
        this.lastUpdatedTimestamp_$eq(currentTimeMs);
        this.updateConsumption(brokerId, consumption, currentTimeMs);
        if (!this.lastRecomputedTimeMs().contains(consumption.quotaType()) || currentTimeMs - BoxesRunTime.unboxToLong(this.lastRecomputedTimeMs().get(consumption.quotaType())) > quotaConfig.quotasRecomputeIntervalMs()) {
            this.debug((Function0<String> & Serializable)() -> "Recomputing " + consumption.quotaType() + " quotas with produceQuotaSnapshot=" + produceQuotaSnapshot + ", fetchQuotaSnapshot=" + fetchQuotaSnapshot + ".");
            this.recomputeQuotas(quotaConfig, consumption.quotaType(), produceQuotaSnapshot, fetchQuotaSnapshot, totalThroughputQuota, flexFanoutManager, currentTimeMs);
            return;
        }
    }

    public void updateConsumption(int brokerId, QuotaConsumption consumption, long currentTimeMs) {
        Option<QuotaValue> option = this.getQuotaValue(brokerId, consumption.quotaType());
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            quotaValue.updateConsumption(consumption, currentTimeMs);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            ((scala.collection.mutable.MapOps)this.computedQuotas().get(BoxesRunTime.boxToInteger(brokerId))).update(consumption.quotaType(), QuotaValue$.MODULE$.valueFromConsumption(consumption, currentTimeMs));
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    private void recomputeQuotas(QuotaCoordinatorConfig quotaConfig, String quotaType, QuotaSnapshot produceQuotaSnapshot, QuotaSnapshot fetchQuotaSnapshot, double totalThroughputQuota, FlexFanoutQuotaManager flexFanoutManager, long currentTimeMs) {
        block7: {
            block6: {
                var13_8 = this.computeThrottleTimeAndUsage$1(ClientQuotaType.PRODUCE.toString(), currentTimeMs, quotaConfig);
                if (var13_8 == null) {
                    throw new MatchError(var13_8);
                }
                totalProduceThrottleTimeMs = var13_8._1$mcD$sp();
                totalProduceAdjustedUsage = var13_8._2$mcD$sp();
                var12_11 = new Tuple2$mcDD$sp(totalProduceThrottleTimeMs, totalProduceAdjustedUsage);
                totalProduceThrottleTimeMs = var12_11._1$mcD$sp();
                totalProduceAdjustedUsage = var12_11._2$mcD$sp();
                var23_14 = this.computeThrottleTimeAndUsage$1(ClientQuotaType.FETCH.toString(), currentTimeMs, quotaConfig);
                if (var23_14 == null) {
                    throw new MatchError(var23_14);
                }
                totalFetchThrottleTimeMs = var23_14._1$mcD$sp();
                totalFetchAdjustedUsage = var23_14._2$mcD$sp();
                var22_17 = new Tuple2$mcDD$sp(totalFetchThrottleTimeMs, totalFetchAdjustedUsage);
                totalFetchThrottleTimeMs = var22_17._1$mcD$sp();
                totalFetchAdjustedUsage = var22_17._2$mcD$sp();
                if (!quotaConfig.flexibleFanoutEnabled()) break block6;
                v0 = ffMode = FlexFanoutMode.forName(quotaConfig.flexibleFanoutMode());
                var33_21 = FlexFanoutMode.TENANT_QUOTA;
                if (v0 != null ? v0.equals((Object)var33_21) == false : var33_21 != null) ** GOTO lbl-1000
                if (QuotaEntry.isAboveFlexFanoutLazyEvaluationThreshold$1(totalProduceAdjustedUsage, quotaConfig, produceQuotaSnapshot, totalFetchAdjustedUsage, fetchQuotaSnapshot) && totalThroughputQuota > (double)false) {
                    totalThroughputAdjustedUsage = totalProduceAdjustedUsage + totalFetchAdjustedUsage;
                    produceUsageRatio = totalProduceAdjustedUsage / totalThroughputAdjustedUsage;
                    fetchUsageRatio = totalFetchAdjustedUsage / totalThroughputAdjustedUsage;
                    produceQuotaSnapshot.totalQuota_$eq(totalThroughputQuota * produceUsageRatio);
                    fetchQuotaSnapshot.totalQuota_$eq(totalThroughputQuota * fetchUsageRatio);
                    this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$recomputeQuotas$10(kafka.coordinator.quota.QuotaEntry java.lang.String kafka.coordinator.quota.QuotaSnapshot kafka.coordinator.quota.QuotaSnapshot ), ()Ljava/lang/String;)((QuotaEntry)this, (String)quotaType, (QuotaSnapshot)produceQuotaSnapshot, (QuotaSnapshot)fetchQuotaSnapshot));
                    this.recomputeDynamicQuota$1(produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, quotaConfig);
                    this.recomputeDynamicQuota$1(fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
                } else if (flexFanoutManager.isDynamicQuotaComputedByFlexFanout(this.quotaEntity())) {
                    this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$recomputeQuotas$11(), ()Ljava/lang/String;)());
                } else {
                    this.runDynamicQuota$1(quotaType, produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
                }
                break block7;
            }
            this.runDynamicQuota$1(quotaType, produceQuotaSnapshot, totalProduceAdjustedUsage, totalProduceThrottleTimeMs, fetchQuotaSnapshot, totalFetchAdjustedUsage, totalFetchThrottleTimeMs, quotaConfig);
        }
        this.lastRecomputedTimeMs().put(quotaType, BoxesRunTime.boxToLong(currentTimeMs));
    }

    public String computedQuotasString() {
        if (this.computedQuotas().isEmpty()) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.computedQuotas()).asScala().foreach((Function1<Tuple2, StringBuilder> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int broker = tuple2._1$mcI$sp();
                Map perBrokerQuotas = (Map)tuple2._2();
                return res.append("{broker=" + broker + ",perBrokerQuotas=" + perBrokerQuotas + "},");
            }
            throw new MatchError(tuple2);
        });
        res.deleteCharAt(res.length() - 1);
        return res.toString();
    }

    public String toString() {
        StringBuilder res = new StringBuilder("QuotaEntry(").append("quotaEntity=").append(this.quotaEntity().entityTypes().toString()).append(", computedQuotas=(").append(this.computedQuotasString()).append(")").append(", lastUpdatedTimestamp=").append(this.lastUpdatedTimestamp()).append(")");
        return res.toString();
    }

    public static final /* synthetic */ Map $anonfun$putQuotaValue$1(int x$1) {
        return (Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Map $anonfun$getQuotaValue$1(int x$2) {
        return (Map)Map$.MODULE$.empty();
    }

    private static final double adjustedUsage$1(QuotaValue quotaValue, double totalThrottleTimeMs, QuotaCoordinatorConfig quotaConfig$1) {
        double adjustment = totalThrottleTimeMs > 0.0 && quotaValue.throttledTimeMs() > 0.0 ? Math.max(0.2, quotaConfig$1.quotaComputingUsageAdjustment() * quotaValue.throttledTimeMs() / totalThrottleTimeMs) : 0.0;
        return quotaValue.usage() * (1.0 + adjustment);
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$1(String quotaType$1, long currentTimeMs$1, QuotaCoordinatorConfig quotaConfig$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get(quotaType$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            if (quotaValue.lastUsageReportTimestamp() >= currentTimeMs$1 - (long)quotaConfig$1.quotasConsumptionExpirationTimeMs()) {
                return quotaValue.throttledTimeMs();
            }
            perBrokerQuota.remove(quotaType$1);
            return 0.0;
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$2(String quotaType$1, double totalThrottleTimeMs$1, QuotaCoordinatorConfig quotaConfig$1, Map perBrokerQuota) {
        Option option = perBrokerQuota.get(quotaType$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuotaValue quotaValue = (QuotaValue)some.value();
            return QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$1, quotaConfig$1);
        }
        if (None$.MODULE$.equals(option)) {
            return 0.0;
        }
        throw new MatchError(option);
    }

    private final Tuple2 computeThrottleTimeAndUsage$1(String quotaType, long currentTimeMs$1, QuotaCoordinatorConfig quotaConfig$1) {
        double totalThrottleTimeMs = BoxesRunTime.unboxToDouble(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.computedQuotas().values()).asScala().map((Function1<Map, Object> & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$1(quotaType, currentTimeMs$1, quotaConfig$1, perBrokerQuota)))).sum(Numeric.DoubleIsFractional$.MODULE$));
        double totalAdjustedUsage = BoxesRunTime.unboxToDouble(((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.computedQuotas().values()).asScala().map((Function1<Map, Object> & Serializable)perBrokerQuota -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$2(quotaType, totalThrottleTimeMs, quotaConfig$1, perBrokerQuota)))).sum(Numeric.DoubleIsFractional$.MODULE$));
        return new Tuple2$mcDD$sp(totalThrottleTimeMs, totalAdjustedUsage);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$4(String quotaType$2, double maxBrokerQuota$1, Map perBrokerQuotas) {
        perBrokerQuotas.get(quotaType$2).foreach((Function1<QuotaValue, Object> & Serializable)quotaValue -> {
            quotaValue.quota_$eq(maxBrokerQuota$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ double $anonfun$recomputeQuotas$6(String quotaType$2, double totalThrottleTimeMs$2, QuotaCoordinatorConfig quotaConfig$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Map perBrokerQuotas = (Map)tuple2._2();
            Option option = perBrokerQuotas.get(quotaType$2);
            if (option instanceof Some) {
                Some some = (Some)option;
                QuotaValue quotaValue = (QuotaValue)some.value();
                return (double)-1 * QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1);
            }
            if (None$.MODULE$.equals(option)) {
                return 0.0;
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$8(QuotaEntry $this, QuotaCoordinatorConfig quotaConfig$1, double totalThrottleTimeMs$2, DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, String quotaType$2, int brokerId$1, QuotaValue quotaValue) {
        double currentUsage = 0.0;
        if (quotaConfig$1.enableBrokerReportMinUsageMode()) {
            currentUsage = QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1);
        } else {
            double avgUsage = remainingUsage$1.elem / (double)$this.computedQuotas().size();
            double minUsageThreshold = package$.MODULE$.min((double)quotaConfig$1.quotaDynamicAdjustmentMinUsage(), avgUsage);
            currentUsage = package$.MODULE$.max(QuotaEntry.adjustedUsage$1(quotaValue, totalThrottleTimeMs$2, quotaConfig$1), minUsageThreshold);
        }
        quotaValue.quota_$eq(remainingUsage$1.elem > 0.0 ? remainingQuota$1.elem * (currentUsage / remainingUsage$1.elem) : 0.0);
        quotaValue.quota_$eq(package$.MODULE$.min(quotaValue.quota(), maxBrokerQuota$1));
        remainingQuota$1.elem -= quotaValue.quota();
        remainingUsage$1.elem -= currentUsage;
        $this.debug((Function0<String> & Serializable)() -> "Computed new " + quotaType$2 + " quota of " + quotaValue.quota() + " for " + $this.quotaEntity() + " with brokerId=" + brokerId$1 + ",remainingUsage=" + remainingUsage$1.elem + ",remainingQuota=" + remainingQuota$1.elem);
    }

    public static final /* synthetic */ void $anonfun$recomputeQuotas$7(QuotaEntry $this, String quotaType$2, QuotaCoordinatorConfig quotaConfig$1, double totalThrottleTimeMs$2, DoubleRef remainingUsage$1, DoubleRef remainingQuota$1, double maxBrokerQuota$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            Map perBrokerQuota = (Map)tuple2._2();
            perBrokerQuota.get(quotaType$2).foreach((Function1<QuotaValue, Object> & Serializable)quotaValue -> {
                QuotaEntry.$anonfun$recomputeQuotas$8($this, quotaConfig$1, totalThrottleTimeMs$2, remainingUsage$1, remainingQuota$1, maxBrokerQuota$1, quotaType$2, brokerId, quotaValue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    private final void recomputeDynamicQuota$1(QuotaSnapshot quotaSnapshot, double totalUsage, double totalThrottleTimeMs, QuotaCoordinatorConfig quotaConfig$1) {
        String quotaType = quotaSnapshot.quotaType();
        double maxBrokerQuota = quotaSnapshot.maxBrokerQuota();
        double totalQuota = quotaSnapshot.totalQuota();
        if (totalUsage <= quotaConfig$1.quotasLazyEvaluationThreshold() * totalQuota) {
            this.debug((Function0<String> & Serializable)() -> "Resetting " + quotaType + " quotas to " + maxBrokerQuota + " with totalUsage=" + totalUsage + ",lazyEvalThreshold=" + quotaConfig$1.quotasLazyEvaluationThreshold() + ",totalQuota=" + totalQuota);
            CollectionConverters$.MODULE$.CollectionHasAsScala(this.computedQuotas().values()).asScala().foreach((Function1<Map, Object> & Serializable)perBrokerQuotas -> {
                QuotaEntry.$anonfun$recomputeQuotas$4(quotaType, maxBrokerQuota, perBrokerQuotas);
                return BoxedUnit.UNIT;
            });
            return;
        }
        DoubleRef remainingUsage = DoubleRef.create(totalUsage);
        DoubleRef remainingQuota = DoubleRef.create(totalQuota);
        Seq sortedQuotas = (Seq)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.computedQuotas()).asScala().toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(QuotaEntry.$anonfun$recomputeQuotas$6(quotaType, totalThrottleTimeMs, quotaConfig$1, x0$1)), Ordering.DeprecatedDoubleOrdering$.MODULE$);
        sortedQuotas.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            QuotaEntry.$anonfun$recomputeQuotas$7(this, quotaType, quotaConfig$1, totalThrottleTimeMs, remainingUsage, remainingQuota, maxBrokerQuota, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isAboveFlexFanoutLazyEvaluationThreshold$1(double totalProduceAdjustedUsage$1, QuotaCoordinatorConfig quotaConfig$1, QuotaSnapshot produceQuotaSnapshot$2, double totalFetchAdjustedUsage$1, QuotaSnapshot fetchQuotaSnapshot$2) {
        return totalProduceAdjustedUsage$1 > quotaConfig$1.flexibleFanoutLazyEvaluationThreshold() * produceQuotaSnapshot$2.totalQuota() || totalFetchAdjustedUsage$1 > quotaConfig$1.flexibleFanoutLazyEvaluationThreshold() * fetchQuotaSnapshot$2.totalQuota();
    }

    private final void runDynamicQuota$1(String quotaType$3, QuotaSnapshot produceQuotaSnapshot$2, double totalProduceAdjustedUsage$1, double totalProduceThrottleTimeMs$1, QuotaSnapshot fetchQuotaSnapshot$2, double totalFetchAdjustedUsage$1, double totalFetchThrottleTimeMs$1, QuotaCoordinatorConfig quotaConfig$1) {
        String string = quotaType$3;
        String string2 = ClientQuotaType.PRODUCE.toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.recomputeDynamicQuota$1(produceQuotaSnapshot$2, totalProduceAdjustedUsage$1, totalProduceThrottleTimeMs$1, quotaConfig$1);
            return;
        }
        this.recomputeDynamicQuota$1(fetchQuotaSnapshot$2, totalFetchAdjustedUsage$1, totalFetchThrottleTimeMs$1, quotaConfig$1);
    }

    public static final /* synthetic */ String $anonfun$recomputeQuotas$10(QuotaEntry $this, String quotaType$3, QuotaSnapshot produceQuotaSnapshot$2, QuotaSnapshot fetchQuotaSnapshot$2) {
        return "Computed new " + quotaType$3 + " cluster quota due to flex fanout for " + $this.quotaEntity() + " ofproduceQuota=" + produceQuotaSnapshot$2.totalQuota() + ", fetchQuota=" + fetchQuotaSnapshot$2.totalQuota();
    }

    public static final /* synthetic */ String $anonfun$recomputeQuotas$11() {
        return "Dynamic quota is not recomputed because flex fanout is running in " + FlexFanoutMode.BROKER_QUOTA + " mode.";
    }

    public QuotaEntry(QuotaEntity quotaEntity, long lastUpdatedTimestamp) {
        this.quotaEntity = quotaEntity;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        Logging.$init$(this);
        this.logIdent_$eq("[QuotaEntry quotaEntity=" + quotaEntity + "]: ");
        this.lock = new ReentrantLock();
        this.computedQuotas = new ConcurrentHashMap();
        this.lastRecomputedTimeMs = new ConcurrentHashMap();
    }
}

