/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PendingCompleteTxn;
import kafka.coordinator.transaction.PendingCompleteTxnAndMarkerEntry;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.InterBrokerSendThread;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tmv!\u0002\u00180\u0011\u00031d!\u0002\u001d0\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%Ia\u0011\u0005\u0007\u0019\u0006\u0001\u000b\u0011\u0002#\t\u000f5\u000b!\u0019!C\u0005\u0007\"1a*\u0001Q\u0001\n\u0011C\u0001bT\u0001C\u0002\u0013\u0005q\u0006\u0015\u0005\u00073\u0006\u0001\u000b\u0011B)\t\u000bi\u000bA\u0011A.\u0007\taz\u0003!\u0018\u0005\tc*\u0011\t\u0011)A\u0005e\"AqO\u0003B\u0001B\u0003%\u0001\u0010\u0003\u0005\u007f\u0015\t\u0005\t\u0015!\u0003\u0000\u0011)\tYA\u0003B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003'Q!\u0011!Q\u0001\n\u0005U\u0001B\u0002!\u000b\t\u0003\t\u0019\u0003C\u0005\u00020)\u0011\r\u0011\"\u0003\u00022!A\u0011q\b\u0006!\u0002\u0013\t\u0019\u0004C\u0005\u0002B)\u0011\r\u0011\"\u0003\u0002D!A\u0011\u0011\u000b\u0006!\u0002\u0013\t)\u0005C\u0005\u0002T)\u0011\r\u0011\"\u0003\u0002V!A\u0011q\u000e\u0006!\u0002\u0013\t9\u0006C\u0005\u0002r)\u0011\r\u0011\"\u0003\u0002t!A\u0011Q\u000f\u0006!\u0002\u0013\tI\u0007C\u0005\u0002x)\u0011\r\u0011\"\u0003\u0002z!A\u0011Q\u0012\u0006!\u0002\u0013\tY\bC\u0005\u0002\u0010*\u0011\r\u0011\"\u0003\u0002\u0012\"A\u0011Q\u0016\u0006!\u0002\u0013\t\u0019\nC\u0004\u00020*!\t%!-\t\u000f\u0005e&\u0002\"\u0003\u00022\"A\u00111\u0018\u0006\u0005\u0002=\ni\f\u0003\u0005\u0002J*!\taLA:\u0011!\tYM\u0003C\u0001_\u00055\u0007bBAu\u0015\u0011%\u0011\u0011\u0017\u0005\b\u0003WTA\u0011IAw\u0011\u001d\tiP\u0003C\u0005\u0003\u007fDqA!\u0002\u000b\t\u0003\u00119\u0001C\u0004\u00038)!\tA!\u000f\t\u000f\tm\"\u0002\"\u0003\u0003>!9!q\t\u0006\u0005\u0002\t%\u0003b\u0002B(\u0015\u0011%!\u0011\u000b\u0005\b\u0005/RA\u0011\u0001B-\u0011\u001d\u0011\tI\u0003C\u0001\u0005\u0007CqA!#\u000b\t\u0003\u0011Y\t\u0003\u0007\u0003\u0010*\u0001\n\u0011!A\u0001\n\u0003\u0011\t*A\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!\u0001M\u0019\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003eM\n1bY8pe\u0012Lg.\u0019;pe*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005]\nQ\"A\u0018\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'o\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0002KUs7N\\8x]\u0012+7\u000f^5oCRLwN\\)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00027b]\u001eT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n11\u000b\u001e:j]\u001e\fa%\u00168l]><h\u000eR3ti&t\u0017\r^5p]F+X-^3TSj,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005bunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7f\u0003\tbunZ!qa\u0016tGMU3uef\fV/Z;f'&TX-T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\u0005\t\u0006c\u0001*X\t6\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-r\n!bY8mY\u0016\u001cG/[8o\u0013\tA6KA\u0002TKR\fA\"T3ue&\u001cg*Y7fg\u0002\nQ!\u00199qYf$R\u0002\u0018BO\u0005?\u0013YK!,\u00030\nE\u0006CA\u001c\u000b'\rQal\u001b\t\u0003?&l\u0011\u0001\u0019\u0006\u0003C\n\fA!\u001e;jY*\u00111\rZ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Q*'B\u00014h\u0003\u0019\t\u0007/Y2iK*\t\u0001.A\u0002pe\u001eL!A\u001b1\u0003+%sG/\u001a:Ce>\\WM]*f]\u0012$\u0006N]3bIB\u0011An\\\u0007\u0002[*\u0011anM\u0001\u0006kRLGn]\u0005\u0003a6\u0014q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003gVl\u0011\u0001\u001e\u0006\u0003GNJ!A\u001e;\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005edX\"\u0001>\u000b\u0005m$\u0017\u0001C7fi\u0006$\u0017\r^1\n\u0005uT(!D'fi\u0006$\u0017\r^1DC\u000eDW-A\u0007oKR<xN]6DY&,g\u000e\u001e\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00013\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011BA\u0002\u00055qU\r^<pe.\u001cE.[3oi\u0006yA\u000f\u001f8Ti\u0006$X-T1oC\u001e,'\u000fE\u00028\u0003\u001fI1!!\u00050\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'/\u0001\u0003uS6,\u0007\u0003BA\f\u0003?i!!!\u0007\u000b\u00079\fYBC\u0002\u0002\u001e\u0011\faaY8n[>t\u0017\u0002BA\u0011\u00033\u0011A\u0001V5nKRYA,!\n\u0002(\u0005%\u00121FA\u0017\u0011\u0015\t\b\u00031\u0001s\u0011\u00159\b\u00031\u0001y\u0011\u0015q\b\u00031\u0001\u0000\u0011\u001d\tY\u0001\u0005a\u0001\u0003\u001bAq!a\u0005\u0011\u0001\u0004\t)\"\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\t\fq!\\3ue&\u001c7/\u0003\u0003\u0002>\u0005]\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\nq#\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\t\u0005-\u00131D\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ty%!\u0013\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u00021%tG/\u001a:Ce>\\WM\u001d'jgR,g.\u001a:OC6,\u0007%A\u000bnCJ\\WM]:Rk\u0016,X\rU3s\u0005J|7.\u001a:\u0016\u0005\u0005]\u0003\u0003CA-\u0003?\n\u0019'!\u001b\u000e\u0005\u0005m#bAA/+\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0005\u00141\f\u0002\u0004\u001b\u0006\u0004\bcA\u001e\u0002f%\u0019\u0011q\r\u001f\u0003\u0007%sG\u000fE\u00028\u0003WJ1!!\u001c0\u00059!\u0006P\\'be.,'/U;fk\u0016\fa#\\1sW\u0016\u00148/U;fk\u0016\u0004VM\u001d\"s_.,'\u000fI\u0001\u001d[\u0006\u00148.\u001a:t#V,W/\u001a$peVs7N\\8x]\n\u0013xn[3s+\t\tI'A\u000fnCJ\\WM]:Rk\u0016,XMR8s+:\\gn\\<o\u0005J|7.\u001a:!\u0003Y!\bP\u001c'pO\u0006\u0003\b/\u001a8e%\u0016$(/_)vKV,WCAA>!\u0019\ti(a!\u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003;\n\tI\u0003\u0002b\u0011&!\u0011QQA@\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f!\r9\u0014\u0011R\u0005\u0004\u0003\u0017{#A\u0005)f]\u0012LgnZ\"p[BdW\r^3Uq:\fq\u0003\u001e=o\u0019><\u0017\t\u001d9f]\u0012\u0014V\r\u001e:z#V,W/\u001a\u0011\u0002=Q\u0014\u0018M\\:bGRLwN\\:XSRD\u0007+\u001a8eS:<W*\u0019:lKJ\u001cXCAAJ!!\ti(!&\u0002\u001a\u0006\u001d\u0015\u0002BAL\u0003\u007f\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\tY*!+\u000f\t\u0005u\u0015Q\u0015\t\u0004\u0003?cTBAAQ\u0015\r\t\u0019+N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001dF(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0017\u0006-&bAATy\u0005yBO]1og\u0006\u001cG/[8og^KG\u000f\u001b)f]\u0012LgnZ'be.,'o\u001d\u0011\u0002\u0011MDW\u000f\u001e3po:$\"!a-\u0011\u0007m\n),C\u0002\u00028r\u0012A!\u00168ji\u0006i!/Z7pm\u0016lU\r\u001e:jGN\fa\"];fk\u00164uN\u001d\"s_.,'\u000f\u0006\u0003\u0002@\u0006\u0015\u0007#B\u001e\u0002B\u0006%\u0014bAAby\t1q\n\u001d;j_:Dq!a2 \u0001\u0004\t\u0019'\u0001\u0005ce>\\WM]%e\u0003U\tX/Z;f\r>\u0014XK\\6o_^t'I]8lKJ\f1#\u00193e\u001b\u0006\u00148.\u001a:t\r>\u0014(I]8lKJ$\u0002\"a-\u0002P\u0006m\u0017q\u001c\u0005\b\u0003#\f\u0003\u0019AAj\u0003\u0019\u0011'o\\6feB!\u0011Q[Al\u001b\t\tY\"\u0003\u0003\u0002Z\u0006m!\u0001\u0002(pI\u0016Dq!!8\"\u0001\u0004\t\u0019'A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!9\"\u0001\u0004\t\u0019/A\u000eqK:$\u0017N\\4D_6\u0004H.\u001a;f)bt\u0017I\u001c3NCJ\\WM\u001d\t\u0004o\u0005\u0015\u0018bAAt_\t\u0001\u0003+\u001a8eS:<7i\\7qY\u0016$X\r\u0016=o\u0003:$W*\u0019:lKJ,e\u000e\u001e:z\u0003=\u0011X\r\u001e:z\u0019><\u0017\t\u001d9f]\u0012\u001c\u0018\u0001E4f]\u0016\u0014\u0018\r^3SKF,Xm\u001d;t)\t\ty\u000f\u0005\u0004\u0002r\u0006M\u0018q_\u0007\u0003\u0003\u0003KA!!>\u0002\u0002\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007}\u000bI0C\u0002\u0002|\u0002\u00141DU3rk\u0016\u001cH/\u00118e\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018AE<sSR,G\u000b\u001f8D_6\u0004H.\u001a;j_:$B!a-\u0003\u0002!9!1\u0001\u0013A\u0002\u0005\u001d\u0015A\u00059f]\u0012LgnZ\"p[BdW\r^3Uq:\f1#\u00193e)btW*\u0019:lKJ\u001cHk\\*f]\u0012$\"\"a-\u0003\n\t5!Q\u0004B\u0014\u0011\u001d\u0011Y!\na\u0001\u0003G\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\t=Q\u00051\u0001\u0003\u0012\u0005IA\u000f\u001f8SKN,H\u000e\u001e\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)!!qCA\u000e\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B\u000e\u0005+\u0011\u0011\u0003\u0016:b]N\f7\r^5p]J+7/\u001e7u\u0011\u001d\u0011y\"\na\u0001\u0005C\t1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCB\u0019qGa\t\n\u0007\t\u0015rFA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rC\u0004\u0003*\u0015\u0002\rAa\u000b\u0002\u00179,w/T3uC\u0012\fG/\u0019\t\u0005\u0005[\u0011\u0019$\u0004\u0002\u00030)\u0019\u0001G!\r\u000b\u0005I\"\u0017\u0002\u0002B\u001b\u0005_\u0011!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006Ib.^7Uq:\u001cx+\u001b;i!\u0016tG-\u001b8h\u001b\u0006\u00148.\u001a:t+\t\t\u0019'\u0001\riCN\u0004VM\u001c3j]\u001el\u0015M]6feN$vn\u0016:ji\u0016$BAa\u0010\u0003FA\u00191H!\u0011\n\u0007\t\rCHA\u0004C_>dW-\u00198\t\u000f\t}q\u00051\u0001\u0003\"\u00059R.Y=cK^\u0013\u0018\u000e^3Uq:\u001cu.\u001c9mKRLwN\u001c\u000b\u0005\u0003g\u0013Y\u0005C\u0004\u0003N!\u0002\r!!'\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fa\u0002\u001e:z\u0003B\u0004XM\u001c3U_2{w\r\u0006\u0003\u00024\nM\u0003b\u0002B+S\u0001\u0007\u0011qQ\u0001\ribtGj\\4BaB,g\u000eZ\u0001\u001bC\u0012$G\u000b\u001f8NCJ\\WM]:U_\n\u0013xn[3s#V,W/\u001a\u000b\r\u0003g\u0013YF!\u001a\u0003p\tM$Q\u000f\u0005\b\u0005;R\u0003\u0019\u0001B0\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\t\u0004w\t\u0005\u0014b\u0001B2y\t!Aj\u001c8h\u0011\u001d\u00119G\u000ba\u0001\u0005S\nQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\u001e\u0003l%\u0019!Q\u000e\u001f\u0003\u000bMCwN\u001d;\t\u000f\tE$\u00061\u0001\u0003\u0012\u00051!/Z:vYRDqAa\u0001+\u0001\u0004\t9\tC\u0004\u0003x)\u0002\rA!\u001f\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004BAU,\u0003|A!\u0011Q\u001bB?\u0013\u0011\u0011y(a\u0007\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\t#/Z7pm\u0016l\u0015M]6feN4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R!\u00111\u0017BC\u0011\u001d\u00119i\u000ba\u0001\u0003G\n1\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012\f1C]3n_Z,W*\u0019:lKJ\u001chi\u001c:Uq:$B!a-\u0003\u000e\"9!1\u0001\u0017A\u0002\u0005\u001d\u0015!\b9s_R,7\r^3eI!\f7/\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0015\t\tM%\u0011\u0014\u000b\u0005\u0005\u007f\u0011)\nC\u0004\u0003\u00186\u0002\r!a5\u0002\t9|G-\u001a\u0005\t\u00057k\u0013\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\t\u000bEL\u0001\u0019\u0001:\t\u000f\u0005e\u0012\u00021\u0001\u0003\"B!!1\u0015BT\u001b\t\u0011)K\u0003\u0003\u0002:\u0005m\u0011\u0002\u0002BU\u0005K\u0013q!T3ue&\u001c7\u000fC\u0003x\u0013\u0001\u0007\u0001\u0010C\u0004\u0002\f%\u0001\r!!\u0004\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016!9!1W\u0005A\u0002\tU\u0016A\u00037pO\u000e{g\u000e^3yiB!\u0011q\u0003B\\\u0013\u0011\u0011I,!\u0007\u0003\u00151{wmQ8oi\u0016DH\u000f")
public class TransactionMarkerChannelManager
extends InterBrokerSendThread
implements Logging {
    private final MetadataCache metadataCache;
    private final TransactionStateManager txnStateManager;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private final ListenerName interBrokerListenerName;
    private final scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker;
    private final TxnMarkerQueue markersQueueForUnknownBroker;
    private final LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue;
    private final ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionMarkerChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, TransactionStateManager txnStateManager, Time time, LogContext logContext) {
        return TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, txnStateManager, time, logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionMarkerChannelManager transactionMarkerChannelManager = this;
        synchronized (transactionMarkerChannelManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public /* synthetic */ boolean protected$hasInFlightRequests(TransactionMarkerChannelManager x$1, Node node) {
        return x$1.hasInFlightRequests(node);
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private ListenerName interBrokerListenerName() {
        return this.interBrokerListenerName;
    }

    private scala.collection.concurrent.Map<Object, TxnMarkerQueue> markersQueuePerBroker() {
        return this.markersQueuePerBroker;
    }

    private TxnMarkerQueue markersQueueForUnknownBroker() {
        return this.markersQueueForUnknownBroker;
    }

    private LinkedBlockingQueue<PendingCompleteTxn> txnLogAppendRetryQueue() {
        return this.txnLogAppendRetryQueue;
    }

    private ConcurrentHashMap<String, PendingCompleteTxn> transactionsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers;
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
            this.markersQueuePerBroker().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    private void removeMetrics() {
        TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1<String, Object> & Serializable)name -> {
            TransactionMarkerChannelManager.$anonfun$removeMetrics$1(this, name);
            return BoxedUnit.UNIT;
        });
    }

    public Option<TxnMarkerQueue> queueForBroker(int brokerId) {
        return this.markersQueuePerBroker().get(BoxesRunTime.boxToInteger(brokerId));
    }

    public TxnMarkerQueue queueForUnknownBroker() {
        return this.markersQueueForUnknownBroker();
    }

    public void addMarkersForBroker(Node broker, int txnTopicPartition, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        int brokerId = broker.id();
        TxnMarkerQueue brokerRequestQueue = this.markersQueuePerBroker().getOrElseUpdate(BoxesRunTime.boxToInteger(brokerId), (Function0<TxnMarkerQueue> & Serializable)() -> {
            this.info((Function0<String> & Serializable)() -> "Creating new marker queue map to destination broker " + brokerId);
            return new TxnMarkerQueue(broker);
        });
        brokerRequestQueue.destination_$eq(broker);
        brokerRequestQueue.addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
        this.trace((Function0<String> & Serializable)() -> "Added marker " + pendingCompleteTxnAndMarker.txnMarkerEntry() + " for transactional id " + pendingCompleteTxnAndMarker.pendingCompleteTxn().transactionalId() + " to destination broker " + brokerId);
    }

    private void retryLogAppends() {
        ArrayList txnLogAppendRetries = new ArrayList();
        this.txnLogAppendRetryQueue().drainTo(txnLogAppendRetries);
        txnLogAppendRetries.forEach(txnLogAppend -> {
            this.debug((Function0<String> & Serializable)() -> "Retry appending " + txnLogAppend + " transaction log");
            this.tryAppendToLog((PendingCompleteTxn)txnLogAppend);
        });
    }

    @Override
    public Collection<RequestAndCompletionHandler> generateRequests() {
        this.retryLogAppends();
        ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
        this.markersQueueForUnknownBroker().forEachTxnTopicPartition((Function2<Object, BlockingQueue, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger(TransactionMarkerChannelManager.$anonfun$generateRequests$1(pendingCompleteTxnAndMarkerEntries, BoxesRunTime.unboxToInt(x0$1), x1$1)));
        CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarkerEntries).asScala().withFilter((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TransactionMarkerChannelManager.$anonfun$generateRequests$2(check$ifrefutable$1))).foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)pendingCompleteTxnAndMarker -> {
            TransactionMarkerChannelManager.$anonfun$generateRequests$3(this, pendingCompleteTxnAndMarker);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = this.time.milliseconds();
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOps)((IterableOps)((IterableOps)this.markersQueuePerBroker().values().filter((Function1<TxnMarkerQueue, Object> & Serializable)brokerRequestQueue -> BoxesRunTime.boxToBoolean(TransactionMarkerChannelManager.$anonfun$generateRequests$4(this, brokerRequestQueue)))).map((Function1<TxnMarkerQueue, Tuple2> & Serializable)brokerRequestQueue -> {
            ArrayList pendingCompleteTxnAndMarkerEntries = new ArrayList();
            brokerRequestQueue.forEachTxnTopicPartition((Function2<Object, BlockingQueue, Object> & Serializable)(x0$2, x1$2) -> BoxesRunTime.boxToInteger(TransactionMarkerChannelManager.$anonfun$generateRequests$6(pendingCompleteTxnAndMarkerEntries, BoxesRunTime.unboxToInt(x0$2), x1$2)));
            return new Tuple2(brokerRequestQueue.destination(), pendingCompleteTxnAndMarkerEntries);
        })).filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(TransactionMarkerChannelManager.$anonfun$generateRequests$7(x0$3)))).map((Function1<Tuple2, RequestAndCompletionHandler> & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Node node = (Node)tuple2._1();
                ArrayList entries = (ArrayList)tuple2._2();
                List<WriteTxnMarkersRequest.TxnMarkerEntry> markersToSend = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(entries).asScala().map((Function1<PendingCompleteTxnAndMarkerEntry, WriteTxnMarkersRequest.TxnMarkerEntry> & Serializable)x$4 -> x$4.txnMarkerEntry())).asJava();
                TransactionMarkerRequestCompletionHandler requestCompletionHandler = new TransactionMarkerRequestCompletionHandler(node.id(), $this.txnStateManager, this, entries);
                WriteTxnMarkersRequest.Builder request = new WriteTxnMarkersRequest.Builder(markersToSend);
                return new RequestAndCompletionHandler(currentTimeMs, node, request, requestCompletionHandler, Optional.empty());
            }
            throw new MatchError(tuple2);
        })).asJavaCollection();
    }

    private void writeTxnCompletion(PendingCompleteTxn pendingCompleteTxn) {
        Option option;
        Errors errors;
        String transactionalId = pendingCompleteTxn.transactionalId();
        TransactionMetadata txnMetadata = pendingCompleteTxn.txnMetadata();
        TxnTransitMetadata newMetadata = pendingCompleteTxn.newMetadata();
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        this.trace((Function0<String> & Serializable)() -> "Completed sending transaction markers for " + transactionalId + "; begin transition to " + newMetadata.txnState());
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)((Object)left.value());
            if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors2)) {
                this.info((Function0<String> & Serializable)() -> "No longer the coordinator for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel appending " + newMetadata + " to transaction log");
                return;
            }
        }
        if (bl && ((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)(errors = (Errors)((Object)left.value())))) {
            this.info((Function0<String> & Serializable)() -> "Loading the transaction partition that contains " + transactionalId + " while my current coordinator epoch is " + coordinatorEpoch + "; so cancel appending " + newMetadata + " to transaction log since the loading process will continue the remaining work");
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)((Object)left.value());
            throw new IllegalStateException("Unhandled error " + unexpectedError + " when fetching current transaction state");
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch) {
                    this.debug((Function0<String> & Serializable)() -> "Sending " + transactionalId + "'s transaction markers for " + txnMetadata + " with coordinator epoch " + coordinatorEpoch + " succeeded, trying to append complete transaction log now");
                    this.tryAppendToLog(new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata));
                    return;
                }
                this.info((Function0<String> & Serializable)() -> "The cached metadata " + txnMetadata + " has changed to " + epochAndMetadata + " after completed sending the markers with coordinator epoch " + coordinatorEpoch + "; abort transiting the metadata to " + newMetadata + " as it may have been updated by another process");
                return;
            }
        }
        if (bl2 && None$.MODULE$.equals(option = (Option)right.value())) {
            String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
            this.fatal((Function0<String> & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError(either);
    }

    public void addTxnMarkersToSend(int coordinatorEpoch, TransactionResult txnResult, TransactionMetadata txnMetadata, TxnTransitMetadata newMetadata) {
        String transactionalId = txnMetadata.transactionalId();
        PendingCompleteTxn pendingCompleteTxn = new PendingCompleteTxn(transactionalId, coordinatorEpoch, txnMetadata, newMetadata);
        PendingCompleteTxn prev = this.transactionsWithPendingMarkers().put(transactionalId, pendingCompleteTxn);
        if (prev != null) {
            this.info((Function0<String> & Serializable)() -> "Replaced an existing pending complete txn " + prev + " with " + pendingCompleteTxn + " while adding markers to send.");
        }
        this.addTxnMarkersToBrokerQueue(txnMetadata.producerId(), txnMetadata.producerEpoch(), txnResult, pendingCompleteTxn, txnMetadata.topicPartitions().toSet());
        this.maybeWriteTxnCompletion(transactionalId);
    }

    public int numTxnsWithPendingMarkers() {
        return this.transactionsWithPendingMarkers().size();
    }

    private boolean hasPendingMarkersToWrite(TransactionMetadata txnMetadata) {
        return BoxesRunTime.unboxToBoolean(txnMetadata.inLock(() -> txnMetadata.topicPartitions().nonEmpty()));
    }

    public void maybeWriteTxnCompletion(String transactionalId) {
        Option$.MODULE$.apply(this.transactionsWithPendingMarkers().get(transactionalId)).foreach((Function1<PendingCompleteTxn, Object> & Serializable)pendingCompleteTxn -> {
            TransactionMarkerChannelManager.$anonfun$maybeWriteTxnCompletion$1(this, transactionalId, pendingCompleteTxn);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAppendToLog(PendingCompleteTxn txnLogAppend) {
        this.txnStateManager.appendTransactionToLog(txnLogAppend.transactionalId(), txnLogAppend.coordinatorEpoch(), txnLogAppend.newMetadata(), (Function1<Errors, BoxedUnit>)(Function1<Errors, Object> & Serializable)error -> {
            this.appendCallback$1(error, txnLogAppend);
            return BoxedUnit.UNIT;
        }, (Function1<Errors, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(TransactionMarkerChannelManager.$anonfun$tryAppendToLog$7(x$5)), RequestLocal.noCaching());
    }

    public void addTxnMarkersToBrokerQueue(long producerId, short producerEpoch, TransactionResult result, PendingCompleteTxn pendingCompleteTxn, Set<TopicPartition> topicPartitions) {
        int txnTopicPartition = this.txnStateManager.partitionFor(pendingCompleteTxn.transactionalId());
        Map partitionsByDestination = topicPartitions.groupBy((Function1<TopicPartition, Option> & Serializable)topicPartition -> OptionConverters$.MODULE$.toScala($this.metadataCache.getPartitionLeaderEndpoint(topicPartition.topic(), topicPartition.partition(), this.interBrokerListenerName())));
        int coordinatorEpoch = pendingCompleteTxn.coordinatorEpoch();
        partitionsByDestination.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(TransactionMarkerChannelManager.$anonfun$addTxnMarkersToBrokerQueue$2(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                Option broker = (Option)tuple2._1();
                Set topicPartitions = (Set)tuple2._2();
                if (broker != null) {
                    Option option = broker;
                    if (topicPartitions != null) {
                        Set set = topicPartitions;
                        Option option2 = option;
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            Node brokerNode = (Node)some.value();
                            WriteTxnMarkersRequest.TxnMarkerEntry marker = new WriteTxnMarkersRequest.TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, CollectionConverters$.MODULE$.SeqHasAsJava(set.toList()).asJava());
                            PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker = new PendingCompleteTxnAndMarkerEntry(pendingCompleteTxn, marker);
                            Node node = brokerNode;
                            Node node2 = Node.noNode();
                            if (!(node != null ? !((Object)node).equals(node2) : node2 != null)) {
                                this.markersQueueForUnknownBroker().addMarkers(txnTopicPartition, pendingCompleteTxnAndMarker);
                                return BoxedUnit.UNIT;
                            }
                            this.addMarkersForBroker(brokerNode, txnTopicPartition, pendingCompleteTxnAndMarker);
                            return BoxedUnit.UNIT;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            Option option3;
                            String transactionalId = pendingCompleteTxn.transactionalId();
                            boolean bl = false;
                            Right right = null;
                            Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
                            if (either instanceof Left) {
                                Left left = (Left)either;
                                Errors error = (Errors)((Object)((Object)left.value()));
                                this.info((Function0<String> & Serializable)() -> "Encountered " + error + " trying to fetch transaction metadata for " + transactionalId + " with coordinator epoch " + coordinatorEpoch + "; cancel sending markers to its partition leaders");
                                return BoxesRunTime.boxToBoolean(this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                            }
                            if (either instanceof Right) {
                                bl = true;
                                right = (Right)either;
                                Option option4 = (Option)right.value();
                                if (option4 instanceof Some) {
                                    Some some = (Some)option4;
                                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                                    if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch) {
                                        this.info((Function0<String> & Serializable)() -> "The cached metadata has changed to " + epochAndMetadata + " (old coordinator epoch is " + coordinatorEpoch + ") since preparing to send markers; cancel sending markers to its partition leaders");
                                        return BoxesRunTime.boxToBoolean(this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn));
                                    }
                                    this.info((Function0<String> & Serializable)() -> "Couldn't find leader endpoint for partitions " + set + " while trying to send transaction markers for " + transactionalId + ", these partitions are likely deleted already and hence can be skipped");
                                    TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                                    txnMetadata.inLock(() -> set.foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
                                        txnMetadata.removePartition(topicPartition);
                                        return BoxedUnit.UNIT;
                                    }));
                                    this.maybeWriteTxnCompletion(transactionalId);
                                    return BoxedUnit.UNIT;
                                }
                            }
                            if (bl && None$.MODULE$.equals(option3 = (Option)right.value())) {
                                String errorMsg = "The coordinator still owns the transaction partition for " + transactionalId + ", but there is no metadata in the cache; this is not expected";
                                this.fatal((Function0<String> & Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError(either);
                        }
                        throw new MatchError(option2);
                    }
                }
            }
            throw new MatchError(tuple2);
        });
        this.wakeup();
    }

    public void removeMarkersForTxnTopicPartition(int txnTopicPartitionId) {
        this.markersQueueForUnknownBroker().removeMarkersForTxnTopicPartition(txnTopicPartitionId).foreach((Function1<BlockingQueue, Object> & Serializable)queue -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$1(this, txnTopicPartitionId, queue);
            return BoxedUnit.UNIT;
        });
        this.markersQueuePerBroker().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$4(this, txnTopicPartitionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void removeMarkersForTxn(PendingCompleteTxn pendingCompleteTxn) {
        String transactionalId = pendingCompleteTxn.transactionalId();
        boolean removed = this.transactionsWithPendingMarkers().remove(transactionalId, pendingCompleteTxn);
        if (!removed) {
            PendingCompleteTxn current = this.transactionsWithPendingMarkers().get(transactionalId);
            if (current != null) {
                this.info((Function0<String> & Serializable)() -> "Failed to remove pending marker entry " + current + " trying to remove " + pendingCompleteTxn);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$1(TransactionMarkerChannelManager $this) {
        return $this.markersQueueForUnknownBroker().totalNumMarkers();
    }

    public static final /* synthetic */ int $anonfun$new$2(TransactionMarkerChannelManager $this) {
        return $this.txnLogAppendRetryQueue().size();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(TransactionMarkerChannelManager $this, String name) {
        $this.metricsGroup().removeMetric(name);
    }

    public static final /* synthetic */ int $anonfun$generateRequests$1(ArrayList pendingCompleteTxnAndMarkerEntries$1, int x0$1, BlockingQueue x1$1) {
        Tuple2<Integer, BlockingQueue> tuple2 = new Tuple2<Integer, BlockingQueue>(BoxesRunTime.boxToInteger(x0$1), x1$1);
        if (tuple2 != null) {
            BlockingQueue queue = tuple2._2();
            return queue.drainTo(pendingCompleteTxnAndMarkerEntries$1);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(PendingCompleteTxnAndMarkerEntry check$ifrefutable$1) {
        PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarkerEntry = check$ifrefutable$1;
        return pendingCompleteTxnAndMarkerEntry != null;
    }

    public static final /* synthetic */ void $anonfun$generateRequests$3(TransactionMarkerChannelManager $this, PendingCompleteTxnAndMarkerEntry pendingCompleteTxnAndMarker) {
        long producerId = pendingCompleteTxnAndMarker.txnMarkerEntry().producerId();
        short producerEpoch = pendingCompleteTxnAndMarker.txnMarkerEntry().producerEpoch();
        TransactionResult txnResult = pendingCompleteTxnAndMarker.txnMarkerEntry().transactionResult();
        PendingCompleteTxn pendingCompleteTxn = pendingCompleteTxnAndMarker.pendingCompleteTxn();
        Set<TopicPartition> topicPartitions = CollectionConverters$.MODULE$.ListHasAsScala(pendingCompleteTxnAndMarker.txnMarkerEntry().partitions()).asScala().toSet();
        $this.addTxnMarkersToBrokerQueue(producerId, producerEpoch, txnResult, pendingCompleteTxn, topicPartitions);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$4(TransactionMarkerChannelManager $this, TxnMarkerQueue brokerRequestQueue) {
        return !$this.protected$hasInFlightRequests($this, brokerRequestQueue.destination());
    }

    public static final /* synthetic */ int $anonfun$generateRequests$6(ArrayList pendingCompleteTxnAndMarkerEntries$2, int x0$2, BlockingQueue x1$2) {
        Tuple2<Integer, BlockingQueue> tuple2 = new Tuple2<Integer, BlockingQueue>(BoxesRunTime.boxToInteger(x0$2), x1$2);
        if (tuple2 != null) {
            BlockingQueue queue = tuple2._2();
            return queue.drainTo(pendingCompleteTxnAndMarkerEntries$2);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$7(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            ArrayList entries = (ArrayList)tuple2._2();
            return !entries.isEmpty();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybeWriteTxnCompletion$1(TransactionMarkerChannelManager $this, String transactionalId$2, PendingCompleteTxn pendingCompleteTxn) {
        if (!$this.hasPendingMarkersToWrite(pendingCompleteTxn.txnMetadata()) && $this.transactionsWithPendingMarkers().remove(transactionalId$2, pendingCompleteTxn)) {
            $this.writeTxnCompletion(pendingCompleteTxn);
            return;
        }
    }

    private final void appendCallback$1(Errors error, PendingCompleteTxn txnLogAppend$2) {
        Errors errors = error;
        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            this.trace((Function0<String> & Serializable)() -> "Completed transaction for " + txnLogAppend$2.transactionalId() + " with coordinator epoch " + txnLogAppend$2.coordinatorEpoch() + ", final state after commit: " + txnLogAppend$2.txnMetadata().state());
            return;
        }
        if (((Object)((Object)Errors.NOT_COORDINATOR)).equals((Object)errors)) {
            this.info((Function0<String> & Serializable)() -> "No longer the coordinator for transactionalId: " + txnLogAppend$2.transactionalId() + " while trying to append to transaction log, skip writing to transaction log");
            return;
        }
        if (((Object)((Object)Errors.COORDINATOR_NOT_AVAILABLE)).equals((Object)errors)) {
            this.info((Function0<String> & Serializable)() -> "Not available to append " + txnLogAppend$2 + ": possible causes include " + Errors.UNKNOWN_TOPIC_OR_PARTITION + ", " + Errors.NOT_ENOUGH_REPLICAS + ", " + Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND + " and " + Errors.REQUEST_TIMED_OUT + "; retry appending");
            this.txnLogAppendRetryQueue().add(txnLogAppend$2);
            return;
        }
        if (((Object)((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS)).equals((Object)errors)) {
            this.info((Function0<String> & Serializable)() -> "Coordinator is loading the partition " + $this.txnStateManager.partitionFor(txnLogAppend$2.transactionalId()) + " and hence cannot complete append of " + txnLogAppend$2 + "; skip writing to transaction log as the loading process should complete it");
            return;
        }
        if (errors != null) {
            Errors errors2 = errors;
            String errorMsg = "Unexpected error " + errors2.exceptionName() + " while appending to transaction log for " + txnLogAppend$2.transactionalId();
            this.fatal((Function0<String> & Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        throw new MatchError((Object)errors);
    }

    public static final /* synthetic */ boolean $anonfun$tryAppendToLog$7(Errors x$5) {
        Errors errors = x$5;
        Errors errors2 = Errors.COORDINATOR_NOT_AVAILABLE;
        return !(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$addTxnMarkersToBrokerQueue$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 != null) {
            Option broker = (Option)tuple2._1();
            Set topicPartitions = (Set)tuple2._2();
            if (broker != null && topicPartitions != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$2(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String> & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker -1");
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$1(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(queue).asScala().foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$2($this, txnTopicPartitionId$1, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$6(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, PendingCompleteTxnAndMarkerEntry entry) {
        $this.info((Function0<String> & Serializable)() -> "Removing " + entry + " for txn partition " + txnTopicPartitionId$1 + " to destination broker " + brokerId$2);
        $this.removeMarkersForTxn(entry.pendingCompleteTxn());
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$5(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, int brokerId$2, BlockingQueue queue) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(queue).asScala().foreach((Function1<PendingCompleteTxnAndMarkerEntry, Object> & Serializable)entry -> {
            TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$6($this, txnTopicPartitionId$1, brokerId$2, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeMarkersForTxnTopicPartition$4(TransactionMarkerChannelManager $this, int txnTopicPartitionId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int brokerId = tuple2._1$mcI$sp();
            TxnMarkerQueue brokerQueue = (TxnMarkerQueue)tuple2._2();
            brokerQueue.removeMarkersForTxnTopicPartition(txnTopicPartitionId$1).foreach((Function1<BlockingQueue, Object> & Serializable)queue -> {
                TransactionMarkerChannelManager.$anonfun$removeMarkersForTxnTopicPartition$5($this, txnTopicPartitionId$1, brokerId, queue);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public TransactionMarkerChannelManager(KafkaConfig config, MetadataCache metadataCache, NetworkClient networkClient, TransactionStateManager txnStateManager, Time time) {
        this.metadataCache = metadataCache;
        this.txnStateManager = txnStateManager;
        this.time = time;
        super("TxnMarkerSenderThread-" + config.brokerId(), networkClient, config.requestTimeoutMs(), time);
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.logIdent_$eq("[Transaction Marker Channel Manager " + config.brokerId() + "]: ");
        this.interBrokerListenerName = config.interBrokerListenerName();
        this.markersQueuePerBroker = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.markersQueueForUnknownBroker = new TxnMarkerQueue(Node.noNode());
        this.txnLogAppendRetryQueue = new LinkedBlockingQueue();
        this.transactionsWithPendingMarkers = new ConcurrentHashMap();
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$UnknownDestinationQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger(TransactionMarkerChannelManager.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(TransactionMarkerChannelManager$.MODULE$.kafka$coordinator$transaction$TransactionMarkerChannelManager$$LogAppendRetryQueueSizeMetricName(), () -> BoxesRunTime.boxToInteger(TransactionMarkerChannelManager.$anonfun$new$2(this)));
    }
}

