/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditJobSummary$;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager$;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.ClusterLinkTruncationRequest;
import kafka.durability.audit.request.DeleteMessagesRequest;
import kafka.durability.audit.request.DeletePartitionRequest;
import kafka.durability.audit.request.DestLogEpochChangeRequest;
import kafka.durability.audit.request.EpochChangeRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.HighWatermarkUpdateRequest;
import kafka.durability.audit.request.ISRExpandRequest;
import kafka.durability.audit.request.MirrorStateChangeRequest;
import kafka.durability.audit.request.RegisterPartitionRequest;
import kafka.durability.audit.request.RetentionConfigChangeRequest;
import kafka.durability.audit.request.StartOffsetChangeRequest;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent$;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeletePartitionEvent$;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.DeleteRecordsEvent$;
import kafka.durability.events.broker.DestLogEpochChangeEvent;
import kafka.durability.events.broker.DestLogEpochChangeEvent$;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.EpochChangeEvent$;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.IsrExpandEvent$;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent$;
import kafka.durability.events.broker.OffsetChangeEvent$;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.materialization.BrokerDurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcIJ$sp;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t%c\u0001B\u0017/\u0001]B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\n\u0005\u0002\u0011\t\u0011)A\u0005}\rC\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005]\u0001\t\u0015\r\u0011\"\u0011^\u0011%Y\u0007A!A!\u0002\u0013qF\u000eC\u0003n\u0001\u0011\u0005a\u000e\u0003\u0005u\u0001\t\u0007I\u0011\u0001\u0019v\u0011\u001d\t)\u0002\u0001Q\u0001\nYD\u0011\"a\u0006\u0001\u0001\u0004%I!!\u0007\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0002\u0002CA\u0018\u0001\u0001\u0006K!a\u0007\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0002\"CA\"\u0001\u0001\u0007I\u0011AA#\u0011!\tI\u0005\u0001Q!\n\u0005u\u0002\"CA&\u0001\t\u0007I\u0011IA'\u0011!\tY\u0006\u0001Q\u0001\n\u0005=\u0003BCA/\u0001\t\u0007I\u0011\t\u0019\u0002`!A\u0011Q\u000e\u0001!\u0002\u0013\t\t\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u0011\u0005M\u0004\u0001\"\u00111\u0003kBq!a!\u0001\t\u0013\t)\t\u0003\u0005\u0002\u000e\u0002!\t\u0001MAH\u0011)\ti\nAI\u0001\n\u0003\u0001\u0014q\u0014\u0005\u000b\u0003k\u0003\u0011\u0013!C\u0001a\u0005}\u0005BCA\\\u0001E\u0005I\u0011\u0001\u0019\u0002 \"9\u0011\u0011\u0018\u0001\u0005\n\u0005E\u0004\u0002CA^\u0001\u0011\u0005\u0003'!0\t\u0015\u0005\u0005\u0007!%A\u0005\u0002A\ny\nC\u0004\u0002D\u0002!I!!2\t\u0011\u0005E\u0007\u0001\"\u00011\u0003'Dq!!9\u0001\t\u0013\t\u0019\u000fC\u0005\u0002x\u0002\t\n\u0011\"\u0003\u0002 \"9\u0011\u0011 \u0001\u0005\n\u0005m\bb\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\t\u0005'\u0001A\u0011\u0001\u0019\u0003\u0016!Q!1\u0004\u0001\u0012\u0002\u0013\u0005\u0001'a(\t\u000f\tu\u0001\u0001\"\u0003\u0003 !A!\u0011\u0006\u0001\u0005\u0002A\n\t\bC\u0004\u0003,\u0001!\tA!\f\b\u000f\tUb\u0006#\u0001\u00038\u00191QF\fE\u0001\u0005sAa!\\\u0016\u0005\u0002\t\u001d#A\u0005\"s_.,'/Q;eSRl\u0015M\\1hKJT!a\f\u0019\u0002\u000f5\fg.Y4fe*\u0011\u0011GM\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003gQ\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005)\u0014!B6bM.\f7\u0001A\n\u0003\u0001a\u0002\"!\u000f\u001e\u000e\u00039J!a\u000f\u0018\u0003)\u0005\u00137\u000f\u001e:bGR\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\ta\b\u0005\u0002@\u00016\t\u0001'\u0003\u0002Ba\t)B)\u001e:bE&d\u0017\u000e^=Bk\u0012LGoQ8oM&<\u0017aB2p]\u001aLw\rI\u0005\u0003yi\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001G!\t9%*D\u0001I\u0015\tIE'\u0001\u0004tKJ4XM]\u0005\u0003\u0017\"\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\u0007=\u0013F+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019y\u0005\u000f^5p]B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0006gR|'/\u001a\u0006\u00033R\nA\u0001^5fe&\u00111L\u0016\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006!A/[7f+\u0005q\u0006CA0j\u001b\u0005\u0001'BA1c\u0003\u0015)H/\u001b7t\u0015\t\u0019G-\u0001\u0004d_6lwN\u001c\u0006\u0003k\u0015T!AZ4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0017aA8sO&\u0011!\u000e\u0019\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0003\u0002]u\u00051A(\u001b8jiz\"Ra\u001c9reN\u0004\"!\u000f\u0001\t\u000bqB\u0001\u0019\u0001 \t\u000b\u0011C\u0001\u0019\u0001$\t\u000b5C\u0001\u0019\u0001(\t\u000bqC\u0001\u0019\u00010\u00027!Lw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;t+\u00051\bCB<\u007f\u0003\u0003\tI!D\u0001y\u0015\tI(0\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001f?\u0002\tU$\u0018\u000e\u001c\u0006\u0002{\u0006!!.\u0019<b\u0013\ty\bPA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004B!a\u0001\u0002\u00065\t!-C\u0002\u0002\b\t\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001M\u0001\be\u0016\fX/Z:u\u0013\u0011\t\u0019\"!\u0004\u00035!Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;\u00029!Lw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;tA\u0005\u0011B.Y:u\u0005\u0006$8\r[#wK:$H+[7f+\t\tY\u0002E\u0002P\u0003;I1!a\bQ\u0005\u0011auN\\4\u0002-1\f7\u000f\u001e\"bi\u000eDWI^3oiRKW.Z0%KF$B!!\n\u0002,A\u0019q*a\n\n\u0007\u0005%\u0002K\u0001\u0003V]&$\b\"CA\u0017\u0019\u0005\u0005\t\u0019AA\u000e\u0003\rAH%M\u0001\u0014Y\u0006\u001cHOQ1uG\",e/\u001a8u)&lW\r\t\u0015\u0004\u001b\u0005M\u0002cA(\u00026%\u0019\u0011q\u0007)\u0003\u0011Y|G.\u0019;jY\u0016\fq\"Y;eSRTuNY*v[6\f'/_\u000b\u0003\u0003{\u00012aPA \u0013\r\t\t\u0005\r\u0002\u0010\u0003V$\u0017\u000e\u001e&pEN+X.\\1ss\u0006\u0019\u0012-\u001e3ji*{'mU;n[\u0006\u0014\u0018p\u0018\u0013fcR!\u0011QEA$\u0011%\ticDA\u0001\u0002\u0004\ti$\u0001\tbk\u0012LGOS8c'VlW.\u0019:zA\u0005YQ.\u0019;fe&\fG.\u001b>f+\t\ty\u0005\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)FM\u0001\u0010[\u0006$XM]5bY&T\u0018\r^5p]&!\u0011\u0011LA*\u0005\u0005\u0012%o\\6fe\u0012+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u00031i\u0017\r^3sS\u0006d\u0017N_3!\u00031!x\u000e]5d\u001b\u0006t\u0017mZ3s+\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GM\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003W\n)G\u0001\fEkJ\f'-\u001b7jif$v\u000e]5d\u001b\u0006t\u0017mZ3s\u00035!x\u000e]5d\u001b\u0006t\u0017mZ3sA\u00051Am\\,pe.$\"!!\n\u0002\u001d\r\u0014X-\u0019;f\u0003V$\u0017\u000e\u001e&pER\u0011\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u0010\u0019\u0002\u0007)|'-\u0003\u0003\u0002\u0002\u0006m$A\u0004\"s_.,'/Q;eSRTuNY\u0001\u0018g\u0016tG-\u0012<f]R\u0014\u0015\r^2i)&lWm\u00115fG.,\"!a\"\u0011\u0007=\u000bI)C\u0002\u0002\fB\u0013qAQ8pY\u0016\fg.\u0001\u0007e_^{'o[!diV\fG\u000e\u0006\u0005\u0002&\u0005E\u0015QSAM\u0011%\t\u0019\n\u0007I\u0001\u0002\u0004\t9)\u0001\ttG\",G-\u001e7f\u0003V$\u0017\u000e\u001e&pE\"I\u0011q\u0013\r\u0011\u0002\u0003\u0007\u0011qQ\u0001\u000bM2,8\u000f\u001b\"bi\u000eD\u0007\"CAN1A\u0005\t\u0019AAD\u0003-)8/\u001a'pG\u0006dGj\\4\u0002-\u0011|wk\u001c:l\u0003\u000e$X/\u00197%I\u00164\u0017-\u001e7uIE*\"!!)+\t\u0005\u001d\u00151U\u0016\u0003\u0003K\u0003B!a*\u000226\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0016)\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0006%&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061Bm\\,pe.\f5\r^;bY\u0012\"WMZ1vYR$#'\u0001\fe_^{'o[!diV\fG\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003E\u0001(o\\2fgN,e/\u001a8u\u0005\u0006$8\r[\u0001\u0012M2,8\u000f\u001b*fG>\u0014Hm])vKV,G\u0003BA\u0013\u0003\u007fC\u0011\"a'\u001e!\u0003\u0005\r!a\"\u00027\u0019dWo\u001d5SK\u000e|'\u000fZ:Rk\u0016,X\r\n3fM\u0006,H\u000e\u001e\u00132\u0003U1W\r^2i\u000bB|7\r[%g\u0019\u0016\fG-\u001a:M_\u001e$B!a2\u0002NB\u0019q*!3\n\u0007\u0005-\u0007KA\u0002J]RDq!a4 \u0001\u0004\t\t!\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002?\u0019,Go\u00195EkJ\f'-\u001b7jif\fU\u000fZ5u\u001b&\u0014(o\u001c:Ti\u0006$X\r\u0006\u0003\u0002V\u0006}\u0007\u0003B(S\u0003/\u0004B!!7\u0002\\6\t!'C\u0002\u0002^J\u0012!\u0004R;sC\nLG.\u001b;z\u0003V$\u0017\u000e^'jeJ|'o\u0015;bi\u0016Dq!a4!\u0001\u0004\t\t!\u0001\u0007jgJ+w-[:uKJ,G\r\u0006\u0005\u0002\b\u0006\u0015\u0018q^Az\u0011\u001d\t9/\ta\u0001\u0003S\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\t\u0005\r\u00111^\u0005\u0004\u0003[\u0014'\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\t\t0\ta\u0001\u0003\u000f\fQ!\u001a9pG\"D\u0011\"!>\"!\u0003\u0005\r!a\"\u0002\u001b%\u001cX\t]8dQ\u000eC\u0017M\\4f\u0003YI7OU3hSN$XM]3eI\u0011,g-Y;mi\u0012\u001a\u0014AG5t'R\fG.\u001a#fY\u0016$XMU3d_J$'+Z9vKN$H\u0003BAD\u0003{Dq!a@$\u0001\u0004\u0011\t!\u0001\u0004sK\u000e|'\u000f\u001a\t\u0005\u0003\u0017\u0011\u0019!\u0003\u0003\u0003\u0006\u00055!!\u0006#fY\u0016$X-T3tg\u0006<Wm\u001d*fcV,7\u000f^\u0001\u0013[\u0006$8\r\u001b*fG>\u0014H\rV8qS\u000eLE\r\u0006\u0003\u0002\b\n-\u0001bBA\u0000I\u0001\u0007!Q\u0002\t\u0005\u0003\u0017\u0011y!\u0003\u0003\u0003\u0012\u00055!aE!vI&$X*\u00198bO\u0016\u0014(+Z9vKN$\u0018!C:f]\u0012,e/\u001a8u)\u0019\t9Ia\u0006\u0003\u001a!9\u0011q`\u0013A\u0002\t5\u0001\"CANKA\u0005\t\u0019AAD\u0003M\u0019XM\u001c3Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003E\u0011XmZ5ti\u0016\u0014\b+\u0019:uSRLwN\u001c\u000b\u0005\u0003K\u0011\t\u0003C\u0004\u0002\u0000\u001e\u0002\rAa\t\u0011\t\u0005-!QE\u0005\u0005\u0005O\tiA\u0001\rSK\u001eL7\u000f^3s!\u0006\u0014H/\u001b;j_:\u0014V-];fgR\fqa\u00197fC:,\b/A\bhKR\fV/Z;fI\u00163XM\u001c;t+\t\u0011y\u0003E\u0004P\u0005c\t9-a\u0007\n\u0007\tM\u0002K\u0001\u0004UkBdWMM\u0001\u0013\u0005J|7.\u001a:Bk\u0012LG/T1oC\u001e,'\u000f\u0005\u0002:WM)1Fa\u000f\u0003BA\u0019qJ!\u0010\n\u0007\t}\u0002K\u0001\u0004B]f\u0014VM\u001a\t\u0004s\t\r\u0013b\u0001B#]\t9\"I]8lKJ\fU\u000fZ5u\u001b\u0006t\u0017mZ3s)J\f\u0017\u000e\u001e\u000b\u0003\u0005o\u0001")
public class BrokerAuditManager
extends AbstractAuditManager {
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests;
    private volatile long lastBatchEventTime;
    private AuditJobSummary auditJobSummary;
    private final BrokerDurabilityEventsMaterialize materialize;
    private final DurabilityTopicManager topicManager;

    public static void submitAuditRequest(AuditManagerRequest auditRequest) {
        BrokerAuditManager$.MODULE$.submitAuditRequest(auditRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return BrokerAuditManager$.MODULE$.stopAuditManager$default$1();
    }

    public static void stopAuditManager(boolean shutdown) {
        BrokerAuditManager$.MODULE$.stopAuditManager(shutdown);
    }

    public static Option<BrokerAuditManager> initialize(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        return BrokerAuditManager$.MODULE$.initialize(config, replicaManager, tierObjectStoreOpt, time);
    }

    public static ConcurrentHashMap<TopicIdPartition, RegisterPartitionRequest> pendingRegistration() {
        return BrokerAuditManager$.MODULE$.pendingRegistration();
    }

    public static void reconfigureConfigValues(String events, String checks, long ioRequestBytePerSecond) {
        BrokerAuditManager$.MODULE$.reconfigureConfigValues(events, checks, ioRequestBytePerSecond);
    }

    public static void startAuditManager() {
        BrokerAuditManager$.MODULE$.startAuditManager();
    }

    public static void instance_$eq(AbstractAuditManager x$1) {
        BrokerAuditManager$.MODULE$.instance_$eq(x$1);
    }

    public static AbstractAuditManager instance() {
        return BrokerAuditManager$.MODULE$.instance();
    }

    @Override
    public DurabilityAuditConfig config() {
        return super.config();
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public Time time() {
        return super.time();
    }

    public ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests() {
        return this.highWatermarkUpdateRequests;
    }

    private long lastBatchEventTime() {
        return this.lastBatchEventTime;
    }

    private void lastBatchEventTime_$eq(long x$1) {
        this.lastBatchEventTime = x$1;
    }

    public AuditJobSummary auditJobSummary() {
        return this.auditJobSummary;
    }

    public void auditJobSummary_$eq(AuditJobSummary x$1) {
        this.auditJobSummary = x$1;
    }

    @Override
    public BrokerDurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    @Override
    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void doWork() {
        this.doWorkActual(true, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public BrokerAuditJob createAuditJob() {
        return new BrokerAuditJob(this.db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), this.auditJobCountdownLatch(), this.reporter(), this.auditJobSummary(), this.currentJobId(), this.tierObjectStoreOpt, this.time(), this.auditChecks(), this.auditConfig(), this.db(), new Some<ReplicaManager>(this.replicaManager()), BrokerAuditJob$.MODULE$.$lessinit$greater$default$13(), BrokerAuditJob$.MODULE$.$lessinit$greater$default$14());
    }

    private boolean sendEventBatchTimeCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastBatchEventTime() >= this.config().batchEventFlushFrequencyMs()) {
            this.lastBatchEventTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        Object object = scheduleAuditJob && this.shouldScheduleNewAuditJob() && this.config().auditChecks().contains(DurabilityAuditCheck$.MODULE$.PeriodicalAudit()) ? super.scheduleNewAuditJob() : BoxedUnit.UNIT;
        if (this.sendEventHealthCheck()) {
            BrokerAuditManager$.MODULE$.submitAuditRequest(new HealthCheckRequest(this.healthCheckPartition(), -1, this.topicConfig().brokerId(), this.time().milliseconds()));
        }
        if (this.sendEventBatchTimeCheck() || flushBatch) {
            this.processEventBatch();
            this.db().checkpoint();
            return;
        }
        this.flushRecordsQueue(useLocalLog);
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private void processEventBatch() {
        this.debug((Function0<String> & Serializable)() -> "Process batchedRequest, auditRequest queue size is " + this.highWatermarkUpdateRequests().size());
        HashMap<TopicPartition, HighWatermarkUpdateRequest> snapshot = new HashMap<TopicPartition, HighWatermarkUpdateRequest>(this.highWatermarkUpdateRequests());
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int size = this.auditRequestsQueue().size(); size > 0 && record != null; --size) {
            if (this.sendEvent(record, this.sendEvent$default$2())) {
                snapshot.remove(record.topicIdPartition().topicPartition());
                v0 = this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            } else {
                v0 = BoxedUnit.UNIT;
            }
            record = this.auditRequestsQueue().poll();
        }
        snapshot.forEach((x0$1, x1$1) -> {
            Tuple2<TopicPartition, HighWatermarkUpdateRequest> tuple2 = new Tuple2<TopicPartition, HighWatermarkUpdateRequest>((TopicPartition)x0$1, (HighWatermarkUpdateRequest)x1$1);
            if (tuple2 != null) {
                TopicPartition topicPartition = tuple2._1();
                HighWatermarkUpdateRequest record = tuple2._2();
                if (this.isRegistered(record.topicIdPartition(), record.epoch(), this.isRegistered$default$3())) {
                    this.topicManager().addDurabilityEvent(OffsetChangeEvent$.MODULE$.apply(record.topicIdPartition(), record.epoch(), record.hwm(), record.startOffset(), record.isr(), this.config().nodeId()));
                }
                this.highWatermarkUpdateRequests().remove(topicPartition);
                return;
            }
        });
        snapshot.clear();
    }

    @Override
    public void flushRecordsQueue(boolean useLocalLog) {
        int count = 0;
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        Queue<AuditManagerRequest> allQueueEvents = new Queue<AuditManagerRequest>(Queue$.MODULE$.$lessinit$greater$default$1());
        scala.collection.mutable.HashMap<TopicIdPartition, StartOffsetChangeRequest> lastStartOffsetChangeRequests = new scala.collection.mutable.HashMap<TopicIdPartition, StartOffsetChangeRequest>();
        scala.collection.mutable.HashMap<TopicIdPartition, Long> highestDeleteMessagesRequests = new scala.collection.mutable.HashMap<TopicIdPartition, Long>();
        scala.collection.mutable.HashMap<TopicIdPartition, ClusterLinkTruncationRequest> lastClusterLinkTruncationRequests = new scala.collection.mutable.HashMap<TopicIdPartition, ClusterLinkTruncationRequest>();
        while (count < DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP() && record != null) {
            AuditManagerRequest auditManagerRequest = record;
            if (auditManagerRequest instanceof StartOffsetChangeRequest) {
                StartOffsetChangeRequest startOffsetChangeRequest = (StartOffsetChangeRequest)auditManagerRequest;
                Option<StartOffsetChangeRequest> prevStartOffsetChangeRequestOpt = lastStartOffsetChangeRequests.put(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest);
                if (prevStartOffsetChangeRequestOpt.isEmpty()) {
                    ++count;
                }
            } else if (auditManagerRequest instanceof ClusterLinkTruncationRequest) {
                ClusterLinkTruncationRequest clusterLinkTruncationRequest = (ClusterLinkTruncationRequest)auditManagerRequest;
                Option<ClusterLinkTruncationRequest> prevClusterLinkTruncationRequestOpt = lastClusterLinkTruncationRequests.put(clusterLinkTruncationRequest.topicIdPartition(), clusterLinkTruncationRequest);
                if (prevClusterLinkTruncationRequestOpt.isEmpty()) {
                    ++count;
                }
            } else {
                ++count;
            }
            allQueueEvents.enqueue(record);
            if (count >= DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP()) continue;
            record = this.auditRequestsQueue().poll();
        }
        while (allQueueEvents.nonEmpty()) {
            record = (AuditManagerRequest)allQueueEvents.dequeue();
            AuditManagerRequest auditManagerRequest = record;
            if (auditManagerRequest instanceof StartOffsetChangeRequest) {
                StartOffsetChangeRequest startOffsetChangeRequest = (StartOffsetChangeRequest)auditManagerRequest;
                if (lastStartOffsetChangeRequests.apply(startOffsetChangeRequest.topicIdPartition()) == startOffsetChangeRequest) {
                    BoxesRunTime.boxToBoolean(this.sendEvent(startOffsetChangeRequest, useLocalLog));
                }
                continue;
            }
            if (auditManagerRequest instanceof DeleteMessagesRequest) {
                DeleteMessagesRequest deleteMessagesRequest = (DeleteMessagesRequest)auditManagerRequest;
                if (!highestDeleteMessagesRequests.contains(deleteMessagesRequest.topicIdPartition()) || highestDeleteMessagesRequests.contains(deleteMessagesRequest.topicIdPartition()) && BoxesRunTime.unboxToLong(highestDeleteMessagesRequests.apply(deleteMessagesRequest.topicIdPartition())) < deleteMessagesRequest.trimOffset()) {
                    this.sendEvent(deleteMessagesRequest, useLocalLog);
                    highestDeleteMessagesRequests.put(deleteMessagesRequest.topicIdPartition(), BoxesRunTime.boxToLong(deleteMessagesRequest.trimOffset()));
                }
                continue;
            }
            if (auditManagerRequest instanceof ClusterLinkTruncationRequest) {
                ClusterLinkTruncationRequest clusterLinkTruncationRequest = (ClusterLinkTruncationRequest)auditManagerRequest;
                if (lastClusterLinkTruncationRequests.apply(clusterLinkTruncationRequest.topicIdPartition()) == clusterLinkTruncationRequest) {
                    BoxesRunTime.boxToBoolean(this.sendEvent(clusterLinkTruncationRequest, useLocalLog));
                }
                continue;
            }
            BoxesRunTime.boxToBoolean(this.sendEvent(record, useLocalLog));
        }
    }

    @Override
    public boolean flushRecordsQueue$default$1() {
        return true;
    }

    private int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
        return Utils$.MODULE$.getLocalReplicaEpochIfLeader(this.replicaManager(), topicPartition);
    }

    public Option<DurabilityAuditMirrorState> fetchDurabilityAuditMirrorState(TopicPartition topicPartition) {
        return Utils$.MODULE$.getDurabilityAuditMirrorState(this.replicaManager(), topicPartition);
    }

    private boolean isRegistered(TopicIdPartition topicIdPartition, int epoch, boolean isEpochChange) {
        PartitionState state;
        boolean bl = false;
        Some some = null;
        Option<PartitionState> option = this.db().fetchPartitionState(topicIdPartition.topicPartition());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            PartitionState state2 = (PartitionState)some.value();
            if (state2.mirrorState().isDefined() && !this.config().auditChecks().contains(DurabilityAuditCheck$.MODULE$.MirrorTopicAudit())) {
                return false;
            }
        }
        if (bl && (state = (PartitionState)some.value()).isLeader() && (state.latestLocalEpoch() == epoch || isEpochChange && epoch == -1)) {
            return true;
        }
        int localEpoch = this.fetchEpochIfLeaderLog(topicIdPartition.topicPartition());
        Option<String> durabilityAuditMirrorState = this.fetchDurabilityAuditMirrorState(topicIdPartition.topicPartition()).map((Function1<DurabilityAuditMirrorState, String> & Serializable)x$1 -> x$1.getName());
        if (localEpoch == -1 || localEpoch > epoch || epoch == -1) {
            this.debug((Function0<String> & Serializable)() -> "partition: " + topicIdPartition.topicPartition() + " is not registered, localEpoch is " + localEpoch + ", epoch is " + epoch + ", mirrorState is " + durabilityAuditMirrorState);
            return false;
        }
        this.info((Function0<String> & Serializable)() -> "Durability registration for " + topicIdPartition + " was found missing, recovering for epoch " + epoch + " localEpoch " + localEpoch + ", mirrorState: " + durabilityAuditMirrorState);
        this.registerPartition(new RegisterPartitionRequest(topicIdPartition, localEpoch, true, durabilityAuditMirrorState));
        return true;
    }

    private boolean isRegistered$default$3() {
        return false;
    }

    private boolean isStaleDeleteRecordRequest(DeleteMessagesRequest record) {
        Some some;
        PartitionState state;
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        return !(option instanceof Some) || (state = (PartitionState)(some = (Some)option).value()).committedStartOffset() >= record.trimOffset();
    }

    private boolean matchRecordTopicId(AuditManagerRequest record) {
        TopicPartition topicPartition = record.topicIdPartition().topicPartition();
        if (this.replicaManager().logManager().getLog(topicPartition, this.replicaManager().logManager().getLog$default$2()).isEmpty()) {
            return true;
        }
        Optional<Uuid> topicIdOpt = this.replicaManager().logManager().getLog(topicPartition, this.replicaManager().logManager().getLog$default$2()).get().topicId();
        if (topicIdOpt.isEmpty()) {
            return true;
        }
        return topicIdOpt.get().equals(record.topicIdPartition().topicId());
    }

    public boolean sendEvent(AuditManagerRequest record, boolean useLocalLog) {
        None$ event;
        DestLogEpochChangeRequest destLogEpochChangeRequest;
        MirrorStateChangeRequest mirrorStateChangeRequest;
        ClusterLinkTruncationRequest clusterLinkTruncationRequest;
        DeletePartitionRequest deletePartitionRequest;
        DeleteMessagesRequest deleteMessagesRequest;
        ISRExpandRequest iSRExpandRequest;
        RetentionConfigChangeRequest retentionConfigChangeRequest;
        EpochChangeRequest epochChangeRequest;
        StartOffsetChangeRequest startOffsetChangeRequest;
        Option option;
        if (!this.matchRecordTopicId(record)) {
            this.error((Function0<String> & Serializable)() -> "Rejected record for sending as event " + record + " is from old topicPartition, ignoring");
            return false;
        }
        AuditManagerRequest auditManagerRequest = record;
        if (auditManagerRequest instanceof RegisterPartitionRequest) {
            RegisterPartitionRequest registerPartitionRequest = (RegisterPartitionRequest)auditManagerRequest;
            this.registerPartition(registerPartitionRequest);
            this.highWatermarkUpdateRequests().remove(registerPartitionRequest.topicIdPartition().topicPartition());
            option = None$.MODULE$;
        } else if (auditManagerRequest instanceof StartOffsetChangeRequest && this.isRegistered((startOffsetChangeRequest = (StartOffsetChangeRequest)auditManagerRequest).topicIdPartition(), startOffsetChangeRequest.epoch(), this.isRegistered$default$3())) {
            Option<Set<Object>> option2 = Utils$.MODULE$.getIsrIfLeaderPartition(this.replicaManager(), startOffsetChangeRequest.topicIdPartition().topicPartition());
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Set isr = (Set)some.value();
                option = new Some<StartOffsetChangeEvent>(StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), isr, this.config().nodeId()));
            } else {
                option = !useLocalLog ? new Some<StartOffsetChangeEvent>(StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicIdPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), this.config().nodeId())) : None$.MODULE$;
            }
        } else if (auditManagerRequest instanceof EpochChangeRequest && this.isRegistered((epochChangeRequest = (EpochChangeRequest)auditManagerRequest).topicIdPartition(), -1, true)) {
            option = new Some<EpochChangeEvent>(EpochChangeEvent$.MODULE$.apply(epochChangeRequest.topicIdPartition(), epochChangeRequest.firstOffset(), epochChangeRequest.epoch(), epochChangeRequest.highWaterMark(), epochChangeRequest.startOffset(), epochChangeRequest.isr(), this.config().nodeId()));
        } else if (auditManagerRequest instanceof RetentionConfigChangeRequest && this.isRegistered((retentionConfigChangeRequest = (RetentionConfigChangeRequest)auditManagerRequest).topicIdPartition(), retentionConfigChangeRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<RetentionChangeEvent>(RetentionChangeEvent$.MODULE$.apply(retentionConfigChangeRequest.topicIdPartition(), retentionConfigChangeRequest.retentionMs(), retentionConfigChangeRequest.retentionSz(), retentionConfigChangeRequest.epoch(), -1L, -1L, this.config().nodeId(), retentionConfigChangeRequest.isCompacted(), retentionConfigChangeRequest.isIndependentRetentionMirror()));
        } else if (auditManagerRequest instanceof ISRExpandRequest && this.isRegistered((iSRExpandRequest = (ISRExpandRequest)auditManagerRequest).topicIdPartition(), iSRExpandRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<IsrExpandEvent>(IsrExpandEvent$.MODULE$.apply(iSRExpandRequest.topicIdPartition(), iSRExpandRequest.brokerId(), iSRExpandRequest.epoch(), -1L, -1L, this.config().nodeId()));
        } else if (auditManagerRequest instanceof DeleteMessagesRequest && this.isRegistered((deleteMessagesRequest = (DeleteMessagesRequest)auditManagerRequest).topicIdPartition(), deleteMessagesRequest.epoch(), this.isRegistered$default$3()) && !this.isStaleDeleteRecordRequest(deleteMessagesRequest)) {
            option = new Some<DeleteRecordsEvent>(DeleteRecordsEvent$.MODULE$.apply(deleteMessagesRequest.topicIdPartition(), deleteMessagesRequest.trimOffset(), deleteMessagesRequest.epoch(), deleteMessagesRequest.highWatermark(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.isr(), this.config().nodeId()));
        } else if (auditManagerRequest instanceof DeletePartitionRequest && this.isRegistered((deletePartitionRequest = (DeletePartitionRequest)auditManagerRequest).topicIdPartition(), deletePartitionRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<DeletePartitionEvent>(DeletePartitionEvent$.MODULE$.apply(deletePartitionRequest.topicIdPartition(), deletePartitionRequest.epoch(), this.config().nodeId()));
        } else if (auditManagerRequest instanceof HealthCheckRequest) {
            HealthCheckRequest healthCheckRequest = (HealthCheckRequest)auditManagerRequest;
            option = new Some<HealthCheckEvent>(HealthCheckEvent$.MODULE$.apply(healthCheckRequest.topicIdPartition(), healthCheckRequest.epoch(), -1L, -1L, healthCheckRequest.nodeId(), healthCheckRequest.timeStamp()));
        } else if (auditManagerRequest instanceof ClusterLinkTruncationRequest && this.isRegistered((clusterLinkTruncationRequest = (ClusterLinkTruncationRequest)auditManagerRequest).topicIdPartition(), clusterLinkTruncationRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<ClusterLinkTruncationEvent>(ClusterLinkTruncationEvent$.MODULE$.apply(clusterLinkTruncationRequest.topicIdPartition(), clusterLinkTruncationRequest.epoch(), clusterLinkTruncationRequest.highWatermark(), clusterLinkTruncationRequest.startOffset(), clusterLinkTruncationRequest.isr(), clusterLinkTruncationRequest.offsetTruncateTo(), this.config().nodeId(), (byte)clusterLinkTruncationRequest.truncationType().id()));
        } else if (auditManagerRequest instanceof MirrorStateChangeRequest && this.isRegistered((mirrorStateChangeRequest = (MirrorStateChangeRequest)auditManagerRequest).topicIdPartition(), mirrorStateChangeRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<MirrorStateChangeEvent>(MirrorStateChangeEvent$.MODULE$.apply(mirrorStateChangeRequest.topicIdPartition(), mirrorStateChangeRequest.epoch(), mirrorStateChangeRequest.highWaterMark(), mirrorStateChangeRequest.startOffset(), mirrorStateChangeRequest.isr(), mirrorStateChangeRequest.mirrorState(), this.config().nodeId()));
        } else if (auditManagerRequest instanceof DestLogEpochChangeRequest && this.isRegistered((destLogEpochChangeRequest = (DestLogEpochChangeRequest)auditManagerRequest).topicIdPartition(), destLogEpochChangeRequest.epoch(), this.isRegistered$default$3())) {
            option = new Some<DestLogEpochChangeEvent>(DestLogEpochChangeEvent$.MODULE$.apply(destLogEpochChangeRequest.topicIdPartition(), destLogEpochChangeRequest.firstOffset(), destLogEpochChangeRequest.destLogEpoch(), destLogEpochChangeRequest.epoch(), destLogEpochChangeRequest.highWaterMark(), destLogEpochChangeRequest.startOffset(), destLogEpochChangeRequest.isr(), this.config().nodeId()));
        } else {
            this.debug((Function0<String> & Serializable)() -> "Rejected record for sending as event " + record + ", ignoring");
            option = None$.MODULE$;
        }
        None$ none$ = event = option;
        if (none$ instanceof Some) {
            Some some = (Some)((Object)none$);
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)some.value();
            this.topicManager().addDurabilityEvent(e);
            this.highWatermarkUpdateRequests().remove(record.topicIdPartition().topicPartition());
            return true;
        }
        return false;
    }

    public boolean sendEvent$default$2() {
        return true;
    }

    private void registerPartition(RegisterPartitionRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicIdPartition().topicPartition());
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionState state = (PartitionState)some.value();
            if (state.latestLocalEpoch() >= record.epoch()) {
                this.debug((Function0<String> & Serializable)() -> "Durability Registration event from stale/registered replica for " + record.topicIdPartition() + " for " + record.epoch() + " with leader flag set to " + record.isLeader() + ". The existing db state is " + state);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
        } else {
            throw new MatchError(option);
        }
        ObjectRef<PartitionState> state = ObjectRef.create((PartitionState)this.db().fetchPartitionState(record.topicIdPartition().topicPartition()).getOrElse((Function0<PartitionState> & Serializable)() -> PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), PartitionState$.MODULE$.apply$default$2())));
        Uuid uuid = ((PartitionState)state.elem).topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !((Object)uuid).equals(uuid2)) {
            Uuid uuid3 = record.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (uuid3 == null ? uuid4 != null : !((Object)uuid3).equals(uuid4)) {
                Uuid uuid5 = record.topicIdPartition().topicId();
                Uuid uuid6 = ((PartitionState)state.elem).topicId();
                if (uuid5 == null ? uuid6 != null : !((Object)uuid5).equals(uuid6)) {
                    this.info((Function0<String> & Serializable)() -> "Durability partition reset for " + record.topicIdPartition() + " old topicID " + ((PartitionState)state$2.elem).topicId() + " due to change in topicId likely due to missing partition deletion");
                    state.elem = PartitionState$.MODULE$.apply(record.topicIdPartition().topicPartition().partition(), ((PartitionState)state.elem).config());
                }
            }
        }
        ((PartitionState)state.elem).latestLocalEpoch_$eq(record.epoch());
        ((PartitionState)state.elem).isLeader_$eq(record.isLeader());
        ((PartitionState)state.elem).topicId_$eq(record.topicIdPartition().topicId());
        ((PartitionState)state.elem).mirrorState_$eq(record.mirrorState());
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), record.topicIdPartition().topicPartition())) {
            PartitionState partitionState = (PartitionState)state.elem;
            partitionState.config_$eq(partitionState.config() | (long)ConfigFlag$.MODULE$.OnceCompacted().id());
        }
        this.db().addPartition(record.topicIdPartition().topicPartition(), (PartitionState)state.elem);
        this.info((Function0<String> & Serializable)() -> "Durability registration for " + record.topicIdPartition() + " epoch: " + record.epoch() + " isLeader: " + record.isLeader() + " mirrorState: " + record.mirrorState() + " is done.");
    }

    public void cleanup() {
        try {
            Instant cleanupStart = Instant.ofEpochMilli(this.time().milliseconds());
            this.stopExistingAuditJob();
            this.processEventBatch();
            this.flushRecordsQueue(this.flushRecordsQueue$default$1());
            this.db().checkpoint();
            this.topicManager().shutdown();
            this.metricsManager().shutdown();
            long cleanupDuration = Duration.between(cleanupStart, Instant.ofEpochMilli(this.time().milliseconds())).toMillis();
            this.info((Function0<String> & Serializable)() -> "BrokerAuditManager cleanup complete in " + cleanupDuration + " ms");
        }
        catch (Exception e) {
            this.error((Function0<String> & Serializable)() -> "Received error while cleaning up BrokerAuditManager", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
        }
    }

    public Tuple2<Object, Object> getQueuedEvents() {
        return new Tuple2$mcIJ$sp(this.auditRequestsQueue().size(), this.highWatermarkUpdateRequests().size());
    }

    public BrokerAuditManager(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        super(config, time);
        this.highWatermarkUpdateRequests = new ConcurrentHashMap();
        this.lastBatchEventTime = time.milliseconds();
        this.auditJobSummary = AuditJobSummary$.MODULE$.apply();
        this.materialize = new BrokerDurabilityEventsMaterialize(replicaManager, this.db(), this.reporter(), time, config.ignoredEventTypesTobeLogged());
        this.topicManager = this.getTopicManager();
    }
}

